/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.demo.controller.test;

import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.demo.entity.test.WebOfficeEntity;
import org.jeecgframework.web.demo.service.test.WebOfficeServiceI;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/webOfficeController"})
public class WebOfficeController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WebOfficeController.class);
    @Autowired
    private WebOfficeServiceI webOfficeService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"webOffice"})
    public ModelAndView webOffice(HttpServletRequest request) {
        return new ModelAndView("jeecg/demo/test/webOfficeList");
    }

    @RequestMapping(params={"webOfficeSample"})
    public ModelAndView webOfficeSample(HttpServletRequest request) {
        return new ModelAndView("jeecg/demo/test/webOfficeSample");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WebOfficeEntity webOffice, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WebOfficeEntity.class, dataGrid);
        HqlGenerateUtil.installHql(cq, webOffice, request.getParameterMap());
        this.webOfficeService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(WebOfficeEntity webOffice, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        webOffice = (WebOfficeEntity)this.systemService.getEntity(WebOfficeEntity.class, webOffice.getId());
        this.message = "\u5220\u9664\u6210\u529f";
        this.webOfficeService.delete(webOffice);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(WebOfficeEntity webOffice, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty(webOffice.getId())) {
            this.message = "\u66f4\u65b0\u6210\u529f";
            WebOfficeEntity t = this.webOfficeService.get(WebOfficeEntity.class, webOffice.getId());
            try {
                MyBeanUtils.copyBeanNotNull2Bean(webOffice, t);
                this.webOfficeService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.message = "\u6dfb\u52a0\u6210\u529f";
            this.webOfficeService.save(webOffice);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(WebOfficeEntity webOffice, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(webOffice.getId())) {
            webOffice = (WebOfficeEntity)this.webOfficeService.getEntity(WebOfficeEntity.class, webOffice.getId());
            req.setAttribute("webOfficePage", (Object)webOffice);
        }
        return new ModelAndView("jeecg/demo/test/webOffice");
    }

    @RequestMapping(params={"newDocument"})
    public ModelAndView newDocument(WebOfficeEntity webOffice, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(webOffice.getId())) {
            webOffice = (WebOfficeEntity)this.webOfficeService.getEntity(WebOfficeEntity.class, webOffice.getId());
            req.setAttribute("docId", (Object)webOffice.getId());
            req.setAttribute("fileType", (Object)webOffice.getDoctype());
            req.setAttribute("docData", (Object)webOffice);
        } else {
            req.setAttribute("docId", (Object)"");
            req.setAttribute("fileType", (Object)req.getParameter("fileType"));
        }
        return new ModelAndView("jeecg/demo/test/webOfficeEdit");
    }

    @RequestMapping(params={"getDoc"})
    public void getDoc(HttpServletRequest request, Integer fileId, HttpServletResponse response) {
        WebOfficeEntity obj = (WebOfficeEntity)this.systemService.getEntity(WebOfficeEntity.class, fileId);
        try {
            int bytesRead;
            Blob attachment = obj.getDoccontent();
            response.setContentType("application/x-msdownload;");
            response.setHeader("Content-disposition", "attachment; filename=" + new String((String.valueOf(obj.getDoctitle()) + "." + obj.getDoctype()).getBytes("GBK"), "ISO8859-1"));
            InputStream bis = attachment.getBinaryStream();
            BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[2048];
            long lTotalLen = 0L;
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
                lTotalLen += (long)bytesRead;
            }
            response.setHeader("Content-Length", String.valueOf(lTotalLen));
            bos.flush();
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"saveDoc"})
    @ResponseBody
    public AjaxJson saveDoc(WebOfficeEntity webOffice, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            try {
                this.webOfficeService.saveObj(webOffice, file);
                j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
            }
            catch (Exception e) {
                j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                logger.error((Object)ExceptionUtil.getExceptionMessage(e));
            }
        }
        return j;
    }
}

