/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.demo.controller.test;

import java.io.Serializable;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.demo.entity.test.TFinanceEntity;
import org.jeecgframework.web.demo.entity.test.TFinanceFilesEntity;
import org.jeecgframework.web.demo.service.test.TFinanceServiceI;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/tFinanceController"})
public class TFinanceController
extends BaseController {
    private static final Logger logger = Logger.getLogger(TFinanceController.class);
    @Autowired
    private TFinanceServiceI tFinanceService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"tFinance"})
    public ModelAndView tFinance(HttpServletRequest request) {
        return new ModelAndView("jeecg/demo/test/tFinanceList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(TFinanceEntity tFinance, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TFinanceEntity.class, dataGrid);
        HqlGenerateUtil.installHql(cq, tFinance, request.getParameterMap());
        this.tFinanceService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"saveFiles"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveFiles(HttpServletRequest request, HttpServletResponse response, TFinanceFilesEntity financeFile) {
        AjaxJson j = new AjaxJson();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        String fileKey = oConvertUtils.getString(request.getParameter("fileKey"));
        String financeId = oConvertUtils.getString(request.getParameter("financeId"));
        if (StringUtil.isNotEmpty(fileKey)) {
            financeFile.setId(fileKey);
            financeFile = (TFinanceFilesEntity)this.systemService.getEntity(TFinanceFilesEntity.class, (Serializable)((Object)fileKey));
        }
        TFinanceEntity finance = (TFinanceEntity)this.systemService.getEntity(TFinanceEntity.class, (Serializable)((Object)financeId));
        financeFile.setFinance(finance);
        UploadFile uploadFile = new UploadFile(request, financeFile);
        uploadFile.setCusPath("files");
        uploadFile.setSwfpath("swfpath");
        uploadFile.setByteField(null);
        financeFile = (TFinanceFilesEntity)this.systemService.uploadFile(uploadFile);
        attributes.put("fileKey", financeFile.getId());
        attributes.put("viewhref", "commonController.do?objfileList&fileKey=" + financeFile.getId());
        attributes.put("delurl", "commonController.do?delObjFile&fileKey=" + financeFile.getId());
        j.setMsg("\u6587\u4ef6\u6dfb\u52a0\u6210\u529f");
        j.setAttributes(attributes);
        return j;
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(TFinanceEntity tFinance, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        tFinance = (TFinanceEntity)this.systemService.getEntity(TFinanceEntity.class, (Serializable)((Object)tFinance.getId()));
        this.message = "\u5220\u9664\u6210\u529f";
        this.tFinanceService.deleteFinance(tFinance);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(TFinanceEntity tFinance, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty(tFinance.getId())) {
            this.message = "\u66f4\u65b0\u6210\u529f";
            TFinanceEntity t = this.tFinanceService.get(TFinanceEntity.class, (Serializable)((Object)tFinance.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean(tFinance, t);
                this.tFinanceService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.message = "\u6dfb\u52a0\u6210\u529f";
            this.tFinanceService.save(tFinance);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setObj(tFinance);
        return j;
    }

    @RequestMapping(params={"delFile"})
    @ResponseBody
    public AjaxJson delFile(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String id = request.getParameter("id");
        TFinanceFilesEntity file = (TFinanceFilesEntity)this.systemService.getEntity(TFinanceFilesEntity.class, (Serializable)((Object)id));
        this.message = file.getAttachmenttitle() + "\u88ab\u5220\u9664\u6210\u529f";
        this.tFinanceService.deleteFile(file);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setSuccess(true);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(TFinanceEntity tFinance, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(tFinance.getId())) {
            tFinance = (TFinanceEntity)this.tFinanceService.getEntity(TFinanceEntity.class, (Serializable)((Object)tFinance.getId()));
            req.setAttribute("tFinancePage", (Object)tFinance);
        }
        return new ModelAndView("jeecg/demo/test/tFinance");
    }
}

