/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.demo.controller.test;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.demo.entity.test.OptimisticLockingEntity;
import org.jeecgframework.web.demo.service.test.OptimisticLockingServiceI;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/optimisticLockingController"})
public class OptimisticLockingController
extends BaseController {
    private static final Logger logger = Logger.getLogger(OptimisticLockingController.class);
    @Autowired
    private OptimisticLockingServiceI optimisticLockingService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"optimisticLocking"})
    public ModelAndView optimisticLocking(HttpServletRequest request) {
        return new ModelAndView("jeecg/demo/test/optimisticLockingList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(OptimisticLockingEntity optimisticLocking, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(OptimisticLockingEntity.class, dataGrid);
        HqlGenerateUtil.installHql(cq, optimisticLocking, request.getParameterMap());
        this.optimisticLockingService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(OptimisticLockingEntity optimisticLocking, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        optimisticLocking = (OptimisticLockingEntity)this.systemService.getEntity(OptimisticLockingEntity.class, (Serializable)((Object)optimisticLocking.getId()));
        this.message = "\u5220\u9664\u6210\u529f";
        this.optimisticLockingService.delete(optimisticLocking);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(OptimisticLockingEntity optimisticLocking, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty(optimisticLocking.getId())) {
            this.message = "\u66f4\u65b0\u6210\u529f";
            OptimisticLockingEntity t = this.optimisticLockingService.get(OptimisticLockingEntity.class, (Serializable)((Object)optimisticLocking.getId()));
            try {
                LogUtil.info("\u63d0\u4ea4\u7684\u7248\u672c\u53f7\uff1a" + optimisticLocking.getVer() + "\uff0c\u5f53\u524d\u7248\u672c\u53f7\uff1a" + t.getVer());
                if (optimisticLocking.getVer() < t.getVer()) {
                    j.setSuccess(false);
                    j.setMsg("\u63d0\u4ea4\u7684\u6570\u636e\u5df2\u8fc7\u671f");
                    throw new Exception("\u63d0\u4ea4\u7684\u6570\u636e\u5df2\u8fc7\u671f");
                }
                MyBeanUtils.copyBeanNotNull2Bean(optimisticLocking, t);
                this.optimisticLockingService.updateEntitie(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.message = "\u6dfb\u52a0\u6210\u529f";
            this.optimisticLockingService.save(optimisticLocking);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(OptimisticLockingEntity optimisticLocking, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(optimisticLocking.getId())) {
            optimisticLocking = (OptimisticLockingEntity)this.optimisticLockingService.getEntity(OptimisticLockingEntity.class, (Serializable)((Object)optimisticLocking.getId()));
            req.setAttribute("optimisticLockingPage", (Object)optimisticLocking);
        }
        return new ModelAndView("jeecg/demo/test/optimisticLocking");
    }
}

