/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.demo.controller.test;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.UUIDGenerator;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.demo.entity.test.JpPersonEntity;
import org.jeecgframework.web.demo.service.test.JpPersonServiceI;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/jpPersonController"})
public class JpPersonController
extends BaseController {
    private static final Logger logger = Logger.getLogger(JpPersonController.class);
    @Autowired
    private JpPersonServiceI jpPersonService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"jpPerson"})
    public ModelAndView jpPerson(HttpServletRequest request) {
        return new ModelAndView("jeecg/demo/test/jpPersonList");
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u7528\u6237\u4fe1\u606f";
                String browse = BrowserUtils.checkBrowse(request);
                if ("MSIE".equalsIgnoreCase(browse.substring(0, 4))) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                List<JpPersonEntity> jpPersons = this.jpPersonService.loadAll(JpPersonEntity.class);
                workbook = ExcelExportUtil.exportExcel(new ExcelTitle(null, null, "\u5bfc\u51fa\u4fe1\u606f"), JpPersonEntity.class, jpPersons);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {
                }
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"goImplXls"})
    public ModelAndView goImplXls(HttpServletRequest request) {
        return new ModelAndView("jeecg/demo/test/upload");
    }

    @RequestMapping(params={"implXls"})
    @ResponseBody
    public AjaxJson implXls(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest mulRequest = (MultipartHttpServletRequest)request;
        MultipartFile file = mulRequest.getFile("filedata");
        try {
            boolean isSuccess = true;
            List listPersons = (List)ExcelUtil.importExcelByIs(file.getInputStream(), JpPersonEntity.class);
            for (JpPersonEntity person : listPersons) {
                person.setId(UUIDGenerator.generate());
                if (person.getAge() == null || person.getCreatedt() == null || person.getSalary() == null) {
                    isSuccess = false;
                    break;
                }
                this.jpPersonService.save(person);
            }
            if (isSuccess) {
                j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
            } else {
                j.setMsg("\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5bfc\u5165\u5931\u8d25\uff01");
            }
        }
        catch (IOException e) {
            j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
            logger.error((Object)ExceptionUtil.getExceptionMessage(e));
        }
        catch (Exception e) {
            j.setMsg("\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5bfc\u5165\u5931\u8d25\uff01");
        }
        return j;
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            try {
                List listPersons = (List)ExcelUtil.importExcelByIs(file.getInputStream(), JpPersonEntity.class);
                for (JpPersonEntity person : listPersons) {
                    if (person.getAge() == null) continue;
                    person.setId(UUIDGenerator.generate());
                    this.jpPersonService.save(person);
                }
                j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
            }
            catch (IOException e) {
                j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                logger.error((Object)ExceptionUtil.getExceptionMessage(e));
            }
        }
        return j;
    }

    @RequestMapping(value={"check"})
    public void check(HttpServletRequest request, HttpServletResponse response) {
        try {
            if ("open".equals(request.getSession().getAttribute("state"))) {
                request.getSession().setAttribute("state", null);
                response.getWriter().write("true");
                response.getWriter().flush();
            } else {
                response.getWriter().write("false");
                response.getWriter().flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(JpPersonEntity.class, dataGrid);
        this.jpPersonService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(JpPersonEntity jpPerson, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        jpPerson = (JpPersonEntity)this.systemService.getEntity(JpPersonEntity.class, (Serializable)((Object)jpPerson.getId()));
        this.message = "\u5220\u9664\u6210\u529f";
        this.jpPersonService.delete(jpPerson);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(JpPersonEntity jpPerson, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty(jpPerson.getId())) {
            this.message = "\u66f4\u65b0\u6210\u529f";
            this.jpPersonService.saveOrUpdate(jpPerson);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        } else {
            this.message = "\u6dfb\u52a0\u6210\u529f";
            this.jpPersonService.save(jpPerson);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(JpPersonEntity jpPerson, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(jpPerson.getId())) {
            jpPerson = (JpPersonEntity)this.jpPersonService.getEntity(JpPersonEntity.class, (Serializable)((Object)jpPerson.getId()));
            req.setAttribute("jpPersonPage", (Object)jpPerson);
        }
        return new ModelAndView("jeecg/demo/test/jpPerson");
    }
}

