/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.demo.controller.test;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.demo.entity.test.JeecgNoteEntity;
import org.jeecgframework.web.demo.service.test.JeecgNoteServiceI;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/jeecgNoteController"})
public class JeecgNoteController
extends BaseController {
    private static final Logger logger = Logger.getLogger(JeecgNoteController.class);
    @Autowired
    private JeecgNoteServiceI jeecgNoteService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"jeecgNote"})
    public ModelAndView jeecgNote(HttpServletRequest request) {
        return new ModelAndView("jeecg/demo/test/jeecgNoteList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(JeecgNoteEntity jeecgNote, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(JeecgNoteEntity.class, dataGrid);
        HqlGenerateUtil.installHql(cq, jeecgNote);
        this.jeecgNoteService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(JeecgNoteEntity jeecgNote, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        jeecgNote = (JeecgNoteEntity)this.systemService.getEntity(JeecgNoteEntity.class, (Serializable)((Object)jeecgNote.getId()));
        this.message = "\u5220\u9664\u6210\u529f";
        this.jeecgNoteService.delete(jeecgNote);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(JeecgNoteEntity jeecgNote, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty(jeecgNote.getId())) {
            this.message = "\u66f4\u65b0\u6210\u529f";
            this.jeecgNoteService.saveOrUpdate(jeecgNote);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        } else {
            this.message = "\u6dfb\u52a0\u6210\u529f";
            this.jeecgNoteService.save(jeecgNote);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(JeecgNoteEntity jeecgNote, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(jeecgNote.getId())) {
            jeecgNote = (JeecgNoteEntity)this.jeecgNoteService.getEntity(JeecgNoteEntity.class, (Serializable)((Object)jeecgNote.getId()));
            req.setAttribute("jeecgNotePage", (Object)jeecgNote);
        }
        return new ModelAndView("jeecg/demo/test/jeecgNote");
    }
}

