/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.demo.controller.test;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.dao.jdbc.JdbcDao;
import org.jeecgframework.core.common.model.common.DBTable;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.service.CommonService;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.web.cgform.service.migrate.MigrateForm;
import org.jeecgframework.web.demo.entity.test.JeecgDemo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/transdata"})
public class JeecgDemoTransDataForXml
extends BaseController {
    private static final Logger logger = Logger.getLogger(JeecgDemoTransDataForXml.class);
    @Autowired
    @Qualifier(value="jdbcTemplate")
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private JdbcDao jdbcDao;
    @Autowired
    private CommonService commonService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"doMigrateOut"})
    public void doMigrateOut(HttpServletRequest request, HttpServletResponse response) {
        String savePath = ResourceUtil.getSystempPath();
        savePath = String.valueOf(savePath) + "/test_export_migrate.xml";
        File file = new File(savePath);
        try {
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    logger.info((Object)"\u521b\u5efa\u6587\u4ef6\u540d\u5931\u8d25\uff01\uff01");
                    e.printStackTrace();
                }
            }
            String ids = request.getParameter("ids");
            XStream xStream = new XStream();
            DBTable<JeecgDemo> dbTable = new DBTable<JeecgDemo>();
            dbTable.setTableName("jeecg_demo");
            dbTable.setClass1(JeecgDemo.class);
            String sql = "select * from jeecg_demo";
            if (StringUtil.isNotEmpty(ids) && ids.split(",").length > 0) {
                sql = String.valueOf(sql) + " where id in ('" + ids.replaceAll(",", "','") + "')";
            }
            List list = this.jdbcDao.find(sql, JeecgDemo.class, null);
            dbTable.setTableData(list);
            xStream.processAnnotations(DBTable.class);
            FileOutputStream outputStream = new FileOutputStream(savePath);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n");
            xStream.toXML(dbTable, (Writer)writer);
            logger.debug((Object)("create doMigrateOut file: " + savePath));
            String ls_filename = MigrateForm.zip(null, "", savePath);
            file = new File(ls_filename);
            String filename = file.getName();
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(ls_filename));
            response.reset();
            response.setContentType("text/html;charset=utf-8");
            request.setCharacterEncoding("UTF-8");
            response.addHeader("Content-Length", "" + file.length());
            BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setContentType("application/octet-stream");
            response.setHeader("Content-disposition", "attachment;filename=" + new String(filename.getBytes("utf-8"), "ISO8859-1"));
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = ((InputStream)fis).read(buffer, 0, 8192)) != -1) {
                ((OutputStream)toClient).write(buffer, 0, bytesRead);
            }
            ((OutputStream)toClient).write(buffer);
            ((OutputStream)toClient).flush();
            ((OutputStream)toClient).close();
            ((InputStream)fis).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"toMigrate"})
    public ModelAndView toCgformMigrate(HttpServletRequest req) {
        return new ModelAndView("jeecg/demo/jeecgDemo/cgformMigrateInclude");
    }

    @ResponseBody
    @RequestMapping(params={"doMigrateIn"})
    public AjaxJson doMigrateIn(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        String ls_file = "";
        UploadFile uploadFile = new UploadFile(request, ls_file);
        uploadFile.setCusPath("");
        uploadFile.setSwfpath("");
        String uploadbasepath = uploadFile.getBasePath();
        if (uploadbasepath == null) {
            uploadbasepath = ResourceUtil.getConfigByName("uploadpath");
        }
        String path = String.valueOf(uploadbasepath) + "\\";
        String realPath = String.valueOf(uploadFile.getMultipartRequest().getSession().getServletContext().getRealPath("\\")) + path;
        this.message = null;
        try {
            File file = new File(realPath);
            if (!file.exists()) {
                file.mkdir();
            }
            uploadFile.getMultipartRequest().setCharacterEncoding("UTF-8");
            MultipartHttpServletRequest multipartRequest = uploadFile.getMultipartRequest();
            Map fileMap = multipartRequest.getFileMap();
            String fileName = "";
            for (Map.Entry entity : fileMap.entrySet()) {
                MultipartFile mf = (MultipartFile)entity.getValue();
                fileName = mf.getOriginalFilename();
                String savePath = String.valueOf(realPath) + fileName;
                File savefile = new File(savePath);
                String ls_tmp = savefile.getName();
                FileCopyUtils.copy((byte[])mf.getBytes(), (File)savefile);
                MigrateForm.unzip(savePath, "");
                String sqlFileDir = String.valueOf(realPath) + ls_tmp.substring(0, ls_tmp.lastIndexOf("."));
                File sqlDirFile = new File(sqlFileDir);
                String sqlfilename = String.valueOf(sqlDirFile.getPath()) + "/";
                if (sqlDirFile.isDirectory()) {
                    sqlfilename = String.valueOf(sqlfilename) + sqlDirFile.list()[0];
                }
                XStream xStream = new XStream();
                xStream.processAnnotations(DBTable.class);
                DBTable dbTable = (DBTable)xStream.fromXML(new File(sqlfilename));
                if (dbTable.getClass1() == null) continue;
                this.commonService.batchSave(dbTable.getTableData());
            }
        }
        catch (Exception e1) {
            LogUtil.error(e1.toString());
            this.message = e1.toString();
        }
        if (StringUtil.isNotEmpty(this.message)) {
            j.setMsg("SQL\u6587\u4ef6\u5bfc\u5165\u5931\u8d25," + this.message);
        } else {
            j.setMsg("SQL\u6587\u4ef6\u5bfc\u5165\u6210\u529f");
        }
        return j;
    }
}

