/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.demo.controller.test;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.web.demo.entity.test.FileMeta;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/fileUploadController"})
public class FileUploadController
extends BaseController {
    private static final Logger logger = Logger.getLogger(FileUploadController.class);
    @Autowired
    private SystemService systemService;
    private String message;
    LinkedList<FileMeta> files = new LinkedList();
    FileMeta fileMeta = null;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"fileUploadSample"})
    public ModelAndView webOfficeSample(HttpServletRequest request) {
        return new ModelAndView("jeecg/demo/test/fileUploadSample");
    }

    @RequestMapping(params={"upload"}, method={RequestMethod.POST})
    @ResponseBody
    public LinkedList<FileMeta> upload(MultipartHttpServletRequest request, HttpServletResponse response) {
        Iterator itr = request.getFileNames();
        MultipartFile mpf = null;
        while (itr.hasNext()) {
            mpf = request.getFile((String)itr.next());
            LogUtil.info(String.valueOf(mpf.getOriginalFilename()) + " uploaded! " + this.files.size());
            if (this.files.size() >= 10) {
                this.files.pop();
            }
            this.fileMeta = new FileMeta();
            this.fileMeta.setFileName(mpf.getOriginalFilename());
            this.fileMeta.setFileSize(String.valueOf(mpf.getSize() / 1024L) + " Kb");
            this.fileMeta.setFileType(mpf.getContentType());
            try {
                this.fileMeta.setBytes(mpf.getBytes());
                String path = "upload/";
                String realPath = String.valueOf(request.getSession().getServletContext().getRealPath("/")) + "/" + path;
                String savePath = String.valueOf(realPath) + mpf.getOriginalFilename();
                FileCopyUtils.copy((byte[])mpf.getBytes(), (File)new File(savePath));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.files.add(this.fileMeta);
        }
        return this.files;
    }

    @RequestMapping(params={"view"}, method={RequestMethod.GET, RequestMethod.POST})
    public void get(HttpServletResponse response, String index) {
        FileMeta getFile = this.files.get(Integer.parseInt(index));
        try {
            response.setContentType(getFile.getFileType());
            response.setHeader("Content-disposition", "attachment; filename=\"" + getFile.getFileName() + "\"");
            FileCopyUtils.copy((byte[])getFile.getBytes(), (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

