/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.demo.controller.test;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.ComboTree;
import org.jeecgframework.core.common.model.json.TreeGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.vo.easyui.ComboTreeModel;
import org.jeecgframework.tag.vo.easyui.TreeGridModel;
import org.jeecgframework.web.system.pojo.base.TSDemo;
import org.jeecgframework.web.system.pojo.base.TSFunction;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.HtmlUtils;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/demoController"})
public class DemoController
extends BaseController {
    private static final Logger logger = Logger.getLogger(DemoController.class);
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Autowired
    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    @RequestMapping(params={"aorudemo"})
    public ModelAndView aorudemo(TSDemo demo, HttpServletRequest request) {
        String type = oConvertUtils.getString(request.getParameter("type"));
        if (demo.getId() != null) {
            demo = (TSDemo)this.systemService.getEntity(TSDemo.class, (Serializable)((Object)demo.getId()));
            request.setAttribute("demo", (Object)demo);
        }
        if (type.equals("table")) {
            return new ModelAndView("jeecg/demo/base/tabledemo");
        }
        return new ModelAndView("jeecg/demo/base/demo");
    }

    @RequestMapping(params={"pDemoList"})
    @ResponseBody
    public List<ComboTree> pDemoList(HttpServletRequest request, ComboTree comboTree) {
        CriteriaQuery cq = new CriteriaQuery(TSDemo.class);
        if (comboTree.getId() != null) {
            cq.eq("TSDemo.id", comboTree.getId());
        }
        if (comboTree.getId() == null) {
            cq.isNull("TSDemo");
        }
        cq.add();
        List demoList = this.systemService.getListByCriteriaQuery(cq, false);
        ArrayList<ComboTree> comboTrees = new ArrayList();
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "demotitle", "tsDemos", "demourl");
        comboTrees = this.systemService.ComboTree(demoList, comboTreeModel, null);
        return comboTrees;
    }

    @RequestMapping(params={"demoTurn"})
    @ResponseBody
    public String demoTurn(String id) {
        String code = this.systemService.get(TSDemo.class, (Serializable)((Object)id)).getDemocode();
        return HtmlUtils.htmlUnescape((String)code);
    }

    @RequestMapping(params={"demoIframe"})
    public ModelAndView demoIframe(HttpServletRequest request) {
        CriteriaQuery cq = new CriteriaQuery(TSDemo.class);
        cq.isNull("TSDemo.id");
        cq.add();
        List demoList = this.systemService.getListByCriteriaQuery(cq, false);
        request.setAttribute("demoList", demoList);
        return new ModelAndView("jeecg/demo/base/demoIframe");
    }

    @RequestMapping(params={"demoList"})
    public ModelAndView demoList(HttpServletRequest request) {
        return new ModelAndView("jeecg/demo/base/demoList");
    }

    @RequestMapping(params={"demoGrid"})
    @ResponseBody
    public List<TreeGrid> demoGrid(HttpServletRequest request, TreeGrid treegrid) {
        CriteriaQuery cq = new CriteriaQuery(TSDemo.class);
        if (treegrid.getId() != null) {
            cq.eq("TSDemo.id", treegrid.getId());
        }
        if (treegrid.getId() == null) {
            cq.isNull("TSDemo");
        }
        cq.add();
        List demoList = this.systemService.getListByCriteriaQuery(cq, false);
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setTextField("demotitle");
        treeGridModel.setParentText("TSDemo_demotitle");
        treeGridModel.setParentId("TSDemo_id");
        treeGridModel.setSrc("demourl");
        treeGridModel.setIdField("id");
        treeGridModel.setChildList("tsDemos");
        List<TreeGrid> treeGrids = this.systemService.treegrid(demoList, treeGridModel);
        return treeGrids;
    }

    @RequestMapping(params={"demoCode"})
    public ModelAndView demoCode(TSDemo demo, HttpServletRequest request) {
        List list = this.systemService.getList(TSDemo.class);
        demo = (TSDemo)list.get(0);
        request.setAttribute("demo", (Object)demo);
        return new ModelAndView("jeecg/demo/base/democode");
    }

    @RequestMapping(params={"getDemo"})
    @ResponseBody
    public AjaxJson getDemo(HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        String id = StringUtil.getEncodePra(req.getParameter("id"));
        String floor = "";
        CriteriaQuery cq = new CriteriaQuery(TSFunction.class);
        cq.eq("TSFunction.id", id);
        cq.add();
        List functions = this.systemService.getListByCriteriaQuery(cq, false);
        if (functions.size() > 0) {
            for (TSFunction function : functions) {
                floor = String.valueOf(floor) + "<input type=\"checkbox\"  name=\"floornum\" id=\"floornum\" value=\"" + function.getId() + "\">" + function.getFunctionName() + "&nbsp;&nbsp;";
            }
        } else {
            floor = String.valueOf(floor) + "\u6ca1\u6709\u5b50\u9879\u76ee!";
        }
        j.setMsg(floor);
        return j;
    }

    @RequestMapping(params={"uploadTabs"})
    public ModelAndView uploadTabs(HttpServletRequest request) {
        return new ModelAndView("jeecg/demo/base/upload/uploadTabs");
    }

    @RequestMapping(params={"imgViewTabs"})
    public ModelAndView imgViewTabs(HttpServletRequest request) {
        return new ModelAndView("jeecg/demo/base/picview/imgViewTabs");
    }

    @RequestMapping(params={"formTabs"})
    public ModelAndView formTabs(HttpServletRequest request) {
        return new ModelAndView("jeecg/demo/base/formvalid/formTabs");
    }

    @RequestMapping(params={"templeteTabs"})
    public ModelAndView templeteTabs(HttpServletRequest request) {
        return new ModelAndView("jeecg/demo/base/template/templateiframe");
    }

    @RequestMapping(params={"autoupload"})
    public ModelAndView autoupload(HttpServletRequest request) {
        String turn = oConvertUtils.getString(request.getParameter("turn"));
        return new ModelAndView("jeecg/demo/base/" + turn);
    }

    @RequestMapping(params={"select"})
    public ModelAndView select(HttpServletRequest request) {
        CriteriaQuery cq2 = new CriteriaQuery(TSFunction.class);
        cq2.eq("functionLevel", Globals.Function_Leave_ONE);
        cq2.add();
        List funList = this.systemService.getListByCriteriaQuery(cq2, true);
        request.setAttribute("funList", funList);
        return new ModelAndView("jeecg/demo/base/AJAX/select");
    }

    @RequestMapping(params={"dictSelect"})
    public ModelAndView dictSelect(HttpServletRequest request) {
        request.setAttribute("process", (Object)"default");
        return new ModelAndView("jeecg/demo/base/dict/dictSelect");
    }

    @RequestMapping(params={"mapDemo"})
    public ModelAndView mapDemo(HttpServletRequest request) {
        return new ModelAndView("jeecg/demo/base/map/mapDemo2");
    }

    @RequestMapping(params={"saveDemo"})
    @ResponseBody
    public AjaxJson saveDemo(TSDemo demo, HttpServletRequest request) throws Exception {
        AjaxJson j = new AjaxJson();
        if (!StringUtil.isEmpty(demo.getId())) {
            this.message = "Demo\u7ef4\u62a4\u4f8b\u5b50: " + demo.getDemotitle() + "\u88ab\u66f4\u65b0\u6210\u529f";
            TSDemo entity = this.systemService.get(TSDemo.class, (Serializable)((Object)demo.getId()));
            MyBeanUtils.copyBeanNotNull2Bean(demo, entity);
            if (demo.getTSDemo() == null || StringUtil.isEmpty(demo.getTSDemo().getId())) {
                entity.setTSDemo(null);
            }
            this.systemService.saveOrUpdate(entity);
        } else {
            this.message = "Demo\u4f8b\u5b50: " + demo.getDemotitle() + "\u88ab\u6dfb\u52a0\u6210\u529f";
            if (demo.getTSDemo() == null || StringUtil.isEmpty(demo.getTSDemo().getId())) {
                demo.setTSDemo(null);
            }
            this.systemService.save(demo);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"delDemo"})
    @ResponseBody
    public AjaxJson del(TSDemo demo, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        demo = (TSDemo)this.systemService.getEntity(TSDemo.class, (Serializable)((Object)demo.getId()));
        this.message = "Demo: " + demo.getDemotitle() + "\u88ab\u5220\u9664 \u6210\u529f";
        this.systemService.delete(demo);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }
}

