/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.demo.controller.test;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.entity.TemplateExportParams;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.demo.entity.test.CourseEntity;
import org.jeecgframework.web.demo.service.test.CourseServiceI;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/courseController"})
public class CourseController
extends BaseController {
    private static final Logger logger = Logger.getLogger(CourseController.class);
    @Autowired
    private CourseServiceI courseService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"course"})
    public ModelAndView course(HttpServletRequest request) {
        return new ModelAndView("jeecg/demo/test/courseList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(CourseEntity course, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(CourseEntity.class, dataGrid);
        HqlGenerateUtil.installHql(cq, course, request.getParameterMap());
        this.courseService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(CourseEntity course, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        course = (CourseEntity)this.systemService.getEntity(CourseEntity.class, (Serializable)((Object)course.getId()));
        this.message = "\u8bfe\u7a0b\u5220\u9664\u6210\u529f";
        this.courseService.delete(course);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(CourseEntity course, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty(course.getId())) {
            this.message = "\u8bfe\u7a0b\u66f4\u65b0\u6210\u529f";
            try {
                this.courseService.updateCourse(course);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u8bfe\u7a0b\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            this.message = "\u8bfe\u7a0b\u6dfb\u52a0\u6210\u529f";
            this.courseService.saveCourse(course);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(CourseEntity course, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(course.getId())) {
            course = (CourseEntity)this.courseService.getEntity(CourseEntity.class, (Serializable)((Object)course.getId()));
            req.setAttribute("coursePage", (Object)course);
        }
        return new ModelAndView("jeecg/demo/test/course");
    }

    @RequestMapping(params={"studentsList"})
    public ModelAndView studentsList(CourseEntity course, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(course.getId())) {
            course = (CourseEntity)this.courseService.getEntity(CourseEntity.class, (Serializable)((Object)course.getId()));
            req.setAttribute("studentsList", course.getStudents());
        }
        return new ModelAndView("jeecg/demo/test/CourseStudentList");
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        return new ModelAndView("jeecg/demo/test/courseUpload");
    }

    @RequestMapping(params={"exportXls"})
    public String exportXls(CourseEntity course, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid, ModelMap map) {
        CriteriaQuery cq = new CriteriaQuery(CourseEntity.class, dataGrid);
        HqlGenerateUtil.installHql(cq, course, request.getParameterMap());
        List courses = this.courseService.getListByCriteriaQuery(cq, false);
        map.put((Object)"fileName", (Object)"\u7528\u6237\u4fe1\u606f");
        map.put((Object)"entity", CourseEntity.class);
        map.put((Object)"title", (Object)new ExcelTitle("\u8bfe\u7a0b\u5217\u8868", "\u5bfc\u51fa\u4eba:Jeecg", "\u5bfc\u51fa\u4fe1\u606f"));
        map.put((Object)"data", courses);
        return "jeecgExcelView";
    }

    @RequestMapping(params={"exportXlsByTest"})
    public void exportXlsByTest(CourseEntity course, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u5de5\u8d44\u7edf\u8ba1\u4fe1\u606f";
                if (BrowserUtils.isIE(request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                Workbook workbook = null;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("month", 10);
                int i = 1;
                while (i < 8) {
                    HashMap<String, Integer> temp = new HashMap<String, Integer>();
                    temp.put("per", i * 10);
                    temp.put("mon", i * 1000);
                    temp.put("summon", i * 10000);
                    map.put("i" + i, temp);
                    ++i;
                }
                workbook = ExcelExportUtil.exportExcel(new TemplateExportParams("export/template/exportTemp.xls", 1), map);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"exportXlsByT"})
    public void exportXlsByT(CourseEntity course, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u8bfe\u7a0b\u4fe1\u606f";
                if (BrowserUtils.isIE(request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                Workbook workbook = null;
                CriteriaQuery cq = new CriteriaQuery(CourseEntity.class, dataGrid);
                HqlGenerateUtil.installHql(cq, course, request.getParameterMap());
                List courses = this.courseService.getListByCriteriaQuery(cq, false);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("year", "2013");
                map.put("sunCourses", courses.size());
                HashMap<String, Integer> obj = new HashMap<String, Integer>();
                map.put("obj", obj);
                obj.put("name", courses.size());
                workbook = ExcelExportUtil.exportExcel(new TemplateExportParams("export/template/exportTemp.xls"), CourseEntity.class, courses, map);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setSecondTitleRows(2);
            params.setNeedSave(true);
            try {
                try {
                    List listCourses = (List)ExcelImportUtil.importExcelByIs(file.getInputStream(), CourseEntity.class, params);
                    for (CourseEntity course : listCourses) {
                        if (course.getName() == null) continue;
                        this.courseService.saveCourse(course);
                    }
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage(e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }
}

