/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgreport.controller.excel;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.web.cgreport.exception.CgReportNotFoundException;
import org.jeecgframework.web.cgreport.service.core.CgReportServiceI;
import org.jeecgframework.web.cgreport.service.excel.CgReportExcelServiceI;
import org.jeecgframework.web.cgreport.util.CgReportQueryParamUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/cgExportExcelController"})
public class CgExportExcelController
extends BaseController {
    @Autowired
    private CgReportServiceI cgReportService;
    @Autowired
    private CgReportExcelServiceI cgReportExcelService;

    @RequestMapping(params={"exportXls"})
    public void exportXls(HttpServletRequest request, HttpServletResponse response) {
        String codedFileName = "\u62a5\u8868";
        String sheetName = "\u5bfc\u51fa\u4fe1\u606f";
        if (StringUtil.isNotEmpty(request.getParameter("configId"))) {
            String configId = request.getParameter("configId");
            Map<String, Object> cgReportMap = null;
            try {
                cgReportMap = this.cgReportService.queryCgReportConfig(configId);
            }
            catch (Exception e) {
                throw new CgReportNotFoundException("\u52a8\u6001\u62a5\u8868\u914d\u7f6e\u4e0d\u5b58\u5728!");
            }
            List fieldList = (List)cgReportMap.get("items");
            Map configM = (Map)cgReportMap.get("main");
            codedFileName = configM.get("name") + codedFileName;
            String querySql = (String)configM.get("cgreport_sql");
            List items = (List)cgReportMap.get("items");
            LinkedHashMap queryparams = new LinkedHashMap();
            for (Map item : items) {
                String isQuery = (String)item.get("search_flag");
                if (!"Y".equalsIgnoreCase(isQuery)) continue;
                CgReportQueryParamUtil.loadQueryParams(request, item, queryparams);
            }
            List<Map<String, Object>> result = this.cgReportService.queryByCgReportSql(querySql, queryparams, -1, -1);
            response.setContentType("application/vnd.ms-excel");
            OutputStream fOut = null;
            try {
                try {
                    String browse = BrowserUtils.checkBrowse(request);
                    if ("MSIE".equalsIgnoreCase(browse.substring(0, 4))) {
                        response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                    } else {
                        String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                        response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                    }
                    HSSFWorkbook workbook = null;
                    workbook = this.cgReportExcelService.exportExcel(codedFileName, fieldList, result);
                    fOut = response.getOutputStream();
                    workbook.write(fOut);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    try {
                        fOut.flush();
                        fOut.close();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (Exception exception) {
                    try {
                        fOut.flush();
                        fOut.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
    }
}

