/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgreport.controller.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.web.cgform.engine.FreemarkerHelper;
import org.jeecgframework.web.cgreport.exception.CgReportNotFoundException;
import org.jeecgframework.web.cgreport.service.core.CgReportServiceI;
import org.jeecgframework.web.cgreport.util.CgReportQueryParamUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/cgReportController"})
public class CgReportController
extends BaseController {
    @Autowired
    private CgReportServiceI cgReportService;

    @RequestMapping(params={"list"})
    public void list(String id, HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> cgReportMap = null;
        try {
            cgReportMap = this.cgReportService.queryCgReportConfig(id);
        }
        catch (Exception e) {
            throw new CgReportNotFoundException("\u52a8\u6001\u62a5\u8868\u914d\u7f6e\u4e0d\u5b58\u5728!");
        }
        FreemarkerHelper viewEngine = new FreemarkerHelper();
        this.loadVars(cgReportMap);
        String html = viewEngine.parseTemplate("/org/jeecgframework/web/cgreport/engine/core/cgreportlist.ftl", cgReportMap);
        try {
            response.setContentType("text/html");
            response.setHeader("Cache-Control", "no-store");
            PrintWriter writer = response.getWriter();
            writer.println(html);
            LogUtil.info(html);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"popup"})
    public void popup(String id, HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> cgReportMap = null;
        try {
            cgReportMap = this.cgReportService.queryCgReportConfig(id);
        }
        catch (Exception e) {
            throw new CgReportNotFoundException("\u52a8\u6001\u62a5\u8868\u914d\u7f6e\u4e0d\u5b58\u5728!");
        }
        FreemarkerHelper viewEngine = new FreemarkerHelper();
        this.loadVars(cgReportMap);
        String html = viewEngine.parseTemplate("/org/jeecgframework/web/cgreport/engine/core/cgreportlistpopup.ftl", cgReportMap);
        try {
            response.setContentType("text/html");
            response.setHeader("Cache-Control", "no-store");
            PrintWriter writer = response.getWriter();
            writer.println(html);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadVars(Map<String, Object> cgReportMap) {
        Map mainM = (Map)cgReportMap.get("main");
        List fieldList = (List)cgReportMap.get("items");
        ArrayList<Map> queryList = new ArrayList<Map>(0);
        for (Map fl : fieldList) {
            fl.put("field_name", ((String)fl.get("field_name")).toLowerCase());
            String isQuery = (String)fl.get("search_flag");
            if (!"Y".equalsIgnoreCase(isQuery)) continue;
            this.loadDic(fl, fl);
            queryList.add(fl);
        }
        cgReportMap.put("config_id", mainM.get("code"));
        cgReportMap.put("config_name", mainM.get("name"));
        cgReportMap.put("config_fieldList", fieldList);
        cgReportMap.put("config_queryList", queryList);
    }

    private void dealDic(List<Map<String, Object>> result, List<Map<String, Object>> beans) {
        for (Map<String, Object> bean : beans) {
            String dict_code = (String)bean.get("dict_code");
            if (StringUtil.isEmpty(dict_code)) continue;
            List<Map<String, Object>> dicDatas = this.queryDic(dict_code);
            for (Map<String, Object> r : result) {
                String value = String.valueOf(r.get(bean.get("field_name")));
                for (Map<String, Object> m : dicDatas) {
                    String typecode = String.valueOf(m.get("typecode"));
                    String typename = String.valueOf(m.get("typename"));
                    if (!value.equalsIgnoreCase(typecode)) continue;
                    r.put((String)bean.get("field_name"), typename);
                }
            }
        }
    }

    private void dealReplace(List<Map<String, Object>> result, List<Map<String, Object>> beans) {
        for (Map<String, Object> bean : beans) {
            try {
                String[] groups;
                String replace = (String)bean.get("replace_value");
                if (StringUtil.isEmpty(replace)) continue;
                String[] stringArray = groups = replace.split(",");
                int n = groups.length;
                int n2 = 0;
                while (n2 < n) {
                    String g = stringArray[n2];
                    String[] items = g.split("_");
                    String v = items[0];
                    String txt = items[1];
                    for (Map<String, Object> r : result) {
                        String value = String.valueOf(r.get(bean.get("field_name")));
                        if (!value.equalsIgnoreCase(v)) continue;
                        r.put((String)bean.get("field_name"), txt);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BusinessException("\u53d6\u503c\u8868\u8fbe\u5f0f\u4e0d\u6b63\u786e");
            }
        }
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(String configId, String page, String field, String rows, HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> cgReportMap = null;
        try {
            cgReportMap = this.cgReportService.queryCgReportConfig(configId);
            if (cgReportMap.size() <= 0) {
                throw new CgReportNotFoundException("\u52a8\u6001\u62a5\u8868\u914d\u7f6e\u4e0d\u5b58\u5728!");
            }
        }
        catch (Exception e) {
            throw new CgReportNotFoundException("\u67e5\u627e\u52a8\u6001\u62a5\u8868\u914d\u7f6e\u5931\u8d25!" + e.getMessage());
        }
        Map configM = (Map)cgReportMap.get("main");
        String querySql = (String)configM.get("cgreport_sql");
        List items = (List)cgReportMap.get("items");
        LinkedHashMap queryparams = new LinkedHashMap();
        for (Map item : items) {
            String isQuery = (String)item.get("search_flag");
            if (!"Y".equalsIgnoreCase(isQuery)) continue;
            CgReportQueryParamUtil.loadQueryParams(request, item, queryparams);
        }
        int p = page == null ? 1 : Integer.parseInt(page);
        int r = rows == null ? 99999 : Integer.parseInt(rows);
        List<Map<String, Object>> result = this.cgReportService.queryByCgReportSql(querySql, queryparams, p, r);
        long size = this.cgReportService.countQueryByCgReportSql(querySql, queryparams);
        this.dealDic(result, items);
        this.dealReplace(result, items);
        response.setContentType("application/json");
        response.setHeader("Cache-Control", "no-store");
        try {
            PrintWriter writer = response.getWriter();
            writer.println(CgReportQueryParamUtil.getJson(result, size));
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"getFields"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getSqlFields(String sql) {
        List<String> result = null;
        HashMap<String, Object> reJson = new HashMap<String, Object>();
        try {
            result = this.cgReportService.getSqlFields(sql);
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorInfo = "\u89e3\u6790\u5931\u8d25!<br><br>\u5931\u8d25\u539f\u56e0\uff1a";
            errorInfo = String.valueOf(errorInfo) + e.getMessage();
            reJson.put("status", "error");
            reJson.put("datas", errorInfo);
            return reJson;
        }
        reJson.put("status", "success");
        reJson.put("datas", result);
        return reJson;
    }

    private void loadDic(Map m, Map<String, Object> cgReportMap) {
        String dict_code = (String)cgReportMap.get("dict_code");
        if (StringUtil.isEmpty(dict_code)) {
            m.put("field_dictlist", new ArrayList(0));
            return;
        }
        List<Map<String, Object>> dicDatas = this.queryDic(dict_code);
        m.put("field_dictlist", dicDatas);
    }

    private List<Map<String, Object>> queryDic(String diccode) {
        StringBuilder dicSql = new StringBuilder();
        dicSql.append(" SELECT TYPECODE,TYPENAME FROM");
        dicSql.append(" t_s_type");
        dicSql.append(" WHERE TYPEGROUPID = ");
        dicSql.append(" (SELECT ID FROM t_s_typegroup WHERE TYPEGROUPCODE = '" + diccode + "' )");
        List<Map<String, Object>> dicDatas = this.cgReportService.findForJdbc(dicSql.toString(), new Object[0]);
        return dicDatas;
    }
}

