/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.service.impl.config.util;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.internal.SessionImpl;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.jeecgframework.web.cgform.entity.config.CgFormFieldEntity;
import org.jeecgframework.web.cgform.entity.config.CgFormHeadEntity;
import org.jeecgframework.web.cgform.exception.DBException;
import org.jeecgframework.web.cgform.service.config.DbTableHandleI;
import org.jeecgframework.web.cgform.service.impl.config.util.ColumnMeta;
import org.jeecgframework.web.cgform.service.impl.config.util.DbTableUtil;
import org.springframework.orm.hibernate4.SessionFactoryUtils;

public class DbTableProcess {
    private static final Logger logger = Logger.getLogger(DbTableProcess.class);
    private static DbTableHandleI dbTableHandle;

    public DbTableProcess(Session session) {
        dbTableHandle = DbTableUtil.getTableHandle(session);
    }

    public static void createOrDropTable(CgFormHeadEntity table, Session session) throws IOException, TemplateException, HibernateException, SQLException, DBException {
        Template t = DbTableProcess.getConfig("/org/jeecgframework/web/cgform/engine/hibernate").getTemplate("tableTemplate.ftl");
        StringWriter out = new StringWriter();
        t.setNumberFormat("0.#####################");
        t.process(DbTableProcess.getRootMap(table, DbTableUtil.getDataType(session)), (Writer)out);
        String xml = ((Object)out).toString();
        logger.info((Object)xml);
        DbTableProcess.createTable(xml, table, session);
    }

    private static Object getRootMap(CgFormHeadEntity table, String dataType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (CgFormFieldEntity field : table.getColumns()) {
            field.setFieldDefault(DbTableProcess.judgeIsNumber(field.getFieldDefault()));
        }
        map.put("entity", table);
        map.put("dataType", dataType);
        return map;
    }

    public List<String> updateTable(CgFormHeadEntity table, Session session) throws DBException {
        String tableName = DbTableUtil.getDataType(session).equals("ORACLE") ? table.getTableName().toUpperCase() : table.getTableName();
        String alterTable = "alter table  " + tableName + " ";
        ArrayList<String> strings = new ArrayList<String>();
        try {
            Map<String, ColumnMeta> dataBaseColumnMetaMap = DbTableProcess.getColumnMetadataFormDataBase(null, tableName, session);
            Map<String, ColumnMeta> cgFormColumnMetaMap = DbTableProcess.getColumnMetadataFormCgForm(table);
            Map<String, String> newAndOldFieldMap = DbTableProcess.getNewAndOldFieldName(table);
            for (String columnName : cgFormColumnMetaMap.keySet()) {
                ColumnMeta cgFormColumnMeta;
                if (!dataBaseColumnMetaMap.containsKey(columnName)) {
                    ColumnMeta cgFormColumnMeta2 = cgFormColumnMetaMap.get(columnName);
                    if (newAndOldFieldMap.containsKey(columnName) && dataBaseColumnMetaMap.containsKey(newAndOldFieldMap.get(columnName))) {
                        ColumnMeta dataColumnMeta = dataBaseColumnMetaMap.get(newAndOldFieldMap.get(columnName));
                        if (DbTableUtil.getDataType(session).equals("SQLSERVER")) {
                            strings.add(DbTableProcess.getReNameFieldName(cgFormColumnMeta2));
                        } else {
                            strings.add(String.valueOf(alterTable) + DbTableProcess.getReNameFieldName(cgFormColumnMeta2));
                        }
                        this.updateFieldName(columnName, cgFormColumnMeta2.getColumnId(), session);
                        if (!dataColumnMeta.equals(cgFormColumnMeta2)) {
                            strings.add(String.valueOf(alterTable) + DbTableProcess.getUpdateColumnSql(cgFormColumnMeta2, dataColumnMeta));
                            if (DbTableUtil.getDataType(session).equals("POSTGRESQL")) {
                                strings.add(String.valueOf(alterTable) + DbTableProcess.getUpdateSpecialSql(cgFormColumnMeta2, dataColumnMeta));
                            }
                        }
                        if (dataColumnMeta.equalsComment(cgFormColumnMeta2)) continue;
                        strings.add(this.getCommentSql(cgFormColumnMeta2));
                        continue;
                    }
                    strings.add(String.valueOf(alterTable) + DbTableProcess.getAddColumnSql(cgFormColumnMeta2));
                    if (!StringUtils.isNotEmpty((String)cgFormColumnMeta2.getComment())) continue;
                    strings.add(this.getCommentSql(cgFormColumnMeta2));
                    continue;
                }
                ColumnMeta dataColumnMeta = dataBaseColumnMetaMap.get(columnName);
                if (!dataColumnMeta.equals(cgFormColumnMeta = cgFormColumnMetaMap.get(columnName))) {
                    strings.add(String.valueOf(alterTable) + DbTableProcess.getUpdateColumnSql(cgFormColumnMeta, dataColumnMeta));
                }
                if (dataColumnMeta.equalsComment(cgFormColumnMeta)) continue;
                strings.add(this.getCommentSql(cgFormColumnMeta));
            }
            for (String columnName : dataBaseColumnMetaMap.keySet()) {
                if (cgFormColumnMetaMap.containsKey(columnName.toLowerCase()) || newAndOldFieldMap.containsValue(columnName.toLowerCase())) continue;
                strings.add(String.valueOf(alterTable) + DbTableProcess.getDropColumnSql(columnName));
            }
        }
        catch (SQLException e1) {
            throw new RuntimeException();
        }
        logger.info((Object)((Object)strings).toString());
        return strings;
    }

    private static void createTable(String xml, CgFormHeadEntity table, Session session) throws HibernateException, SQLException, DBException {
        org.hibernate.cfg.Configuration newconf = new org.hibernate.cfg.Configuration();
        newconf.addXML(xml).setProperty("hibernate.dialect", ((SessionImpl)session).getFactory().getDialect().getClass().getName());
        SchemaExport dbExport = new SchemaExport(newconf, SessionFactoryUtils.getDataSource((SessionFactory)session.getSessionFactory()).getConnection());
        dbExport.execute(true, true, false, true);
        List exceptionList = dbExport.getExceptions();
        Iterator iterator = exceptionList.iterator();
        if (iterator.hasNext()) {
            Exception exception = (Exception)iterator.next();
            throw new DBException(exception.getMessage());
        }
    }

    private static Configuration getConfig(String resource) {
        Configuration cfg = new Configuration();
        cfg.setDefaultEncoding("UTF-8");
        cfg.setClassForTemplateLoading(DbTableProcess.class, resource);
        return cfg;
    }

    public static Map<String, ColumnMeta> getColumnMetadataFormDataBase(String schemaName, String tableName, Session session) throws SQLException {
        Connection conn = SessionFactoryUtils.getDataSource((SessionFactory)session.getSessionFactory()).getConnection();
        DatabaseMetaData dbMetaData = conn.getMetaData();
        ResultSet rs = dbMetaData.getColumns(null, schemaName, tableName, "%");
        HashMap<String, ColumnMeta> columnMap = new HashMap<String, ColumnMeta>();
        while (rs.next()) {
            ColumnMeta columnMeta = new ColumnMeta();
            columnMeta.setTableName(rs.getString("COLUMN_NAME").toLowerCase());
            columnMeta.setColumnName(rs.getString("COLUMN_NAME").toLowerCase());
            columnMeta.setColunmType(dbTableHandle.getMatchClassTypeByDataType(rs.getString("TYPE_NAME"), rs.getInt("DECIMAL_DIGITS")));
            columnMeta.setColumnSize(rs.getInt("COLUMN_SIZE"));
            columnMeta.setDecimalDigits(rs.getInt("DECIMAL_DIGITS"));
            columnMeta.setIsNullable(rs.getInt("NULLABLE") == 1 ? "Y" : "N");
            columnMeta.setComment(rs.getString("REMARKS"));
            columnMeta.setFieldDefault(DbTableProcess.judgeIsNumber(rs.getString("COLUMN_DEF")) == null ? "" : DbTableProcess.judgeIsNumber(rs.getString("COLUMN_DEF")));
            logger.info((Object)("getColumnMetadataFormDataBase --->COLUMN_NAME:" + rs.getString("COLUMN_NAME") + " TYPE_NAME :" + rs.getString("TYPE_NAME") + " DECIMAL_DIGITS:" + rs.getInt("DECIMAL_DIGITS") + " COLUMN_SIZE:" + rs.getInt("COLUMN_SIZE")));
            columnMap.put(rs.getString("COLUMN_NAME").toLowerCase(), columnMeta);
        }
        return columnMap;
    }

    public static Map<String, ColumnMeta> getColumnMetadataFormCgForm(CgFormHeadEntity table) {
        HashMap<String, ColumnMeta> map = new HashMap<String, ColumnMeta>();
        List<CgFormFieldEntity> cgFormFieldEntities = table.getColumns();
        for (CgFormFieldEntity cgFormFieldEntity : cgFormFieldEntities) {
            ColumnMeta columnMeta = new ColumnMeta();
            columnMeta.setTableName(table.getTableName().toLowerCase());
            columnMeta.setColumnId(cgFormFieldEntity.getId());
            columnMeta.setColumnName(cgFormFieldEntity.getFieldName().toLowerCase());
            columnMeta.setColumnSize(cgFormFieldEntity.getLength());
            columnMeta.setColunmType(cgFormFieldEntity.getType().toLowerCase());
            columnMeta.setIsNullable(cgFormFieldEntity.getIsNull());
            columnMeta.setComment(cgFormFieldEntity.getContent());
            columnMeta.setDecimalDigits(cgFormFieldEntity.getPointLength());
            columnMeta.setFieldDefault(DbTableProcess.judgeIsNumber(cgFormFieldEntity.getFieldDefault()));
            columnMeta.setPkType(table.getJformPkType() == null ? "UUID" : table.getJformPkType());
            columnMeta.setOldColumnName(cgFormFieldEntity.getOldFieldName() != null ? cgFormFieldEntity.getOldFieldName().toLowerCase() : null);
            logger.info((Object)("getColumnMetadataFormCgForm ---->COLUMN_NAME:" + cgFormFieldEntity.getFieldName().toLowerCase() + " TYPE_NAME:" + cgFormFieldEntity.getType().toLowerCase() + " DECIMAL_DIGITS:" + cgFormFieldEntity.getPointLength() + " COLUMN_SIZE:" + cgFormFieldEntity.getLength()));
            map.put(cgFormFieldEntity.getFieldName().toLowerCase(), columnMeta);
        }
        return map;
    }

    public static Map<String, String> getNewAndOldFieldName(CgFormHeadEntity table) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<CgFormFieldEntity> cgFormFieldEntities = table.getColumns();
        for (CgFormFieldEntity cgFormFieldEntity : cgFormFieldEntities) {
            map.put(cgFormFieldEntity.getFieldName(), cgFormFieldEntity.getOldFieldName());
        }
        return map;
    }

    private static String getDropColumnSql(String fieldName) {
        return dbTableHandle.getDropColumnSql(fieldName);
    }

    private static String getUpdateColumnSql(ColumnMeta cgformcolumnMeta, ColumnMeta datacolumnMeta) throws DBException {
        return dbTableHandle.getUpdateColumnSql(cgformcolumnMeta, datacolumnMeta);
    }

    private static String getUpdateSpecialSql(ColumnMeta cgformcolumnMeta, ColumnMeta datacolumnMeta) {
        return dbTableHandle.getSpecialHandle(cgformcolumnMeta, datacolumnMeta);
    }

    private static String getReNameFieldName(ColumnMeta columnMeta) {
        return dbTableHandle.getReNameFieldName(columnMeta);
    }

    private static String getAddColumnSql(ColumnMeta columnMeta) {
        return dbTableHandle.getAddColumnSql(columnMeta);
    }

    private String getCommentSql(ColumnMeta columnMeta) {
        return dbTableHandle.getCommentSql(columnMeta);
    }

    private int updateFieldName(String columnName, String id, Session session) {
        return session.createSQLQuery("update cgform_field set old_field_name= '" + columnName + "' where id='" + id + "'").executeUpdate();
    }

    private static String judgeIsNumber(String text) {
        if (StringUtils.isNotEmpty((String)text)) {
            try {
                Double.valueOf(text);
            }
            catch (Exception e) {
                text = "'" + text + "'";
            }
        }
        return text;
    }
}

