/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.service.impl.config;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jeecgframework.codegenerate.util.CodeResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.web.cgform.entity.config.CgFormFieldEntity;
import org.jeecgframework.web.cgform.entity.config.CgFormHeadEntity;
import org.jeecgframework.web.cgform.service.config.DbTableServiceI;
import org.jeecgframework.web.cgform.service.impl.config.util.DbTableUtil;
import org.jeecgframework.web.cgform.service.impl.config.util.FieldNumComparator;
import org.springframework.jdbc.core.JdbcTemplate;

public class DbTableServiceMysqlImpl
implements DbTableServiceI {
    @Override
    public String createTableSQL(CgFormHeadEntity cgFormHead) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        sb.append(String.valueOf(cgFormHead.getTableName()) + " (");
        CgFormFieldEntity agoColumn = null;
        Collections.sort(cgFormHead.getColumns(), new FieldNumComparator());
        String idField = "";
        Collections.sort(cgFormHead.getColumns(), new FieldNumComparator());
        int i = 0;
        while (i < cgFormHead.getColumns().size()) {
            if (i > 0) {
                agoColumn = cgFormHead.getColumns().get(i - 1);
            }
            CgFormFieldEntity column = cgFormHead.getColumns().get(i);
            sb.append(this.getColumnPorperty(column, agoColumn, false));
            if (column.getIsKey().equals("Y")) {
                idField = String.valueOf(idField) + DbTableUtil.translatorToDbField(DbTableUtil.translatorToDbField(column.getFieldName())) + ",";
            }
            ++i;
        }
        sb.append(" PRIMARY KEY (" + idField.substring(0, idField.length() - 1) + ")");
        sb.append(") ENGINE=InnoDB DEFAULT CHARSET=utf8;");
        return sb.toString();
    }

    @Override
    public String dropTableSQL(CgFormHeadEntity tableProperty) {
        return " DROP TABLE IF EXISTS " + tableProperty.getTableName() + " ;";
    }

    @Override
    public String updateTableSQL(CgFormHeadEntity cgFormHead, JdbcTemplate jdbcTemplate) {
        String sql = "select column_name,data_type,column_comment,numeric_precision,numeric_scale,character_maximum_length,is_nullable nullable from information_schema.columns where table_name =  '" + cgFormHead.getTableName() + "'and table_schema = '" + CodeResourceUtil.DATABASE_NAME + "';";
        Map<String, Object> fieldMap = DbTableUtil.getColumnMap(jdbcTemplate.queryForList(sql));
        StringBuilder sb = new StringBuilder();
        sb.append(this.createChangeTableSql(cgFormHead));
        CgFormFieldEntity agoColumn = null;
        String idField = "";
        Collections.sort(cgFormHead.getColumns(), new FieldNumComparator());
        int i = 0;
        while (i < cgFormHead.getColumns().size()) {
            CgFormFieldEntity column;
            if (i > 0) {
                agoColumn = cgFormHead.getColumns().get(i - 1);
            }
            if (fieldMap.containsKey(DbTableUtil.translatorToDbField((column = cgFormHead.getColumns().get(i)).getFieldName()))) {
                sb.append(this.createUpdateColumnSql(column, agoColumn));
                fieldMap.remove(DbTableUtil.translatorToDbField(column.getFieldName()));
            } else {
                sb.append(this.createAddColumnSql(column, agoColumn));
            }
            if (column.getIsKey().equals("Y")) {
                idField = String.valueOf(idField) + DbTableUtil.translatorToDbField(column.getFieldName()) + ",";
            }
            ++i;
        }
        Collection<Object> c = fieldMap.values();
        for (Map map : c) {
            sb.append(this.createDropColumn(map.get("column_name").toString()));
        }
        sb.append("DROP PRIMARY KEY,ADD PRIMARY KEY (" + idField.substring(0, idField.length() - 1) + ")");
        return sb.toString();
    }

    private String createAddColumnSql(CgFormFieldEntity column, CgFormFieldEntity agoColumn) {
        return " ADD COLUMN " + this.getColumnPorperty(column, agoColumn, true);
    }

    private String createUpdateColumnSql(CgFormFieldEntity newColumn, CgFormFieldEntity agoColumn) {
        return " MODIFY COLUMN " + this.getColumnPorperty(newColumn, agoColumn, true);
    }

    private String createDropColumn(String fieldName) {
        return " DROP COLUMN " + fieldName + ",";
    }

    private String getColumnPorperty(CgFormFieldEntity column, CgFormFieldEntity agoColumn, boolean isUpdate) {
        String result = " " + DbTableUtil.translatorToDbField(column.getFieldName()) + " " + this.getFieldType(column) + " ";
        result = String.valueOf(result) + (StringUtil.isEmpty(column.getIsNull()) ? " NOT NULL " : "NULL");
        result = String.valueOf(result) + " COMMENT '" + column.getContent() + "' ";
        if (isUpdate) {
            String agoFiled = " FIRST ";
            if (agoColumn != null) {
                agoFiled = " AFTER " + DbTableUtil.translatorToDbField(agoColumn.getFieldName());
            }
            result = String.valueOf(result) + agoFiled;
        }
        return String.valueOf(result) + ", ";
    }

    private String getFieldType(CgFormFieldEntity cloumn) {
        String result = "";
        if (cloumn.getType().equals("string")) {
            result = "varchar(" + cloumn.getLength() + ")";
        } else if (cloumn.getType().equals("Date")) {
            result = "datetime";
        } else if (cloumn.getType().equals("int")) {
            result = String.valueOf(cloumn.getType()) + "(" + cloumn.getLength() + ")";
        } else if (cloumn.getType().equals("double")) {
            result = String.valueOf(cloumn.getType()) + "(" + cloumn.getLength() + "," + cloumn.getPointLength() + ")";
        }
        return result;
    }

    private String createChangeTableSql(CgFormHeadEntity table) {
        return "ALTER TABLE " + table.getTableName() + " ";
    }

    @Override
    public String createIsExitSql(String tableName) {
        return "SELECT COUNT(*) FROM information_schema.TABLES WHERE TABLE_NAME='" + tableName + "' and table_schema = '" + CodeResourceUtil.DATABASE_NAME + "';";
    }
}

