/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.service.impl.config;

import org.apache.commons.lang.StringUtils;
import org.jeecgframework.web.cgform.exception.DBException;
import org.jeecgframework.web.cgform.service.config.DbTableHandleI;
import org.jeecgframework.web.cgform.service.impl.config.util.ColumnMeta;

public class DbTablePostgresHandleImpl
implements DbTableHandleI {
    @Override
    public String getAddColumnSql(ColumnMeta columnMeta) {
        return " ADD COLUMN " + this.getAddFieldDesc(columnMeta) + ";";
    }

    @Override
    public String getReNameFieldName(ColumnMeta columnMeta) {
        return " RENAME  COLUMN  " + columnMeta.getOldColumnName() + " to " + columnMeta.getColumnName() + ";";
    }

    @Override
    public String getUpdateColumnSql(ColumnMeta cgformcolumnMeta, ColumnMeta datacolumnMeta) throws DBException {
        return "  ALTER  COLUMN   " + this.getUpdateFieldDesc(cgformcolumnMeta, datacolumnMeta) + ";";
    }

    @Override
    public String getSpecialHandle(ColumnMeta cgformcolumnMeta, ColumnMeta datacolumnMeta) {
        return "  ALTER  COLUMN   " + this.getUpdateFieldDefault(cgformcolumnMeta, datacolumnMeta) + ";";
    }

    @Override
    public String getMatchClassTypeByDataType(String dataType, int digits) {
        String result = "";
        if (dataType.equalsIgnoreCase("varchar")) {
            result = "string";
        } else if (dataType.equalsIgnoreCase("double")) {
            result = "double";
        } else if (dataType.contains("int")) {
            result = "int";
        } else if (dataType.equalsIgnoreCase("Date")) {
            result = "date";
        } else if (dataType.equalsIgnoreCase("timestamp")) {
            result = "date";
        } else if (dataType.equalsIgnoreCase("bytea")) {
            result = "blob";
        } else if (dataType.equalsIgnoreCase("text")) {
            result = "text";
        } else if (dataType.equalsIgnoreCase("decimal")) {
            result = "bigdecimal";
        } else if (dataType.equalsIgnoreCase("numeric")) {
            result = "bigdecimal";
        }
        return result;
    }

    @Override
    public String dropTableSQL(String tableName) {
        return " DROP TABLE  " + tableName + " ;";
    }

    @Override
    public String getDropColumnSql(String fieldName) {
        return " DROP COLUMN " + fieldName + ";";
    }

    private String getUpdateFieldDesc(ColumnMeta cgfromcolumnMeta, ColumnMeta datacolumnMeta) throws DBException {
        String result = "";
        if (cgfromcolumnMeta.getColunmType().equalsIgnoreCase("string")) {
            result = String.valueOf(cgfromcolumnMeta.getColumnName()) + "  type character varying(" + cgfromcolumnMeta.getColumnSize() + ")" + " ";
        } else if (cgfromcolumnMeta.getColunmType().equalsIgnoreCase("date")) {
            result = String.valueOf(cgfromcolumnMeta.getColumnName()) + "  type datetime" + " ";
        } else if (cgfromcolumnMeta.getColunmType().equalsIgnoreCase("int")) {
            result = String.valueOf(cgfromcolumnMeta.getColumnName()) + " type int4 ";
        } else if (cgfromcolumnMeta.getColunmType().equalsIgnoreCase("double")) {
            result = String.valueOf(cgfromcolumnMeta.getColumnName()) + " type  numeric(" + cgfromcolumnMeta.getColumnSize() + "," + cgfromcolumnMeta.getDecimalDigits() + ")" + " ";
        } else if (cgfromcolumnMeta.getColunmType().equalsIgnoreCase("BigDecimal")) {
            result = String.valueOf(cgfromcolumnMeta.getColumnName()) + " type  decimal(" + cgfromcolumnMeta.getColumnSize() + "," + cgfromcolumnMeta.getDecimalDigits() + ")" + " ";
        } else if (cgfromcolumnMeta.getColunmType().equalsIgnoreCase("text")) {
            result = String.valueOf(cgfromcolumnMeta.getColumnName()) + "  type text(" + cgfromcolumnMeta.getColumnSize() + ")" + " ";
        } else if (cgfromcolumnMeta.getColunmType().equalsIgnoreCase("blob")) {
            throw new DBException("blob\u7c7b\u578b\u4e0d\u53ef\u4fee\u6539");
        }
        return result;
    }

    private String getUpdateFieldDefault(ColumnMeta cgfromcolumnMeta, ColumnMeta datacolumnMeta) {
        String result = "";
        if (!cgfromcolumnMeta.equalsDefault(datacolumnMeta)) {
            if (cgfromcolumnMeta.getColunmType().equalsIgnoreCase("string")) {
                result = cgfromcolumnMeta.getColumnName();
                result = String.valueOf(result) + (StringUtils.isNotEmpty((String)cgfromcolumnMeta.getFieldDefault()) ? " SET DEFAULT " + cgfromcolumnMeta.getFieldDefault() : " DROP DEFAULT");
            } else if (cgfromcolumnMeta.getColunmType().equalsIgnoreCase("date")) {
                result = cgfromcolumnMeta.getColumnName();
                result = String.valueOf(result) + (StringUtils.isNotEmpty((String)cgfromcolumnMeta.getFieldDefault()) ? " SET DEFAULT " + cgfromcolumnMeta.getFieldDefault() : " DROP DEFAULT");
            } else if (cgfromcolumnMeta.getColunmType().equalsIgnoreCase("int")) {
                result = cgfromcolumnMeta.getColumnName();
                result = String.valueOf(result) + (StringUtils.isNotEmpty((String)cgfromcolumnMeta.getFieldDefault()) ? " SET DEFAULT " + cgfromcolumnMeta.getFieldDefault() : " DROP DEFAULT");
            } else if (cgfromcolumnMeta.getColunmType().equalsIgnoreCase("double")) {
                result = cgfromcolumnMeta.getColumnName();
                result = String.valueOf(result) + (StringUtils.isNotEmpty((String)cgfromcolumnMeta.getFieldDefault()) ? " SET DEFAULT " + cgfromcolumnMeta.getFieldDefault() : " DROP DEFAULT");
            } else if (cgfromcolumnMeta.getColunmType().equalsIgnoreCase("bigdecimal")) {
                result = cgfromcolumnMeta.getColumnName();
                result = String.valueOf(result) + (StringUtils.isNotEmpty((String)cgfromcolumnMeta.getFieldDefault()) ? " SET DEFAULT " + cgfromcolumnMeta.getFieldDefault() : " DROP DEFAULT");
            } else if (cgfromcolumnMeta.getColunmType().equalsIgnoreCase("text")) {
                result = cgfromcolumnMeta.getColumnName();
                result = String.valueOf(result) + (StringUtils.isNotEmpty((String)cgfromcolumnMeta.getFieldDefault()) ? " SET DEFAULT " + cgfromcolumnMeta.getFieldDefault() : " DROP DEFAULT");
            }
        }
        return result;
    }

    private String getAddFieldDesc(ColumnMeta cgfromcolumnMeta) {
        String result = "";
        if (cgfromcolumnMeta.getColunmType().equalsIgnoreCase("string")) {
            result = String.valueOf(cgfromcolumnMeta.getColumnName()) + " character varying(" + cgfromcolumnMeta.getColumnSize() + ")" + " ";
        } else if (cgfromcolumnMeta.getColunmType().equalsIgnoreCase("date")) {
            result = String.valueOf(cgfromcolumnMeta.getColumnName()) + " datetime" + " ";
        } else if (cgfromcolumnMeta.getColunmType().equalsIgnoreCase("int")) {
            result = String.valueOf(cgfromcolumnMeta.getColumnName()) + " int4";
        } else if (cgfromcolumnMeta.getColunmType().equalsIgnoreCase("double")) {
            result = String.valueOf(cgfromcolumnMeta.getColumnName()) + " numeric(" + cgfromcolumnMeta.getColumnSize() + "," + cgfromcolumnMeta.getDecimalDigits() + ")" + " ";
        } else if (cgfromcolumnMeta.getColunmType().equalsIgnoreCase("bigdecimal")) {
            result = String.valueOf(cgfromcolumnMeta.getColumnName()) + " decimal(" + cgfromcolumnMeta.getColumnSize() + "," + cgfromcolumnMeta.getDecimalDigits() + ")" + " ";
        } else if (cgfromcolumnMeta.getColunmType().equalsIgnoreCase("blob")) {
            result = String.valueOf(cgfromcolumnMeta.getColumnName()) + " bytea(" + cgfromcolumnMeta.getColumnSize() + ")" + " ";
        } else if (cgfromcolumnMeta.getColunmType().equalsIgnoreCase("text")) {
            result = String.valueOf(cgfromcolumnMeta.getColumnName()) + " text(" + cgfromcolumnMeta.getColumnSize() + ")" + " ";
        }
        result = String.valueOf(result) + (StringUtils.isNotEmpty((String)cgfromcolumnMeta.getFieldDefault()) ? " DEFAULT " + cgfromcolumnMeta.getFieldDefault() : " ");
        return result;
    }

    private String getRenameFieldDesc(ColumnMeta cgfromcolumnMeta) {
        String result = "";
        if (cgfromcolumnMeta.getColunmType().equalsIgnoreCase("string")) {
            result = String.valueOf(cgfromcolumnMeta.getColumnName()) + " character varying(" + cgfromcolumnMeta.getColumnSize() + ")" + " ";
        } else if (cgfromcolumnMeta.getColunmType().equalsIgnoreCase("date")) {
            result = String.valueOf(cgfromcolumnMeta.getColumnName()) + " datetime" + " ";
        } else if (cgfromcolumnMeta.getColunmType().equalsIgnoreCase("int")) {
            result = String.valueOf(cgfromcolumnMeta.getColumnName()) + " int(" + cgfromcolumnMeta.getColumnSize() + ")" + " ";
        } else if (cgfromcolumnMeta.getColunmType().equalsIgnoreCase("double")) {
            result = String.valueOf(cgfromcolumnMeta.getColumnName()) + " numeric(" + cgfromcolumnMeta.getColumnSize() + "," + cgfromcolumnMeta.getDecimalDigits() + ")" + " ";
        }
        return result;
    }

    @Override
    public String getCommentSql(ColumnMeta columnMeta) {
        return "COMMENT ON COLUMN " + columnMeta.getTableName() + "." + columnMeta.getColumnName() + " IS '" + columnMeta.getComment() + "'";
    }
}

