/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.service.impl.config;

import org.apache.commons.lang.StringUtils;
import org.jeecgframework.web.cgform.service.config.DbTableHandleI;
import org.jeecgframework.web.cgform.service.impl.config.util.ColumnMeta;

public class DbTableOracleHandleImpl
implements DbTableHandleI {
    @Override
    public String getAddColumnSql(ColumnMeta columnMeta) {
        return " ADD  " + this.getAddFieldDesc(columnMeta);
    }

    @Override
    public String getReNameFieldName(ColumnMeta columnMeta) {
        return "RENAME COLUMN  " + columnMeta.getOldColumnName() + " TO " + columnMeta.getColumnName();
    }

    @Override
    public String getUpdateColumnSql(ColumnMeta cgformcolumnMeta, ColumnMeta datacolumnMeta) {
        return " MODIFY   " + this.getUpdateFieldDesc(cgformcolumnMeta, datacolumnMeta);
    }

    @Override
    public String getMatchClassTypeByDataType(String dataType, int digits) {
        String result = "";
        if (dataType.equalsIgnoreCase("varchar2")) {
            result = "string";
        } else if (dataType.equalsIgnoreCase("double")) {
            result = "double";
        } else if (dataType.equalsIgnoreCase("number") && digits == 0) {
            result = "int";
        } else if (dataType.equalsIgnoreCase("number") && digits != 0) {
            result = "double";
        } else if (dataType.equalsIgnoreCase("int")) {
            result = "int";
        } else if (dataType.equalsIgnoreCase("Date")) {
            result = "date";
        } else if (dataType.equalsIgnoreCase("Datetime")) {
            result = "date";
        }
        return result;
    }

    @Override
    public String dropTableSQL(String tableName) {
        return " DROP TABLE  " + tableName.toLowerCase() + " ";
    }

    @Override
    public String getDropColumnSql(String fieldName) {
        return " DROP COLUMN " + fieldName.toUpperCase();
    }

    private String getAddFieldDesc(ColumnMeta columnMeta) {
        String result = "";
        if (columnMeta.getColunmType().equalsIgnoreCase("string")) {
            result = String.valueOf(columnMeta.getColumnName()) + " varchar2(" + columnMeta.getColumnSize() + ")";
        } else if (columnMeta.getColunmType().equalsIgnoreCase("date")) {
            result = String.valueOf(columnMeta.getColumnName()) + " datetime";
        } else if (columnMeta.getColunmType().equalsIgnoreCase("int")) {
            result = String.valueOf(columnMeta.getColumnName()) + " NUMBER(" + columnMeta.getColumnSize() + ")";
        } else if (columnMeta.getColunmType().equalsIgnoreCase("double")) {
            result = String.valueOf(columnMeta.getColumnName()) + " NUMBER(" + columnMeta.getColumnSize() + "," + columnMeta.getDecimalDigits() + ")";
        } else if (columnMeta.getColunmType().equalsIgnoreCase("bigdecimal")) {
            result = String.valueOf(columnMeta.getColumnName()) + " NUMBER(" + columnMeta.getColumnSize() + "," + columnMeta.getDecimalDigits() + ")";
        } else if (columnMeta.getColunmType().equalsIgnoreCase("text")) {
            result = String.valueOf(columnMeta.getColumnName()) + " CLOB ";
        } else if (columnMeta.getColunmType().equalsIgnoreCase("blob")) {
            result = String.valueOf(columnMeta.getColumnName()) + " BLOB ";
        }
        result = String.valueOf(result) + (StringUtils.isNotEmpty((String)columnMeta.getFieldDefault()) ? " DEFAULT " + columnMeta.getFieldDefault() : " ");
        result = String.valueOf(result) + (columnMeta.getIsNullable().equals("Y") ? " NULL" : " NOT NULL");
        return result;
    }

    private String getUpdateFieldDesc(ColumnMeta cgformcolumnMeta, ColumnMeta datacolumnMeta) {
        String result = "";
        String isnull = "";
        if (!datacolumnMeta.getIsNullable().equals(cgformcolumnMeta.getIsNullable())) {
            String string = isnull = cgformcolumnMeta.getIsNullable().equals("Y") ? "NULL" : "NOT NULL";
        }
        if (cgformcolumnMeta.getColunmType().equalsIgnoreCase("string") || cgformcolumnMeta.getColunmType().equalsIgnoreCase("text")) {
            result = String.valueOf(cgformcolumnMeta.getColumnName()) + " varchar2(" + cgformcolumnMeta.getColumnSize() + ")" + isnull;
        } else if (cgformcolumnMeta.getColunmType().equalsIgnoreCase("date")) {
            result = String.valueOf(cgformcolumnMeta.getColumnName()) + " date " + isnull;
        } else if (cgformcolumnMeta.getColunmType().equalsIgnoreCase("int")) {
            result = String.valueOf(cgformcolumnMeta.getColumnName()) + " NUMBER(" + cgformcolumnMeta.getColumnSize() + ") " + isnull;
        } else if (cgformcolumnMeta.getColunmType().equalsIgnoreCase("double")) {
            result = String.valueOf(cgformcolumnMeta.getColumnName()) + " NUMBER(" + cgformcolumnMeta.getColumnSize() + "," + cgformcolumnMeta.getDecimalDigits() + ") " + isnull;
        } else if (cgformcolumnMeta.getColunmType().equalsIgnoreCase("bigdecimal")) {
            result = String.valueOf(cgformcolumnMeta.getColumnName()) + " NUMBER(" + cgformcolumnMeta.getColumnSize() + "," + cgformcolumnMeta.getDecimalDigits() + ") " + isnull;
        }
        result = String.valueOf(result) + (StringUtils.isNotEmpty((String)cgformcolumnMeta.getFieldDefault()) ? " DEFAULT " + cgformcolumnMeta.getFieldDefault() : " ");
        result = String.valueOf(result) + isnull;
        return result;
    }

    @Override
    public String getCommentSql(ColumnMeta columnMeta) {
        return "COMMENT ON COLUMN " + columnMeta.getTableName() + "." + columnMeta.getColumnName() + " IS '" + columnMeta.getComment() + "'";
    }

    @Override
    public String getSpecialHandle(ColumnMeta cgformcolumnMeta, ColumnMeta datacolumnMeta) {
        return null;
    }
}

