/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.service.impl.config;

import com.sun.star.uno.RuntimeException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.jeecgframework.core.annotation.Ehcache;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.cgform.dao.config.CgFormFieldDao;
import org.jeecgframework.web.cgform.dao.config.CgFormVersionDao;
import org.jeecgframework.web.cgform.entity.config.CgFormFieldEntity;
import org.jeecgframework.web.cgform.entity.config.CgFormHeadEntity;
import org.jeecgframework.web.cgform.entity.config.CgSubTableVO;
import org.jeecgframework.web.cgform.entity.enhance.CgformEnhanceJsEntity;
import org.jeecgframework.web.cgform.exception.BusinessException;
import org.jeecgframework.web.cgform.service.cgformftl.CgformFtlServiceI;
import org.jeecgframework.web.cgform.service.config.CgFormFieldServiceI;
import org.jeecgframework.web.cgform.service.config.DbTableHandleI;
import org.jeecgframework.web.cgform.service.enhance.CgformEnhanceJsServiceI;
import org.jeecgframework.web.cgform.service.impl.config.util.DbTableProcess;
import org.jeecgframework.web.cgform.service.impl.config.util.DbTableUtil;
import org.jeecgframework.web.cgform.util.PublicUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.hibernate4.SessionFactoryUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="cgFormFieldService")
@Transactional
public class CgFormFieldServiceImpl
extends CommonServiceImpl
implements CgFormFieldServiceI {
    private static final Logger logger = Logger.getLogger(CgFormFieldServiceImpl.class);
    private static final String SYN_NORMAL = "normal";
    private static final String SYN_FORCE = "force";
    @Autowired
    @Qualifier(value="jdbcTemplate")
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private CgFormVersionDao cgFormVersionDao;
    @Autowired
    private CgformFtlServiceI cgformFtlService;
    @Autowired
    private CgformEnhanceJsServiceI cgformEnhanceJsService;
    @Autowired
    private CgFormFieldDao cgFormFieldDao;

    @Override
    public synchronized void updateTable(CgFormHeadEntity t, String sign) {
        boolean databaseFieldIsChange = false;
        int i = 0;
        while (i < t.getColumns().size()) {
            CgFormFieldEntity column = t.getColumns().get(i);
            if (!oConvertUtils.isEmpty(column.getFieldName())) {
                column.setTable(t);
                PublicUtil.judgeCheckboxValue(column, "isNull,isShow,isShowList,isQuery,isKey");
                if (oConvertUtils.isEmpty(column.getId())) {
                    databaseFieldIsChange = true;
                    this.save(column);
                } else {
                    CgFormFieldEntity c = (CgFormFieldEntity)this.getEntity(CgFormFieldEntity.class, (Serializable)((Object)column.getId()));
                    if (!databaseFieldIsChange && this.databaseFieldIsChange(c, column)) {
                        databaseFieldIsChange = true;
                    }
                    try {
                        MyBeanUtils.copyBeanNotNull2Bean(column, c);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error((Object)e);
                    }
                    this.saveOrUpdate(c);
                }
            }
            ++i;
        }
        t.setIsDbSynch(databaseFieldIsChange ? "N" : t.getIsDbSynch());
        Integer newVerion = Integer.parseInt(t.getJformVersion()) + 1;
        t.setJformVersion(newVerion.toString());
        this.saveOrUpdate(t);
    }

    private boolean databaseFieldIsChange(CgFormFieldEntity oldColumn, CgFormFieldEntity newColumn) {
        return !PublicUtil.compareValue(oldColumn.getFieldName(), newColumn.getFieldName()) || !PublicUtil.compareValue(oldColumn.getContent(), newColumn.getContent()) || !PublicUtil.compareValue(oldColumn.getLength(), newColumn.getLength()) || !PublicUtil.compareValue(oldColumn.getPointLength(), newColumn.getPointLength()) || !PublicUtil.compareValue(oldColumn.getType(), newColumn.getType()) || !PublicUtil.compareValue(oldColumn.getIsNull(), newColumn.getIsNull()) || !PublicUtil.compareValue(oldColumn.getOrderNum(), newColumn.getOrderNum()) || !PublicUtil.compareValue(oldColumn.getIsKey(), newColumn.getIsKey()) || !PublicUtil.compareValue(oldColumn.getMainTable(), newColumn.getMainTable()) || !PublicUtil.compareValue(oldColumn.getMainField(), newColumn.getMainField()) || !PublicUtil.compareValue(oldColumn.getFieldDefault(), newColumn.getFieldDefault());
    }

    @Override
    public void saveTable(CgFormHeadEntity cgFormHead) {
        cgFormHead.setJformVersion("1");
        cgFormHead.setIsDbSynch("N");
        cgFormHead.setId((String)((Object)this.getSession().save((Object)cgFormHead)));
        int i = 0;
        while (i < cgFormHead.getColumns().size()) {
            CgFormFieldEntity column = cgFormHead.getColumns().get(i);
            PublicUtil.judgeCheckboxValue(column, "isNull,isShow,isShowList,isQuery,isKey");
            column.setTable(cgFormHead);
            this.save(column);
            ++i;
        }
    }

    @Override
    public void saveTable(CgFormHeadEntity cgFormHead, String a) {
        cgFormHead.setId((String)((Object)this.getSession().save((Object)cgFormHead)));
        int i = 0;
        while (i < cgFormHead.getColumns().size()) {
            CgFormFieldEntity column = cgFormHead.getColumns().get(i);
            PublicUtil.judgeCheckboxValue(column, "isNull,isShow,isShowList,isQuery,isKey");
            column.setTable(cgFormHead);
            this.save(column);
            ++i;
        }
    }

    @Override
    public Boolean judgeTableIsExit(String tableName) {
        Connection conn = null;
        ResultSet rs = null;
        String tableNamePattern = tableName;
        try {
            String[] types = new String[]{"TABLE"};
            conn = SessionFactoryUtils.getDataSource((SessionFactory)this.getSession().getSessionFactory()).getConnection();
            String dataBaseType = DbTableUtil.getDataType(this.getSession());
            if ("ORACLE".equals(dataBaseType)) {
                tableNamePattern = tableName.toUpperCase();
            } else if ("POSTGRESQL".equals(dataBaseType)) {
                tableNamePattern = tableName.toLowerCase();
            }
            DatabaseMetaData dbMetaData = conn.getMetaData();
            rs = dbMetaData.getTables(null, null, tableNamePattern, types);
            if (rs.next()) {
                Boolean bl = true;
                return bl;
            }
            Boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean dbSynch(CgFormHeadEntity cgFormHead, String synMethod) throws BusinessException {
        block13: {
            try {
                if (SYN_NORMAL.equals(synMethod)) {
                    if (this.judgeTableIsExit(cgFormHead.getTableName()).booleanValue()) {
                        DbTableProcess dbTableProcess = new DbTableProcess(this.getSession());
                        List<String> updateTable = dbTableProcess.updateTable(cgFormHead, this.getSession());
                        for (String sql : updateTable) {
                            if (!StringUtils.isNotEmpty((String)sql)) continue;
                            this.executeSql(sql, new Object[0]);
                        }
                    } else {
                        try {
                            DbTableProcess.createOrDropTable(cgFormHead, this.getSession());
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                            throw new BusinessException("\u540c\u6b65\u5931\u8d25:\u521b\u5efa\u65b0\u8868\u51fa\u9519");
                        }
                    }
                    cgFormHead.setIsDbSynch("Y");
                    this.saveOrUpdate(cgFormHead);
                    break block13;
                }
                if (!SYN_FORCE.equals(synMethod)) break block13;
                try {
                    try {
                        String sql = this.getTableUtil().dropTableSQL(cgFormHead.getTableName());
                        this.executeSql(sql, new Object[0]);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage());
                    }
                    DbTableProcess.createOrDropTable(cgFormHead, this.getSession());
                    cgFormHead.setIsDbSynch("Y");
                    this.saveOrUpdate(cgFormHead);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BusinessException("\u540c\u6b65\u5931\u8d25:\u521b\u5efa\u65b0\u8868\u51fa\u9519");
                }
            }
            catch (BusinessException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BusinessException(e.getMessage());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BusinessException("\u540c\u6b65\u5931\u8d25:\u6570\u636e\u5e93\u4e0d\u652f\u6301\u672c\u6b21\u4fee\u6539,\u5982\u679c\u4e0d\u9700\u8981\u4fdd\u7559\u6570\u636e,\u8bf7\u5c1d\u8bd5\u5f3a\u5236\u540c\u6b65");
            }
        }
        return true;
    }

    @Override
    public void deleteCgForm(CgFormHeadEntity cgFormHead) {
        if (this.judgeTableIsExit(cgFormHead.getTableName()).booleanValue()) {
            String sql = this.getTableUtil().dropTableSQL(cgFormHead.getTableName());
            this.executeSql(sql, new Object[0]);
        }
        this.delete(cgFormHead);
    }

    private DbTableHandleI getTableUtil() {
        return DbTableUtil.getTableHandle(this.getSession());
    }

    @Override
    public List<Map<String, Object>> getCgFormFieldByTableName(String tableName) {
        List<Map<String, Object>> list = this.cgFormFieldDao.getCgFormFieldByTableName(tableName);
        return list;
    }

    private List<Map<String, Object>> getCgFormHiddenFieldByTableName(String tableName) {
        List<Map<String, Object>> list = this.cgFormFieldDao.getCgFormHiddenFieldByTableName(tableName);
        if (list != null && list.size() > 0) {
            for (Map<String, Object> map : list) {
                if (!"id".equalsIgnoreCase((String)map.get("field_name"))) continue;
                list.remove(map);
                break;
            }
        } else {
            list = new ArrayList<Map<String, Object>>();
        }
        return list;
    }

    @Override
    public Map<String, CgFormFieldEntity> getCgFormFieldByFormId(String formid) {
        StringBuilder hql = new StringBuilder("");
        hql.append("from CgFormFieldEntity f");
        hql.append(" where f.table.id=? ");
        List list = this.findHql(hql.toString(), formid);
        HashMap<String, CgFormFieldEntity> map = new HashMap<String, CgFormFieldEntity>();
        if (list != null && list.size() > 0) {
            for (CgFormFieldEntity po : list) {
                map.put(po.getFieldName(), po);
            }
        }
        return map;
    }

    @Override
    public Map<String, CgFormFieldEntity> getAllCgFormFieldByTableName(String tableName) {
        StringBuilder hql = new StringBuilder("");
        hql.append("from CgFormFieldEntity f");
        hql.append(" where f.table.tableName=? ");
        List list = this.findHql(hql.toString(), tableName);
        HashMap<String, CgFormFieldEntity> map = new HashMap<String, CgFormFieldEntity>();
        if (list != null && list.size() > 0) {
            for (CgFormFieldEntity po : list) {
                map.put(po.getFieldName(), po);
            }
        }
        return map;
    }

    @Override
    @Ehcache
    public Map<String, CgFormFieldEntity> getAllCgFormFieldByTableName(String tableName, String version) {
        StringBuilder hql = new StringBuilder("");
        hql.append("from CgFormFieldEntity f");
        hql.append(" where f.table.tableName=? ");
        List list = this.findHql(hql.toString(), tableName);
        HashMap<String, CgFormFieldEntity> map = new HashMap<String, CgFormFieldEntity>();
        if (list != null && list.size() > 0) {
            for (CgFormFieldEntity po : list) {
                map.put(po.getFieldName(), po);
            }
        }
        return map;
    }

    @Override
    public CgFormHeadEntity getCgFormHeadByTableName(String tableName) {
        StringBuilder hql = new StringBuilder("");
        hql.append("from CgFormHeadEntity f");
        hql.append(" where f.tableName=? ");
        List list = this.findHql(hql.toString(), tableName);
        if (list != null && list.size() > 0) {
            return (CgFormHeadEntity)list.get(0);
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> getSubTableData(String mainTableName, String subTableName, Object mainTableId) {
        StringBuilder sql1 = new StringBuilder("");
        sql1.append("select f.* from cgform_field f ,cgform_head h");
        sql1.append(" where f.table_id = h.id ");
        sql1.append(" and h.table_name=? ");
        sql1.append(" and f.main_table=? ");
        List<Map<String, Object>> list = this.findForJdbc(sql1.toString(), subTableName, mainTableName);
        StringBuilder sql2 = new StringBuilder("");
        sql2.append("select sub.* from ").append(subTableName).append(" sub ");
        sql2.append(", ").append(mainTableName).append(" main ");
        sql2.append("where 1=1 ");
        if (list != null && list.size() > 0) {
            for (Map<String, Object> map : list) {
                if (map.get("main_field") == null) continue;
                sql2.append(" and sub.").append((String)map.get("field_name")).append("=").append("main.").append((String)map.get("main_field"));
            }
        }
        sql2.append(" and main.id= ? ");
        List<Map<String, Object>> subTableDataList = this.findForJdbc(sql2.toString(), mainTableId);
        return subTableDataList;
    }

    @Override
    public boolean appendSubTableStr4Main(CgFormHeadEntity entity) {
        String thisSubTable = entity.getTableName();
        List<CgFormFieldEntity> columns = entity.getColumns();
        for (CgFormFieldEntity fieldE : columns) {
            CgFormHeadEntity mainE;
            String mainT = fieldE.getMainTable();
            String mainF = fieldE.getMainField();
            if (StringUtil.isEmpty(mainT) || StringUtil.isEmpty(mainF) || (mainE = this.getCgFormHeadByTableName(mainT)) == null) continue;
            String subTableStr = String.valueOf(mainE.getSubTableStr() == null ? "" : mainE.getSubTableStr());
            if (!subTableStr.contains(thisSubTable)) {
                subTableStr = !StringUtil.isEmpty(subTableStr) ? String.valueOf(subTableStr) + "," + thisSubTable : String.valueOf(subTableStr) + thisSubTable;
                mainE.setSubTableStr(subTableStr);
                logger.info((Object)("--\u4e3b\u8868" + mainE.getTableName() + "\u7684\u9644\u8868\u4e32\uff1a" + mainE.getSubTableStr()));
            }
            this.updateTable(mainE, "sign");
        }
        return true;
    }

    @Override
    public boolean removeSubTableStr4Main(CgFormHeadEntity entity) {
        if (entity == null) {
            return false;
        }
        String thisSubTable = entity.getTableName();
        List<CgFormFieldEntity> columns = entity.getColumns();
        for (CgFormFieldEntity fieldE : columns) {
            String subTableStr;
            CgFormHeadEntity mainE;
            String mainT = fieldE.getMainTable();
            String mainF = fieldE.getMainField();
            if (StringUtil.isEmpty(mainT) || StringUtil.isEmpty(mainF) || (mainE = this.getCgFormHeadByTableName(mainT)) == null || !(subTableStr = String.valueOf(mainE.getSubTableStr() == null ? "" : mainE.getSubTableStr())).contains(thisSubTable)) continue;
            subTableStr = subTableStr.contains(String.valueOf(thisSubTable) + ",") ? subTableStr.replace(String.valueOf(thisSubTable) + ",", "") : (subTableStr.contains("," + thisSubTable) ? subTableStr.replace("," + thisSubTable, "") : subTableStr.replace(thisSubTable, ""));
            mainE.setSubTableStr(subTableStr);
            logger.info((Object)("--\u4e3b\u8868" + mainE.getTableName() + "\u7684\u9644\u8868\u4e32\uff1a" + mainE.getSubTableStr()));
        }
        return true;
    }

    @Override
    public void sortSubTableStr(CgFormHeadEntity entity) {
        if (entity == null) {
            return;
        }
        CgFormHeadEntity main = null;
        List<CgFormFieldEntity> columns = entity.getColumns();
        for (CgFormFieldEntity fieldE : columns) {
            CgFormHeadEntity mainE;
            String mainT = fieldE.getMainTable();
            String mainF = fieldE.getMainField();
            if (StringUtil.isEmpty(mainT) || StringUtil.isEmpty(mainF) || (mainE = this.getCgFormHeadByTableName(mainT)) == null) continue;
            main = mainE;
        }
        if (main == null) {
            return;
        }
        String subTableStr = main.getSubTableStr();
        if (StringUtils.isNotEmpty((String)subTableStr)) {
            String[] subTables = subTableStr.split(",");
            if (subTables.length <= 1) {
                return;
            }
            ArrayList<CgFormHeadEntity> subList = new ArrayList<CgFormHeadEntity>();
            String[] stringArray = subTables;
            int n = subTables.length;
            int n2 = 0;
            while (n2 < n) {
                String subTable = stringArray[n2];
                CgFormHeadEntity sub = this.getCgFormHeadByTableName(subTable);
                subList.add(sub);
                ++n2;
            }
            Collections.sort(subList, new Comparator<CgFormHeadEntity>(){

                @Override
                public int compare(CgFormHeadEntity arg0, CgFormHeadEntity arg1) {
                    Integer tabOrder1;
                    Integer tabOrder0 = arg0.getTabOrder();
                    if (tabOrder0 == null) {
                        tabOrder0 = 0;
                    }
                    if ((tabOrder1 = arg1.getTabOrder()) == null) {
                        tabOrder1 = 0;
                    }
                    return tabOrder0.compareTo(tabOrder1);
                }
            });
            subTableStr = "";
            for (CgFormHeadEntity sub : subList) {
                subTableStr = String.valueOf(subTableStr) + sub.getTableName() + ",";
            }
            subTableStr = subTableStr.substring(0, subTableStr.length() - 1);
            main.setSubTableStr(subTableStr);
            this.updateTable(main, "sign");
        }
    }

    @Override
    public String getCgFormVersionByTableName(String tableName) {
        String version = this.cgFormVersionDao.getCgFormVersionByTableName(tableName);
        return StringUtil.isEmpty(version) ? "0" : version;
    }

    @Override
    public String getCgFormVersionById(String id) {
        String version = this.cgFormVersionDao.getCgFormVersionById(id);
        return StringUtil.isEmpty(version) ? "0" : version;
    }

    @Override
    @Ehcache
    public Map<String, Object> getFtlFormConfig(String tableName, String version) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        HashMap<String, CgSubTableVO> field = new HashMap<String, CgSubTableVO>();
        CgFormHeadEntity head = this.getCgFormHeadByTableName(tableName, version);
        data.put("head", head);
        if (head.getJformType() == 2) {
            CgSubTableVO subtableVo = new CgSubTableVO();
            String subTableStr = head.getSubTableStr();
            if (StringUtils.isNotEmpty((String)subTableStr)) {
                String[] subTables = subTableStr.split(",");
                ArrayList<Map<String, Object>> subTalbeFieldList = new ArrayList();
                ArrayList<Map<String, Object>> subTalbeHiddenFieldList = new ArrayList();
                String[] stringArray = subTables;
                int n = subTables.length;
                int n2 = 0;
                while (n2 < n) {
                    String subTable = stringArray[n2];
                    subTalbeFieldList = this.getCgFormFieldByTableName(subTable);
                    subTalbeHiddenFieldList = this.getCgFormHiddenFieldByTableName(subTable);
                    CgFormHeadEntity subhead = this.getCgFormHeadByTableName(subTable);
                    subtableVo = new CgSubTableVO();
                    subtableVo.setHead(subhead);
                    subtableVo.setFieldList(subTalbeFieldList);
                    subtableVo.setHiddenFieldList(subTalbeHiddenFieldList);
                    field.put(subTable, subtableVo);
                    ++n2;
                }
            }
        }
        data.put("field", field);
        data.put("tableName", tableName);
        List<Map<String, Object>> fieldList = null;
        if (head.getJformType() == 2) {
            fieldList = this.getCgFormFieldByTableName(tableName);
        } else {
            Map<String, Object> cgformFtlEntity = this.cgformFtlService.getCgformFtlByTableName(tableName);
            if (cgformFtlEntity == null) {
                fieldList = this.getCgFormFieldByTableName(tableName);
            }
        }
        if (fieldList != null) {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> textareaList = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> map : fieldList) {
                if (!"textarea".equals((String)map.get("show_type"))) {
                    list.add(map);
                    continue;
                }
                textareaList.add(map);
            }
            data.put("columns", list);
            data.put("columnsarea", textareaList);
        }
        List<Map<String, Object>> hiddenFieldList = this.getCgFormHiddenFieldByTableName(tableName);
        data.put("columnhidden", hiddenFieldList);
        String jsCode = "";
        CgformEnhanceJsEntity jsEnhance = this.cgformEnhanceJsService.getCgformEnhanceJsByTypeFormId("form", head.getId());
        if (jsEnhance != null) {
            jsCode = jsEnhance.getCgJsStr();
        }
        data.put("js_plug_in", jsCode);
        return data;
    }

    @Override
    @Ehcache
    public CgFormHeadEntity getCgFormHeadByTableName(String tableName, String version) {
        StringBuilder hql = new StringBuilder("");
        hql.append("from CgFormHeadEntity f");
        hql.append(" where f.tableName=? ");
        List list = this.findHql(hql.toString(), tableName);
        if (list != null && list.size() > 0) {
            return (CgFormHeadEntity)list.get(0);
        }
        return null;
    }

    @Override
    public synchronized boolean updateVersion(String formId) {
        try {
            int newV = Integer.parseInt(this.cgFormVersionDao.getCgFormVersionById(formId)) + 1;
            this.cgFormVersionDao.updateVersion(String.valueOf(String.valueOf(newV)), formId);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug((Object)e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public List<CgFormFieldEntity> getHiddenCgFormFieldByTableName(String tableName) {
        StringBuilder hql = new StringBuilder("");
        hql.append("from CgFormFieldEntity f");
        hql.append(" where f.isShow !='Y' and f.table.tableName=? ");
        List<CgFormFieldEntity> list = this.findHql(hql.toString(), tableName);
        if (list != null && list.size() > 0) {
            for (CgFormFieldEntity po : list) {
                if (!"id".equalsIgnoreCase(po.getFieldName())) continue;
                list.remove(po);
                break;
            }
        } else {
            list = new ArrayList();
        }
        return list;
    }

    @Override
    public boolean checkTableExist(String tableName) {
        boolean result = true;
        try {
            this.findForJdbc("select count(*) from " + tableName, new Object[0]);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }
}

