/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.service.impl.build;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.DBTypeUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.UUIDGenerator;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.cgform.common.CommUtils;
import org.jeecgframework.web.cgform.common.SysVar;
import org.jeecgframework.web.cgform.entity.button.CgformButtonSqlEntity;
import org.jeecgframework.web.cgform.entity.config.CgFormFieldEntity;
import org.jeecgframework.web.cgform.entity.config.CgFormHeadEntity;
import org.jeecgframework.web.cgform.exception.BusinessException;
import org.jeecgframework.web.cgform.service.build.DataBaseService;
import org.jeecgframework.web.cgform.service.config.CgFormFieldServiceI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.jdbc.support.incrementer.OracleSequenceMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.PostgreSQLSequenceMaxValueIncrementer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dataBaseService")
@Transactional
public class DataBaseServiceImpl
extends CommonServiceImpl
implements DataBaseService {
    private static final Logger logger = Logger.getLogger(DataBaseServiceImpl.class);
    @Autowired
    private CgFormFieldServiceI cgFormFieldService;
    @Autowired
    private AbstractRoutingDataSource dataSource;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public int insertTable(String tableName, Map<String, Object> data) {
        CgFormHeadEntity cgFormHeadEntity = this.cgFormFieldService.getCgFormHeadByTableName(tableName);
        this.fillInsertSysVar(data);
        this.keyAdapter(cgFormHeadEntity, data);
        this.dataAdapter(tableName, data);
        String comma = "";
        StringBuffer insertKey = new StringBuffer();
        StringBuffer insertValue = new StringBuffer();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (!this.isContainsFieled(tableName, entry.getKey())) continue;
            insertKey.append(String.valueOf(comma) + entry.getKey());
            if (entry.getValue() != null && entry.getValue().toString().length() > 0) {
                insertValue.append(String.valueOf(comma) + ":" + entry.getKey());
            } else {
                insertValue.append(String.valueOf(comma) + "null");
            }
            comma = ", ";
        }
        String sql = "INSERT INTO " + tableName + " (" + insertKey + ") VALUES (" + insertValue + ")";
        Object key = null;
        try {
            try {
                key = this.executeSqlReturnKey(sql, data);
            }
            catch (DataRetrievalFailureException dataRetrievalFailureException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
        if (key != null && key instanceof Long) {
            data.put("id", key);
        }
        if (cgFormHeadEntity != null) {
            this.executeSqlExtend(cgFormHeadEntity.getId(), "add", data);
        }
        return 1;
    }

    private void keyAdapter(CgFormHeadEntity cgFormHeadEntity, Map<String, Object> data) {
        String pkType = cgFormHeadEntity.getJformPkType();
        String dbType = DBTypeUtil.getDBType();
        if (("NATIVE".equalsIgnoreCase(pkType) || "SEQUENCE".equalsIgnoreCase(pkType)) && "sqlserver".equalsIgnoreCase(dbType)) {
            data.remove("id");
        }
    }

    private Map<String, Object> dataAdapter(String tableName, Map<String, Object> data) {
        Map<String, CgFormFieldEntity> fieldConfigs = this.cgFormFieldService.getAllCgFormFieldByTableName(tableName);
        for (String key : fieldConfigs.keySet()) {
            Comparable<Integer> newV;
            Object beforeV = data.get(key.toString().toLowerCase());
            if (!oConvertUtils.isNotEmpty(beforeV)) continue;
            CgFormFieldEntity fieldConfig = fieldConfigs.get(key);
            String type = fieldConfig.getType();
            if ("date".equalsIgnoreCase(type)) {
                newV = null;
                try {
                    String dateType = fieldConfig.getShowType();
                    if ("datetime".equalsIgnoreCase(dateType)) {
                        newV = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(String.valueOf(beforeV));
                    } else if ("date".equalsIgnoreCase(dateType)) {
                        newV = new SimpleDateFormat("yyyy-MM-dd").parse(String.valueOf(beforeV));
                    }
                    if (!data.containsKey(key)) continue;
                    data.put(String.valueOf(key), newV);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("int".equalsIgnoreCase(type)) {
                newV = null;
                try {
                    newV = Integer.parseInt(String.valueOf(beforeV));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!data.containsKey(key)) continue;
                data.put(String.valueOf(key), newV);
                continue;
            }
            if (!"double".equalsIgnoreCase(type)) continue;
            newV = new Double(0.0);
            try {
                newV = Double.parseDouble(String.valueOf(beforeV));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!data.containsKey(key)) continue;
            data.put(String.valueOf(key), newV);
        }
        return data;
    }

    @Override
    public int updateTable(String tableName, Object id, Map<String, Object> data) {
        this.fillUpdateSysVar(data);
        this.dataAdapter(tableName, data);
        String comma = "";
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("update ").append(tableName).append(" set ");
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (!this.isContainsFieled(tableName, entry.getKey())) continue;
            if (entry.getValue() != null && entry.getValue().toString().length() > 0) {
                sqlBuffer.append(comma).append(entry.getKey()).append("=:" + entry.getKey() + " ");
            } else {
                sqlBuffer.append(comma).append(entry.getKey()).append("=null");
            }
            comma = ", ";
        }
        if (id instanceof String) {
            sqlBuffer.append(" where id='").append(id).append("'");
        } else {
            sqlBuffer.append(" where id=").append(id);
        }
        CgFormHeadEntity cgFormHeadEntity = this.cgFormFieldService.getCgFormHeadByTableName(tableName);
        int num = this.executeSql(sqlBuffer.toString(), data);
        if (cgFormHeadEntity != null) {
            this.executeSqlExtend(cgFormHeadEntity.getId(), "update", data);
        }
        return num;
    }

    @Override
    public Map<String, Object> findOneForJdbc(String tableName, String id) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select * from ").append(tableName);
        sqlBuffer.append(" where id='").append(id).append("'");
        Map<String, Object> map = this.findOneForJdbc(sqlBuffer.toString(), new Object[0]);
        return map;
    }

    @Override
    public void executeSqlExtend(String formId, String buttonCode, Map<String, Object> data) {
        String sqlPlugin;
        CgformButtonSqlEntity cgformButtonSqlVo = this.getCgformButtonSqlByCodeFormId(buttonCode, formId);
        if (cgformButtonSqlVo != null && StringUtils.isNotEmpty((String)(sqlPlugin = cgformButtonSqlVo.getCgbSqlStr()))) {
            String[] sqls;
            String[] stringArray = sqls = sqlPlugin.split(";");
            int n = sqls.length;
            int n2 = 0;
            while (n2 < n) {
                String sql = stringArray[n2];
                if (sql.toLowerCase().indexOf("insert") != -1 || sql.toLowerCase().indexOf("update") != -1) {
                    logger.debug((Object)("sql plugin -------->" + sql));
                    sql = this.formateSQl(sql, data);
                    logger.debug((Object)("sql plugin -------->" + sql));
                    int num = this.executeSql(sql, new Object[0]);
                    if (num > 0) {
                        logger.debug((Object)("sql plugin --execute success------>" + sql));
                    } else {
                        logger.debug((Object)("sql plugin --execute fail------>" + sql));
                    }
                }
                ++n2;
            }
        }
    }

    private CgformButtonSqlEntity getCgformButtonSqlByCodeFormId(String buttonCode, String formId) {
        StringBuilder hql = new StringBuilder("");
        hql.append(" from CgformButtonSqlEntity t");
        hql.append(" where t.formId=?");
        hql.append(" and  t.buttonCode =?");
        List list = this.findHql(hql.toString(), formId, buttonCode);
        if (list != null && list.size() > 0) {
            return (CgformButtonSqlEntity)list.get(0);
        }
        return null;
    }

    private String formateSQl(String sql, Map<String, Object> params) {
        sql = this.replaceExtendSqlSysVar(sql);
        if (params == null) {
            return sql;
        }
        if (sql.toLowerCase().indexOf("insert") != -1) {
            sql = sql.replace("#{UUID}", UUIDGenerator.generate());
        }
        for (String key : params.keySet()) {
            sql = sql.replace("#{" + key + "}", String.valueOf(params.get(key)));
        }
        return sql;
    }

    @Override
    public Map<String, Object> insertTableMore(Map<String, List<Map<String, Object>>> mapMore, String mainTableName) throws BusinessException {
        Map mainMap = mapMore.get(mainTableName).get(0);
        String[] filterName = new String[]{"tableName", "saveOrUpdateMore"};
        mainMap = CommUtils.attributeMapFilter(mainMap, filterName);
        Object pkValue = this.getPkValue(mainTableName);
        mainMap.put("id", pkValue);
        this.insertTable(mainTableName, mainMap);
        String[] filterMainTable = new String[]{mainTableName};
        mapMore = CommUtils.attributeMapFilter(mapMore, filterMainTable);
        for (Map.Entry entry : mapMore.entrySet()) {
            String ok = (String)entry.getKey();
            List ov = (List)entry.getValue();
            for (Map<String, Object> fieldMap : ov) {
                List<Map<String, Object>> fkFieldList = this.getFKField(mainTableName, ok);
                Object subPkValue = this.getPkValue(ok);
                fieldMap.put("id", subPkValue);
                fieldMap = CommUtils.convertFKMap(fieldMap, mainMap, fkFieldList);
                this.insertTable(ok, fieldMap);
            }
        }
        return mainMap;
    }

    @Override
    public boolean updateTableMore(Map<String, List<Map<String, Object>>> mapMore, String mainTableName) throws BusinessException {
        Map mainMap = mapMore.get(mainTableName).get(0);
        Object mainTableId = mainMap.get("id");
        String[] filterName = new String[]{"tableName", "saveOrUpdateMore", "id"};
        mainMap = CommUtils.attributeMapFilter(mainMap, filterName);
        this.updateTable(mainTableName, mainTableId, mainMap);
        mainMap.put("id", mainTableId);
        String[] filterMainTable = new String[]{mainTableName};
        mapMore = CommUtils.attributeMapFilter(mapMore, filterMainTable);
        for (Map.Entry entry : mapMore.entrySet()) {
            Object subId;
            String ok = (String)entry.getKey();
            List ov = (List)entry.getValue();
            List<Map<String, Object>> fkFieldList = this.getFKField(mainTableName, ok);
            Map<Object, Map<String, Object>> subTableDateMap = this.getSubTableData(fkFieldList, mainTableName, ok, mainTableId);
            for (Map fieldMap : ov) {
                Object object = subId = fieldMap.get("id") == null ? "" : fieldMap.get("id");
                if (subId == null || "".equals(String.valueOf(subId))) {
                    fieldMap = CommUtils.convertFKMap(fieldMap, mainMap, fkFieldList);
                    fieldMap.put((String)"id", (Object)this.getPkValue(ok));
                    this.insertTable(ok, fieldMap);
                    continue;
                }
                fieldMap = CommUtils.convertFKMap(fieldMap, mainMap, fkFieldList);
                String[] subFilterName = new String[]{"id"};
                fieldMap = CommUtils.attributeMapFilter(fieldMap, subFilterName);
                this.updateTable(ok, subId, fieldMap);
                if (!subTableDateMap.containsKey(subId)) continue;
                subTableDateMap.remove(subId);
            }
            if (subTableDateMap.size() <= 0) continue;
            for (Map.Entry<Object, Map<String, Object>> entrySub : subTableDateMap.entrySet()) {
                subId = entrySub.getKey();
                this.deleteSubTableDataById(subId, ok);
            }
        }
        return true;
    }

    private List<Map<String, Object>> getFKField(String mainTableName, String subTableName) {
        StringBuilder sql1 = new StringBuilder("");
        sql1.append("select f.* from cgform_field f ,cgform_head h");
        sql1.append(" where f.table_id = h.id ");
        sql1.append(" and h.table_name=? ");
        sql1.append(" and f.main_table=? ");
        List<Map<String, Object>> list = this.findForJdbc(sql1.toString(), subTableName, mainTableName);
        return list;
    }

    private Map<Object, Map<String, Object>> getSubTableData(List<Map<String, Object>> fkFieldList, String mainTableName, String subTableName, Object mainTableId) {
        StringBuilder sql2 = new StringBuilder("");
        sql2.append("select sub.* from ").append(subTableName).append(" sub ");
        sql2.append(", ").append(mainTableName).append(" main ");
        sql2.append("where 1=1 ");
        if (fkFieldList != null && fkFieldList.size() > 0) {
            for (Map<String, Object> map : fkFieldList) {
                if (map.get("main_field") == null) continue;
                sql2.append(" and sub.").append((String)map.get("field_name")).append("=").append("main.").append((String)map.get("main_field"));
            }
        }
        sql2.append(" and main.id= ? ");
        List<Map<String, Object>> subTableDataList = this.findForJdbc(sql2.toString(), mainTableId);
        HashMap<Object, Map<String, Object>> dataMap = new HashMap<Object, Map<String, Object>>();
        if (subTableDataList != null) {
            for (Map<String, Object> map : subTableDataList) {
                dataMap.put(map.get("id"), map);
            }
        }
        return dataMap;
    }

    @Override
    public Object getPkValue(String tableName) {
        Object pkValue = null;
        CgFormHeadEntity cghead = this.cgFormFieldService.getCgFormHeadByTableName(tableName);
        String dbType = DBTypeUtil.getDBType();
        String pkType = cghead.getJformPkType();
        String pkSequence = cghead.getJformPkSequence();
        if (StringUtil.isNotEmpty(pkType) && "UUID".equalsIgnoreCase(pkType)) {
            pkValue = UUIDGenerator.generate();
        } else if (StringUtil.isNotEmpty(pkType) && "NATIVE".equalsIgnoreCase(pkType)) {
            if (StringUtil.isNotEmpty(dbType) && "oracle".equalsIgnoreCase(dbType)) {
                OracleSequenceMaxValueIncrementer incr = new OracleSequenceMaxValueIncrementer((DataSource)this.dataSource, "HIBERNATE_SEQUENCE");
                try {
                    pkValue = incr.nextLongValue();
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            } else if (StringUtil.isNotEmpty(dbType) && "postgres".equalsIgnoreCase(dbType)) {
                PostgreSQLSequenceMaxValueIncrementer incr = new PostgreSQLSequenceMaxValueIncrementer((DataSource)this.dataSource, "HIBERNATE_SEQUENCE");
                try {
                    pkValue = incr.nextLongValue();
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            } else {
                pkValue = null;
            }
        } else if (StringUtil.isNotEmpty(pkType) && "SEQUENCE".equalsIgnoreCase(pkType)) {
            if (StringUtil.isNotEmpty(dbType) && "oracle".equalsIgnoreCase(dbType)) {
                OracleSequenceMaxValueIncrementer incr = new OracleSequenceMaxValueIncrementer((DataSource)this.dataSource, pkSequence);
                try {
                    pkValue = incr.nextLongValue();
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            } else if (StringUtil.isNotEmpty(dbType) && "postgres".equalsIgnoreCase(dbType)) {
                PostgreSQLSequenceMaxValueIncrementer incr = new PostgreSQLSequenceMaxValueIncrementer((DataSource)this.dataSource, pkSequence);
                try {
                    pkValue = incr.nextLongValue();
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            } else {
                pkValue = null;
            }
        } else {
            pkValue = UUIDGenerator.generate();
        }
        return pkValue;
    }

    private void deleteSubTableDataById(Object subId, String subTableName) {
        StringBuilder sql = new StringBuilder("");
        sql.append(" delete from ").append(subTableName).append(" where id = ? ");
        this.executeSql(sql.toString(), subId);
    }

    private void fillUpdateSysVar(Map<String, Object> data) {
        if (data.containsKey("update_date")) {
            data.put("update_date", SysVar.sysdate.getSysValue());
        }
        if (data.containsKey("update_datetime")) {
            data.put("update_datetime", SysVar.systime.getSysValue());
        }
        if (data.containsKey("update_by")) {
            data.put("update_by", SysVar.userid.getSysValue());
        }
        if (data.containsKey("update_key")) {
            data.put("update_key", SysVar.userkey.getSysValue());
        }
        if (data.containsKey("update_name")) {
            data.put("update_name", SysVar.username.getSysValue());
        }
        if (data.containsKey("update_realname")) {
            data.put("update_realname", SysVar.userrealname.getSysValue());
        }
        if (data.containsKey("update_depid")) {
            data.put("update_depid", SysVar.department_id.getSysValue());
        }
        if (data.containsKey("update_depid")) {
            data.put("update_depname", SysVar.department_name.getSysValue());
        }
    }

    private void fillInsertSysVar(Map<String, Object> data) {
        if (data.containsKey("create_date")) {
            data.put("create_date", SysVar.sysdate.getSysValue());
        }
        if (data.containsKey("create_datetime")) {
            data.put("create_datetime", SysVar.systime.getSysValue());
        }
        if (data.containsKey("create_by")) {
            data.put("create_by", SysVar.userid.getSysValue());
        }
        if (data.containsKey("create_key")) {
            data.put("create_key", SysVar.userkey.getSysValue());
        }
        if (data.containsKey("create_name")) {
            data.put("create_name", SysVar.username.getSysValue());
        }
        if (data.containsKey("create_realname")) {
            data.put("create_realname", SysVar.userrealname.getSysValue());
        }
        if (data.containsKey("create_depid")) {
            data.put("create_depid", SysVar.department_id.getSysValue());
        }
        if (data.containsKey("create_depid")) {
            data.put("create_depname", SysVar.department_name.getSysValue());
        }
    }

    private String replaceExtendSqlSysVar(String sql) {
        sql = sql.replace("#{sys.userid}", SysVar.userid.getSysValue()).replace("#{sys.userkey}", SysVar.userkey.getSysValue()).replace("#{sys.username}", SysVar.username.getSysValue()).replace("#{sys.user_realname}", SysVar.userrealname.getSysValue()).replace("#{sys.depid}", SysVar.department_id.getSysValue()).replace("#{sys.depname}", SysVar.department_name.getSysValue()).replace("#{sys.sysdate}", SysVar.sysdate.getSysValue()).replace("#{sys.sysdtime}", SysVar.systime.getSysValue());
        return sql;
    }

    private Map<String, CgFormFieldEntity> getAllFieldByTableName(String tableName) {
        String version = this.cgFormFieldService.getCgFormVersionByTableName(tableName);
        Map<String, CgFormFieldEntity> map = this.cgFormFieldService.getAllCgFormFieldByTableName(tableName, version);
        return map;
    }

    private boolean isContainsFieled(String tableName, String fieledName) {
        boolean flag = false;
        if (this.getAllFieldByTableName(tableName).containsKey(fieledName)) {
            flag = true;
        }
        return flag;
    }
}

