/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.service.impl.autolist;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.service.CommonService;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.web.cgform.common.CommUtils;
import org.jeecgframework.web.cgform.entity.config.CgFormFieldEntity;
import org.jeecgframework.web.cgform.entity.config.CgFormHeadEntity;
import org.jeecgframework.web.cgform.service.autolist.CgTableServiceI;
import org.jeecgframework.web.cgform.service.build.DataBaseService;
import org.jeecgframework.web.cgform.service.config.CgFormFieldServiceI;
import org.jeecgframework.web.cgform.util.QueryParamUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="cgTableService")
@Transactional
public class CgTableServiceImpl
extends CommonServiceImpl
implements CgTableServiceI {
    @Autowired
    private CommonService commonService;
    @Autowired
    private DataBaseService dataBaseService;
    @Autowired
    private CgFormFieldServiceI cgFormFieldService;

    @Override
    public List<Map<String, Object>> querySingle(String table, String field, Map params, int page, int rows) {
        StringBuilder sqlB = new StringBuilder();
        this.dealQuerySql(table, field, params, sqlB);
        List<Map<String, Object>> result = this.commonService.findForJdbcParam(sqlB.toString(), page, rows, new Object[0]);
        return result;
    }

    @Override
    public List<Map<String, Object>> querySingle(String table, String field, Map params, String sort, String order, int page, int rows) {
        StringBuilder sqlB = new StringBuilder();
        this.dealQuerySql(table, field, params, sqlB);
        if (!StringUtil.isEmpty(sort) && !StringUtil.isEmpty(order)) {
            sqlB.append(" ORDER BY " + sort + " " + order);
        }
        List<Map<String, Object>> result = this.commonService.findForJdbcParam(sqlB.toString(), page, rows, new Object[0]);
        return result;
    }

    @Override
    public boolean delete(String table, Object id) {
        try {
            String[] subTables;
            CgFormHeadEntity head = this.cgFormFieldService.getCgFormHeadByTableName(table);
            Map<String, Object> data = this.dataBaseService.findOneForJdbc(table, id.toString());
            if (data != null) {
                for (Map.Entry<String, Object> entry : data.entrySet()) {
                    String ok = entry.getKey();
                    Object ov = entry.getValue() == null ? "" : entry.getValue();
                    LogUtil.info("name:" + ok.toString() + ";value:" + ov.toString());
                }
                data = CommUtils.mapConvert(data);
                this.dataBaseService.executeSqlExtend(head.getId(), "delete", data);
            }
            StringBuilder deleteSql = new StringBuilder();
            deleteSql.append("DELETE FROM " + table + " WHERE id = ?");
            if (!QueryParamUtil.sql_inj(id.toString())) {
                this.commonService.executeSql(deleteSql.toString(), id);
            }
            String[] stringArray = subTables = head.getSubTableStr() == null ? new String[]{} : head.getSubTableStr().split(",");
            int n = subTables.length;
            int n2 = 0;
            while (n2 < n) {
                String subTable = stringArray[n2];
                Map<String, CgFormFieldEntity> fields = this.cgFormFieldService.getAllCgFormFieldByTableName(subTable);
                String subFkField = null;
                for (String fieldName : fields.keySet()) {
                    CgFormFieldEntity fieldc = fields.get(fieldName);
                    if (!StringUtil.isNotEmpty(fieldc.getMainTable()) || !table.equalsIgnoreCase(fieldc.getMainTable())) continue;
                    subFkField = fieldName;
                }
                if (StringUtil.isNotEmpty(subFkField)) {
                    String dsql = "delete from " + subTable + " " + "where " + subFkField + " = ? ";
                    this.executeSql(dsql, id);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void dealQuerySql(String table, String field, Map params, StringBuilder sqlB) {
        sqlB.append(" SELECT ");
        String[] stringArray = field.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            sqlB.append(f);
            sqlB.append(",");
            ++n2;
        }
        sqlB.deleteCharAt(sqlB.length() - 1);
        sqlB.append(" FROM " + table);
        if (params.size() >= 1) {
            sqlB.append(" WHERE 1=1 ");
            Iterator it = params.keySet().iterator();
            while (it.hasNext()) {
                String key = String.valueOf(it.next());
                String value = String.valueOf(params.get(key));
                if (StringUtil.isEmpty(value) || "null".equals(value)) continue;
                sqlB.append(" AND ");
                sqlB.append(" " + key + value);
            }
        }
    }

    @Override
    public Long getQuerySingleSize(String table, String field, Map params) {
        StringBuilder sqlB = new StringBuilder();
        this.dealQuerySql(table, "count(*) as query_size,", params, sqlB);
        List<Map<String, Object>> result = this.commonService.findForJdbc(sqlB.toString(), new Object[0]);
        if (result.size() >= 1) {
            return Long.parseLong(String.valueOf(result.get(0).get("query_size")));
        }
        return 0L;
    }

    @Override
    public boolean deleteBatch(String table, String[] ids) {
        try {
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                this.delete(table, id);
                ++n2;
            }
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        return true;
    }
}

