/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.service.excel;

import java.io.InputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.web.cgform.entity.config.CgFormFieldEntity;

public class ExcelTempletService {
    private static int maxColumnWidth = 30;
    private static int minColumnWidth = 12;
    private static int defaultBlankRow = 1;
    public static final DateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public static HSSFWorkbook exportExcel(String title, Collection<?> dataSet) {
        return ExcelTempletService.exportExcelInUserModel2File(title, dataSet);
    }

    private static HSSFWorkbook exportExcelInUserModel2File(String title, Collection<?> dataSet) {
        HSSFWorkbook workbook = null;
        try {
            if (dataSet == null || dataSet.size() == 0) {
                throw new Exception("\u5bfc\u51fa\u6570\u636e\u4e3a\u7a7a\uff01");
            }
            if (title == null) {
                throw new Exception("\u4f20\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.createSheet(title);
            int index = 0;
            Row row = sheet.createRow(index);
            row.setHeight((short)450);
            HSSFCellStyle titleStyle = ExcelTempletService.getTitleStyle(workbook);
            for (CgFormFieldEntity type : dataSet) {
                if (type.getIsShow().equals("Y")) {
                    Cell cell = row.createCell(index);
                    HSSFRichTextString text = new HSSFRichTextString(type.getContent());
                    cell.setCellValue((RichTextString)text);
                    int columnWidth = type.getLength() == 0 ? minColumnWidth : (type.getLength() > maxColumnWidth ? maxColumnWidth : type.getLength());
                    sheet.setColumnWidth(index, 256 * columnWidth);
                    cell.setCellStyle((CellStyle)titleStyle);
                    ++index;
                }
                ExcelTempletService.setBlankRows(defaultBlankRow, index, workbook);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workbook;
    }

    public static HSSFCellStyle getTitleStyle(HSSFWorkbook workbook) {
        HSSFCellStyle titleStyle = workbook.createCellStyle();
        titleStyle.setBorderBottom((short)6);
        titleStyle.setBorderLeft((short)2);
        titleStyle.setBorderRight((short)2);
        titleStyle.setBorderTop((short)2);
        titleStyle.setBorderBottom((short)2);
        titleStyle.setBorderTop((short)6);
        titleStyle.setFillForegroundColor((short)40);
        titleStyle.setAlignment((short)2);
        titleStyle.setFillPattern((short)1);
        return titleStyle;
    }

    public static void setBlankRows(int rows, int columns, HSSFWorkbook workbook) {
        HSSFSheet sheet = workbook.getSheetAt(0);
        HSSFCellStyle cellStyle = ExcelTempletService.getOneStyle(workbook);
        int i = 1;
        while (i <= rows) {
            Row row = sheet.createRow(i);
            int j = 0;
            while (j < columns) {
                row.createCell(j).setCellStyle((CellStyle)cellStyle);
                ++j;
            }
            ++i;
        }
    }

    public static HSSFCellStyle getTwoStyle(HSSFWorkbook workbook) {
        HSSFCellStyle style = workbook.createCellStyle();
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderBottom((short)1);
        style.setBorderTop((short)1);
        style.setFillForegroundColor((short)41);
        style.setFillPattern((short)1);
        return style;
    }

    public static HSSFCellStyle getOneStyle(HSSFWorkbook workbook) {
        HSSFCellStyle style = workbook.createCellStyle();
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderBottom((short)1);
        style.setBorderTop((short)1);
        return style;
    }

    public static Collection importExcelByIs(InputStream inputstream, List<CgFormFieldEntity> lists) {
        Map<String, CgFormFieldEntity> fieldMap = ExcelTempletService.ConvertDate(lists);
        ArrayList tObject = new ArrayList();
        try {
            HSSFWorkbook book = new HSSFWorkbook(inputstream);
            HSSFSheet sheet = book.getSheetAt(0);
            Iterator row = sheet.rowIterator();
            Row title = (Row)row.next();
            Iterator cellTitle = title.cellIterator();
            HashMap<Integer, String> titlemap = new HashMap<Integer, String>();
            int i = 0;
            while (cellTitle.hasNext()) {
                Cell cell = (Cell)cellTitle.next();
                String value = cell.getStringCellValue();
                if (fieldMap.get(value) == null) {
                    throw new BusinessException("\u5bfc\u5165\u6570\u636eexcel\u5217\u540d\u6709\u4e0d\u80fd\u8bc6\u522b\u7684\u5217");
                }
                titlemap.put(i, value);
                ++i;
            }
            HashMap<String, String> retMap = null;
            while (row.hasNext()) {
                retMap = new HashMap<String, String>();
                Row rown = (Row)row.next();
                Iterator cellbody = rown.cellIterator();
                int k = 0;
                while (cellbody.hasNext()) {
                    Cell cell = (Cell)cellbody.next();
                    String titleString = (String)titlemap.get(k);
                    if (fieldMap.containsKey(titleString)) {
                        retMap.put(fieldMap.get(titleString).getFieldName(), ExcelTempletService.getCellValueString(cell));
                    }
                    ++k;
                }
                tObject.add(retMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return tObject;
    }

    public static String getCellValueString(Cell cell) {
        if (cell == null) {
            return null;
        }
        short dataFormat = cell.getCellStyle().getDataFormat();
        if (dataFormat == 14 || dataFormat == 178 || dataFormat == 180 || dataFormat == 181 || dataFormat == 182) {
            return ExcelTempletService.getDateValue(cell);
        }
        String value = null;
        switch (cell.getCellType()) {
            case 0: {
                value = new DecimalFormat("0.##########").format(cell.getNumericCellValue());
                break;
            }
            case 1: {
                value = cell.getRichStringCellValue().toString();
                break;
            }
            case 2: {
                value = String.valueOf(cell.getCellFormula());
                break;
            }
            case 3: {
                value = String.valueOf(cell.getRichStringCellValue().toString());
                break;
            }
            case 4: {
                value = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 5: {
                value = String.valueOf(cell.getErrorCellValue());
            }
        }
        return value;
    }

    private static String getDateValue(Cell cell) {
        return DEFAULT_DATE_FORMAT.format(cell.getDateCellValue());
    }

    private static Map<String, CgFormFieldEntity> ConvertDate(List<CgFormFieldEntity> lists) {
        HashMap<String, CgFormFieldEntity> maps = new HashMap<String, CgFormFieldEntity>();
        for (CgFormFieldEntity cgFormFieldEntity : lists) {
            maps.put(cgFormFieldEntity.getContent(), cgFormFieldEntity);
        }
        return maps;
    }
}

