/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.engine;

import freemarker.cache.TemplateLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.web.cgform.common.FormHtmlUtil;
import org.jeecgframework.web.cgform.entity.config.CgFormFieldEntity;
import org.jeecgframework.web.cgform.entity.config.CgFormHeadEntity;
import org.jeecgframework.web.cgform.service.cgformftl.CgformFtlServiceI;
import org.jeecgframework.web.cgform.service.config.CgFormFieldServiceI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component(value="templetLoader")
public class DBTempletLoader
implements TemplateLoader {
    public static final String TEMPLET = "org/jeecgframework/web/cgform/engine/jform.ftl";
    public static final String TEMPLET_ONE_MANY = "org/jeecgframework/web/cgform/engine/jformunion.ftl";
    private static final String regEx_attr = "\\#\\{([a-zA-Z_0-9]+)\\}";
    @Autowired
    private CgformFtlServiceI cgformFtlService;
    @Autowired
    private CgFormFieldServiceI cgFormFieldService;

    public Object findTemplateSource(String name) throws IOException {
        name = name.replace("_zh_cn", "").replace("_ZH_CN", "").replace("_zh_CN", "");
        name = name.replace("_en_us", "").replace("_EN_US", "").replace("_en_US", "");
        LogUtil.info("table name----------->" + name);
        Object obj = this.getObject(name);
        return obj;
    }

    public long getLastModified(Object templateSource) {
        return 0L;
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        Reader br = new StringReader("");
        if (templateSource instanceof InputStreamReader) {
            br = new BufferedReader((InputStreamReader)templateSource);
        } else {
            StringBuilder str = (StringBuilder)templateSource;
            br = new StringReader(str.toString());
        }
        return br;
    }

    private Object getObject(String name) throws IOException {
        PathMatchingResourcePatternResolver patternResolver = new PathMatchingResourcePatternResolver();
        if (name.lastIndexOf(".ftl") == -1) {
            CgFormHeadEntity head = this.cgFormFieldService.getCgFormHeadByTableName(name);
            if (head == null) {
                return null;
            }
            if (head.getJformType() == 2) {
                Resource[] resources = patternResolver.getResources(TEMPLET_ONE_MANY);
                InputStreamReader inputStreamReader = null;
                if (resources != null && resources.length > 0) {
                    inputStreamReader = new InputStreamReader(resources[0].getInputStream(), "UTF-8");
                }
                return inputStreamReader;
            }
            Map<String, Object> cgformFtlEntity = this.cgformFtlService.getCgformFtlByTableName(name);
            if (cgformFtlEntity != null) {
                String content = cgformFtlEntity.get("ftl_content") == null ? "" : cgformFtlEntity.get("ftl_content");
                content = this.initFormHtml(content, name);
                LogUtil.info(content);
                return new StringBuilder(content);
            }
            Resource[] resources = patternResolver.getResources(TEMPLET);
            InputStreamReader inputStreamReader = null;
            if (resources != null && resources.length > 0) {
                inputStreamReader = new InputStreamReader(resources[0].getInputStream(), "UTF-8");
            }
            return inputStreamReader;
        }
        Resource[] resources = patternResolver.getResources(name);
        InputStreamReader inputStreamReader = null;
        if (resources != null && resources.length > 0) {
            inputStreamReader = new InputStreamReader(resources[0].getInputStream(), "UTF-8");
        }
        return inputStreamReader;
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
    }

    private String initFormHtml(String htmlStr, String tableName) {
        try {
            Map<String, CgFormFieldEntity> fieldMap = this.cgFormFieldService.getAllCgFormFieldByTableName(tableName);
            List<CgFormFieldEntity> hiddenFielList = this.cgFormFieldService.getHiddenCgFormFieldByTableName(tableName);
            Pattern pattern = Pattern.compile(regEx_attr, 2);
            Matcher matcher = pattern.matcher(htmlStr);
            StringBuffer sb = new StringBuffer();
            String thStr = "";
            String inputStr = "";
            boolean result = matcher.find();
            while (result) {
                CgFormFieldEntity cgFormFieldEntity;
                thStr = matcher.group(1);
                inputStr = "";
                if ("jform_hidden_field".equals(thStr)) {
                    inputStr = this.getHiddenForm(hiddenFielList);
                } else if (fieldMap.get(thStr) != null && "Y".equals((cgFormFieldEntity = fieldMap.get(thStr)).getIsShow())) {
                    inputStr = FormHtmlUtil.getFormHTML(cgFormFieldEntity);
                    inputStr = String.valueOf(inputStr) + "<span class=\"Validform_checktip\">&nbsp;</span>";
                }
                matcher.appendReplacement(sb, inputStr);
                result = matcher.find();
            }
            matcher.appendTail(sb);
            htmlStr = sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return htmlStr;
    }

    private String getHiddenForm(List<CgFormFieldEntity> hiddenFielList) {
        StringBuffer html = new StringBuffer("");
        if (hiddenFielList != null && hiddenFielList.size() > 0) {
            for (CgFormFieldEntity cgFormFieldEntity : hiddenFielList) {
                html.append("<input type=\"hidden\" ");
                html.append("id=\"").append(cgFormFieldEntity.getFieldName()).append("\" ");
                html.append("name=\"").append(cgFormFieldEntity.getFieldName()).append("\" ");
                html.append("value=\"\\${").append(cgFormFieldEntity.getFieldName()).append("?if_exists?html}\" ");
                html.append("\\/>\r\n");
            }
        }
        return html.toString();
    }
}

