/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.controller.generate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.codegenerate.database.JeecgReadTable;
import org.jeecgframework.codegenerate.generate.CgformCodeGenerate;
import org.jeecgframework.codegenerate.generate.onetomany.CgformCodeGenerateOneToMany;
import org.jeecgframework.codegenerate.pojo.CreateFileProperty;
import org.jeecgframework.codegenerate.pojo.onetomany.CodeParamEntity;
import org.jeecgframework.codegenerate.pojo.onetomany.SubTableEntity;
import org.jeecgframework.codegenerate.util.CodeResourceUtil;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.web.cgform.entity.button.CgformButtonEntity;
import org.jeecgframework.web.cgform.entity.button.CgformButtonSqlEntity;
import org.jeecgframework.web.cgform.entity.config.CgFormFieldEntity;
import org.jeecgframework.web.cgform.entity.config.CgFormHeadEntity;
import org.jeecgframework.web.cgform.entity.enhance.CgformEnhanceJsEntity;
import org.jeecgframework.web.cgform.entity.generate.GenerateEntity;
import org.jeecgframework.web.cgform.entity.generate.GenerateSubListEntity;
import org.jeecgframework.web.cgform.service.button.CgformButtonServiceI;
import org.jeecgframework.web.cgform.service.button.CgformButtonSqlServiceI;
import org.jeecgframework.web.cgform.service.config.CgFormFieldServiceI;
import org.jeecgframework.web.cgform.service.enhance.CgformEnhanceJsServiceI;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/generateController"})
public class GenerateController
extends BaseController {
    private static final Logger logger = Logger.getLogger(GenerateController.class);
    @Autowired
    private SystemService systemService;
    @Autowired
    private CgFormFieldServiceI cgFormFieldService;
    @Autowired
    private CgformButtonServiceI cgformButtonService;
    @Autowired
    private CgformButtonSqlServiceI cgformButtonSqlService;
    @Autowired
    private CgformEnhanceJsServiceI cgformEnhanceJsService;

    @RequestMapping(params={"gogenerate"})
    public ModelAndView gogenerate(CgFormHeadEntity cgFormHead, HttpServletRequest request) {
        if (!StringUtil.isNotEmpty(cgFormHead.getId())) {
            throw new RuntimeException("\u8868\u5355\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        cgFormHead = (CgFormHeadEntity)this.cgFormFieldService.getEntity(CgFormHeadEntity.class, (Serializable)((Object)cgFormHead.getId()));
        String returnModelAndView = null;
        HashMap<String, String> entityNameMap = new HashMap<String, String>(0);
        if (cgFormHead.getJformType() == 1 || cgFormHead.getJformType() == 3) {
            returnModelAndView = "jeecg/cgform/generate/single";
        } else {
            ArrayList<CgFormHeadEntity> subTableList = new ArrayList<CgFormHeadEntity>();
            if (StringUtil.isNotEmpty(cgFormHead.getSubTableStr())) {
                String[] subTables;
                String[] stringArray = subTables = cgFormHead.getSubTableStr().split(",");
                int n = subTables.length;
                int n2 = 0;
                while (n2 < n) {
                    String subTable = stringArray[n2];
                    CgFormHeadEntity subHead = this.cgFormFieldService.getCgFormHeadByTableName(subTable);
                    subTableList.add(subHead);
                    entityNameMap.put(subHead.getTableName(), JeecgReadTable.formatFieldCapital((String)subHead.getTableName()));
                    ++n2;
                }
            }
            request.setAttribute("subTableList", subTableList);
            returnModelAndView = "jeecg/cgform/generate/one2many";
        }
        String projectPath = CodeResourceUtil.getProject_path();
        try {
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                int i = 0;
                while (i < cookies.length) {
                    String value;
                    if (cookies[i].getName().equals("cookie_projectPath") && (value = cookies[i].getValue()) != null && !"".equals(value)) {
                        projectPath = cookies[i].getValue();
                        projectPath = URLDecoder.decode(projectPath, "UTF-8");
                    }
                    request.setAttribute("projectPath", (Object)projectPath);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String entityName = JeecgReadTable.formatFieldCapital((String)cgFormHead.getTableName());
        entityNameMap.put(cgFormHead.getTableName(), entityName);
        request.setAttribute("cgFormHeadPage", (Object)cgFormHead);
        request.setAttribute("entityNames", entityNameMap);
        return new ModelAndView(returnModelAndView);
    }

    @RequestMapping(params={"dogenerate"})
    public void dogenerate(CgFormHeadEntity cgFormHead, GenerateEntity generateEntity, CreateFileProperty createFileProperty, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!StringUtil.isNotEmpty(cgFormHead.getId())) {
            throw new RuntimeException("\u8868\u5355\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        cgFormHead = (CgFormHeadEntity)this.cgFormFieldService.getEntity(CgFormHeadEntity.class, (Serializable)((Object)cgFormHead.getId()));
        this.getCgformConfig(cgFormHead, generateEntity);
        AjaxJson j = new AjaxJson();
        String tableName = generateEntity.getTableName();
        String ftlDescription = generateEntity.getFtlDescription();
        try {
            boolean tableexist = new JeecgReadTable().checkTableExist(tableName);
            if (tableexist) {
                new CgformCodeGenerate(createFileProperty, generateEntity).generateToFile();
                j.setMsg("\u6210\u529f\u751f\u6210\u589e\u5220\u6539\u67e5->\u529f\u80fd\uff1a" + ftlDescription);
            } else {
                j.setMsg("\u8868[" + tableName + "] \u5728\u6570\u636e\u5e93\u4e2d\uff0c\u4e0d\u5b58\u5728");
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            j.setMsg(e1.getMessage());
            throw new RuntimeException(e1.getMessage());
        }
        try {
            String projectPath = URLEncoder.encode(generateEntity.getProjectPath(), "UTF-8");
            Cookie cookie = new Cookie("cookie_projectPath", projectPath);
            cookie.setMaxAge(2592000);
            response.addCookie(cookie);
            response.getWriter().print(j.getJsonStr());
            response.getWriter().flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"dogenerateOne2Many"})
    @ResponseBody
    public void dogenerateOne2Many(CodeParamEntity codeParamEntityIn, GenerateSubListEntity subTableListEntity, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        try {
            String mainTable = codeParamEntityIn.getTableName();
            GenerateEntity mainG = new GenerateEntity();
            mainG.setProjectPath(subTableListEntity.getProjectPath());
            mainG.setPackageStyle(subTableListEntity.getPackageStyle());
            CgFormHeadEntity mCgFormHead = this.cgFormFieldService.getCgFormHeadByTableName(mainTable);
            this.getCgformConfig(mCgFormHead, mainG);
            HashMap<String, GenerateEntity> subsG = new HashMap<String, GenerateEntity>();
            List<SubTableEntity> subTabParamIn = subTableListEntity.getSubTabParamIn();
            for (SubTableEntity po : subTabParamIn) {
                String sTableName = po.getTableName();
                CgFormHeadEntity cgSubHead = this.cgFormFieldService.getCgFormHeadByTableName(sTableName);
                List<CgFormFieldEntity> colums = cgSubHead.getColumns();
                String[] foreignKeys = this.getForeignkeys(colums);
                po.setForeignKeys(foreignKeys);
                GenerateEntity subG = new GenerateEntity();
                this.getCgformConfig(cgSubHead, subG);
                subG.setEntityName(po.getEntityName());
                subG.setEntityPackage(po.getEntityPackage());
                subG.setFieldRowNum(1);
                subG.setFtlDescription(po.getFtlDescription());
                subG.setForeignKeys(foreignKeys);
                subG.setTableName(po.getTableName());
                subG.setProjectPath(subTableListEntity.getProjectPath());
                subG.setPackageStyle(subTableListEntity.getPackageStyle());
                subsG.put(sTableName, subG);
            }
            codeParamEntityIn.setSubTabParam(subTabParamIn);
            CgformCodeGenerateOneToMany.oneToManyCreate(subTabParamIn, (CodeParamEntity)codeParamEntityIn, (GenerateEntity)mainG, subsG);
            j.setMsg("\u6210\u529f\u751f\u6210\u589e\u5220\u6539\u67e5->\u529f\u80fd\uff1a" + codeParamEntityIn.getFtlDescription());
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setMsg(e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        try {
            String projectPath = URLEncoder.encode(subTableListEntity.getProjectPath(), "UTF-8");
            Cookie cookie = new Cookie("cookie_projectPath", projectPath);
            cookie.setMaxAge(2592000);
            response.addCookie(cookie);
            response.getWriter().print(j.getJsonStr());
            response.getWriter().flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String[] getForeignkeys(List<CgFormFieldEntity> colums) {
        ArrayList<String> fs = new ArrayList<String>(0);
        for (CgFormFieldEntity c : colums) {
            if (!StringUtil.isNotEmpty(c.getMainTable()) || !StringUtil.isNotEmpty(c.getMainField())) continue;
            fs.add(c.getFieldName().toUpperCase());
        }
        String[] foreignkeys = fs.toArray(new String[fs.size()]);
        return foreignkeys;
    }

    private void getCgformConfig(CgFormHeadEntity cgFormHead, GenerateEntity generateEntity) throws Exception {
        int filedNums = cgFormHead.getColumns().size();
        List<CgformButtonEntity> buttons = null;
        LinkedHashMap<String, String[]> buttonSqlMap = new LinkedHashMap<String, String[]>();
        cgFormHead = (CgFormHeadEntity)this.cgFormFieldService.getEntity(CgFormHeadEntity.class, (Serializable)((Object)cgFormHead.getId()));
        buttons = this.cgformButtonService.getCgformButtonListByFormId(cgFormHead.getId());
        for (CgformButtonEntity cb : buttons) {
            CgformButtonSqlEntity cbs = this.cgformButtonSqlService.getCgformButtonSqlByCodeFormId(cb.getButtonCode(), cgFormHead.getId());
            buttonSqlMap.put(cb.getButtonCode(), cbs == null ? new String[]{} : cbs.getCgbSqlStr().replaceAll("(\r\n|\r|\n|\n\r)", "").split(";"));
        }
        CgformButtonSqlEntity cbsAdd = this.cgformButtonSqlService.getCgformButtonSqlByCodeFormId("add", cgFormHead.getId());
        buttonSqlMap.put("add", cbsAdd == null ? new String[]{} : cbsAdd.getCgbSqlStr().replaceAll("(\r\n|\r|\n|\n\r)", "").split(";"));
        CgformButtonSqlEntity cbsUpdate = this.cgformButtonSqlService.getCgformButtonSqlByCodeFormId("update", cgFormHead.getId());
        buttonSqlMap.put("update", cbsUpdate == null ? new String[]{} : cbsUpdate.getCgbSqlStr().replaceAll("(\r\n|\r|\n|\n\r)", "").split(";"));
        CgformButtonSqlEntity cbsDelete = this.cgformButtonSqlService.getCgformButtonSqlByCodeFormId("delete", cgFormHead.getId());
        buttonSqlMap.put("delete", cbsDelete == null ? new String[]{} : cbsDelete.getCgbSqlStr().replaceAll("(\r\n|\r|\n|\n\r)", "").split(";"));
        CgformEnhanceJsEntity listJs = this.cgformEnhanceJsService.getCgformEnhanceJsByTypeFormId("list", cgFormHead.getId());
        CgformEnhanceJsEntity listJsCopy = null;
        try {
            listJsCopy = listJs.deepCopy();
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage());
        }
        CgformEnhanceJsEntity formJs = this.cgformEnhanceJsService.getCgformEnhanceJsByTypeFormId("form", cgFormHead.getId());
        CgformEnhanceJsEntity formJsCopy = null;
        try {
            formJsCopy = formJs.deepCopy();
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage());
        }
        for (CgFormFieldEntity field : cgFormHead.getColumns()) {
            String fieldName = field.getFieldName();
            if (listJsCopy != null) {
                listJsCopy.setCgJsStr(listJsCopy.getCgJsStr().replace(fieldName, JeecgReadTable.formatField((String)fieldName)));
            }
            if (formJsCopy == null) continue;
            formJsCopy.setCgJsStr(formJsCopy.getCgJsStr().replace(fieldName, JeecgReadTable.formatField((String)fieldName)));
        }
        generateEntity.setButtons(buttons);
        generateEntity.setButtonSqlMap(buttonSqlMap);
        generateEntity.setCgFormHead(cgFormHead);
        generateEntity.setListJs(listJsCopy);
        generateEntity.setFormJs(formJsCopy);
    }

    @RequestMapping(params={"goFileTree"})
    public ModelAndView goFileTree(HttpServletRequest request) {
        return new ModelAndView("jeecg/cgform/generate/fileTree");
    }

    @RequestMapping(params={"doExpandFileTree"})
    @ResponseBody
    public Object doExpandFileTree(String parentNode) {
        JSONArray fjson;
        block12: {
            fjson = new JSONArray();
            try {
                File[] chs;
                if (StringUtil.isEmpty(parentNode)) {
                    File[] roots;
                    File[] fileArray = roots = File.listRoots();
                    int n = roots.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File r = fileArray[n2];
                        JSONObject item = new JSONObject();
                        item.put("id", (Object)r.getAbsolutePath());
                        item.put("text", (Object)r.getPath());
                        item.put("iconCls", (Object)"icon-folder");
                        if (this.hasDirs(r)) {
                            item.put("state", (Object)"closed");
                        } else {
                            item.put("state", (Object)"open");
                        }
                        fjson.add((Object)item);
                        ++n2;
                    }
                    break block12;
                }
                try {
                    parentNode = new String(parentNode.getBytes("ISO-8859-1"), "UTF-8");
                }
                catch (UnsupportedEncodingException e1) {
                    e1.printStackTrace();
                }
                File parent = new File(parentNode);
                File[] fileArray = chs = parent.listFiles();
                int n = chs.length;
                int n3 = 0;
                while (n3 < n) {
                    File r = fileArray[n3];
                    JSONObject item = new JSONObject();
                    if (r.isDirectory()) {
                        item.put("id", (Object)r.getAbsolutePath());
                        item.put("text", (Object)r.getPath());
                        if (this.hasDirs(r)) {
                            item.put("state", (Object)"closed");
                        } else {
                            item.put("state", (Object)"open");
                        }
                        fjson.add((Object)item);
                    }
                    ++n3;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("\u8be5\u6587\u4ef6\u5939\u4e0d\u53ef\u9009\u62e9");
            }
        }
        return fjson;
    }

    private boolean hasDirs(File dir) {
        try {
            return dir.listFiles().length != 0;
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
            return false;
        }
    }
}

