/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.controller.excel;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.UUIDGenerator;
import org.jeecgframework.web.cgform.service.autolist.ConfigServiceI;
import org.jeecgframework.web.cgform.service.build.DataBaseService;
import org.jeecgframework.web.cgform.service.config.CgFormFieldServiceI;
import org.jeecgframework.web.cgform.service.excel.ExcelTempletService;
import org.jeecgframework.web.cgform.service.impl.config.util.FieldNumComparator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/excelTempletController"})
public class ExcelTempletController
extends BaseController {
    private static final Logger logger = Logger.getLogger(ExcelTempletController.class);
    private String message;
    @Autowired
    private ConfigServiceI configService;
    @Autowired
    private CgFormFieldServiceI cgFormFieldService;
    @Autowired
    private DataBaseService dataBaseService;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(HttpServletRequest request, HttpServletResponse response) {
        String codedFileName = "\u6a21\u7248\u6587\u4ef6";
        String sheetName = "\u5bfc\u51fa\u4fe1\u606f";
        List lists = null;
        if (StringUtil.isNotEmpty(request.getParameter("tableName"))) {
            String configId = request.getParameter("tableName");
            String jversion = this.cgFormFieldService.getCgFormVersionByTableName(configId);
            Map<String, Object> configs = this.configService.queryConfigs(configId, jversion);
            lists = (List)configs.get("fileds");
            Collections.sort(lists, new FieldNumComparator());
            sheetName = (String)configs.get("config_name");
            String tableName = (String)configs.get("tableName");
            codedFileName = String.valueOf(sheetName) + "_" + tableName + "-v" + (String)configs.get("jformVersion");
            response.setContentType("application/vnd.ms-excel");
            OutputStream fOut = null;
            try {
                try {
                    String browse = BrowserUtils.checkBrowse(request);
                    if ("MSIE".equalsIgnoreCase(browse.substring(0, 4))) {
                        response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                    } else {
                        String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                        response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                    }
                    HSSFWorkbook workbook = null;
                    workbook = ExcelTempletService.exportExcel(sheetName, lists);
                    fOut = response.getOutputStream();
                    workbook.write(fOut);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    try {
                        fOut.flush();
                        fOut.close();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (Exception exception) {
                    try {
                        fOut.flush();
                        fOut.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
    }

    @RequestMapping(params={"goImplXls"}, method={RequestMethod.GET})
    public ModelAndView goImplXls(HttpServletRequest request) {
        request.setAttribute("tableName", (Object)request.getParameter("tableName"));
        return new ModelAndView("jeecg/cgform/excel/upload");
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        String message = "\u4e0a\u4f20\u6210\u529f";
        AjaxJson j = new AjaxJson();
        String configId = request.getParameter("tableName");
        String jversion = this.cgFormFieldService.getCgFormVersionByTableName(configId);
        Map<String, Object> configs = this.configService.queryConfigs(configId, jversion);
        String version = (String)configs.get("jformVersion");
        List lists = (List)configs.get("fileds");
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            String docVersion = ExcelTempletController.getDocVersion(file.getOriginalFilename());
            if (docVersion.equals(version)) {
                try {
                    List listDate = (List)ExcelTempletService.importExcelByIs(file.getInputStream(), lists);
                    if (listDate == null) {
                        message = "\u8bc6\u522b\u6a21\u7248\u6570\u636e\u9519\u8bef";
                        logger.error((Object)message);
                        continue;
                    }
                    for (Map map : listDate) {
                        map.put("id", UUIDGenerator.generate());
                        int n = this.dataBaseService.insertTable(configId, map);
                    }
                    message = "\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01";
                }
                catch (IOException e) {
                    message = "\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01";
                    logger.error((Object)ExceptionUtil.getExceptionMessage(e));
                }
                continue;
            }
            message = "\u6a21\u7248\u6587\u4ef6\u7248\u672c\u548c\u8868\u8fbe\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6a21\u7248";
            logger.error((Object)message);
        }
        j.setMsg(message);
        return j;
    }

    private static String getDocVersion(String docName) {
        if (docName.indexOf("(") > 0) {
            return docName.substring(docName.indexOf("-v") + 2, docName.indexOf("("));
        }
        return docName.substring(docName.indexOf("-v") + 2, docName.indexOf("."));
    }
}

