/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.controller.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.cgform.entity.config.CgFormFieldEntity;
import org.jeecgframework.web.cgform.entity.config.CgFormHeadEntity;
import org.jeecgframework.web.cgform.exception.BusinessException;
import org.jeecgframework.web.cgform.service.config.CgFormFieldServiceI;
import org.jeecgframework.web.cgform.service.impl.config.util.FieldNumComparator;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/cgFormHeadController"})
public class CgFormHeadController
extends BaseController {
    private static final Logger logger = Logger.getLogger(CgFormHeadController.class);
    @Autowired
    private CgFormFieldServiceI cgFormFieldService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"cgFormHeadList"})
    public ModelAndView cgFormHead(HttpServletRequest request) {
        return new ModelAndView("jeecg/cgform/config/cgFormHeadList");
    }

    @RequestMapping(params={"goCgFormSynChoice"})
    public ModelAndView goCgFormSynChoice(HttpServletRequest request) {
        return new ModelAndView("jeecg/cgform/config/cgformSynChoice");
    }

    @RequestMapping(params={"popmenulink"})
    public ModelAndView popmenulink(ModelMap modelMap, @RequestParam String url, @RequestParam String title, HttpServletRequest request) {
        modelMap.put((Object)"title", (Object)title);
        modelMap.put((Object)"url", (Object)url);
        return new ModelAndView("jeecg/cgform/config/popmenulink");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(CgFormHeadEntity cgFormHead, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(CgFormHeadEntity.class, dataGrid);
        HqlGenerateUtil.installHql(cq, cgFormHead);
        this.cgFormFieldService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(CgFormHeadEntity cgFormHead, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        cgFormHead = (CgFormHeadEntity)this.systemService.getEntity(CgFormHeadEntity.class, (Serializable)((Object)cgFormHead.getId()));
        this.message = "\u5220\u9664\u6210\u529f";
        this.cgFormFieldService.deleteCgForm(cgFormHead);
        this.cgFormFieldService.removeSubTableStr4Main(cgFormHead);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"rem"})
    @ResponseBody
    public AjaxJson rem(CgFormHeadEntity cgFormHead, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        cgFormHead = (CgFormHeadEntity)this.systemService.getEntity(CgFormHeadEntity.class, (Serializable)((Object)cgFormHead.getId()));
        this.message = "\u79fb\u9664\u6210\u529f";
        this.cgFormFieldService.delete(cgFormHead);
        this.cgFormFieldService.removeSubTableStr4Main(cgFormHead);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"delField"})
    @ResponseBody
    public AjaxJson delField(CgFormFieldEntity cgFormField, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        cgFormField = (CgFormFieldEntity)this.systemService.getEntity(CgFormFieldEntity.class, (Serializable)((Object)cgFormField.getId()));
        this.message = String.valueOf(cgFormField.getFieldName()) + "\u5220\u9664\u6210\u529f";
        this.cgFormFieldService.delete(cgFormField);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doDbSynch"})
    @ResponseBody
    public AjaxJson doDbSynch(CgFormHeadEntity cgFormHead, String synMethod, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        cgFormHead = (CgFormHeadEntity)this.systemService.getEntity(CgFormHeadEntity.class, (Serializable)((Object)cgFormHead.getId()));
        try {
            boolean bl = this.cgFormFieldService.dbSynch(cgFormHead, synMethod);
            if (!bl) {
                this.message = "\u540c\u6b65\u5931\u8d25";
                j.setMsg(this.message);
                return j;
            }
            this.cgFormFieldService.appendSubTableStr4Main(cgFormHead);
            this.message = "\u540c\u6b65\u6210\u529f";
            j.setMsg(this.message);
        }
        catch (BusinessException e) {
            j.setMsg(e.getMessage());
            return j;
        }
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(CgFormHeadEntity cgFormHead, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        CgFormHeadEntity oldTable = (CgFormHeadEntity)this.cgFormFieldService.getEntity(CgFormHeadEntity.class, (Serializable)((Object)cgFormHead.getId()));
        this.cgFormFieldService.removeSubTableStr4Main(oldTable);
        CgFormHeadEntity table = this.judgeTableIsNotExit(cgFormHead, oldTable);
        this.refreshFormFieldOrderNum(cgFormHead);
        if (StringUtil.isNotEmpty(cgFormHead.getId()) && table != null) {
            List<CgFormFieldEntity> formFieldEntities = table.getColumns();
            for (CgFormFieldEntity cgFormFieldEntity : formFieldEntities) {
                if (!StringUtil.isEmpty(cgFormFieldEntity.getOldFieldName()) || !StringUtil.isNotEmpty(cgFormFieldEntity.getFieldName())) continue;
                cgFormFieldEntity.setFieldName(cgFormFieldEntity.getFieldName().toLowerCase());
                cgFormFieldEntity.setOldFieldName(cgFormFieldEntity.getFieldName());
            }
            this.cgFormFieldService.updateTable(table, null);
            this.cgFormFieldService.appendSubTableStr4Main(table);
            this.cgFormFieldService.sortSubTableStr(table);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        } else if (StringUtil.isEmpty(cgFormHead.getId()) && table == null) {
            List<CgFormFieldEntity> formFieldEntities = cgFormHead.getColumns();
            for (CgFormFieldEntity cgFormFieldEntity : formFieldEntities) {
                if (!StringUtil.isEmpty(cgFormFieldEntity.getOldFieldName())) continue;
                cgFormFieldEntity.setFieldName(cgFormFieldEntity.getFieldName().toLowerCase());
                cgFormFieldEntity.setOldFieldName(cgFormFieldEntity.getFieldName());
            }
            this.cgFormFieldService.saveTable(cgFormHead);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    private void refreshFormFieldOrderNum(CgFormHeadEntity cgFormHead) {
        Collections.sort(cgFormHead.getColumns(), new FieldNumComparator());
        int i = 0;
        while (i < cgFormHead.getColumns().size()) {
            cgFormHead.getColumns().get(i).setOrderNum(i + 1);
            ++i;
        }
    }

    private CgFormHeadEntity judgeTableIsNotExit(CgFormHeadEntity cgFormHead, CgFormHeadEntity oldTable) {
        CgFormHeadEntity table = this.cgFormFieldService.findUniqueByProperty(CgFormHeadEntity.class, "tableName", cgFormHead.getTableName());
        if (StringUtil.isNotEmpty(cgFormHead.getId())) {
            if (table != null && !oldTable.getTableName().equals(cgFormHead.getTableName())) {
                this.message = "\u91cd\u547d\u540d\u7684\u8868\u5df2\u7ecf\u5b58\u5728";
                table = null;
            } else {
                if (table == null) {
                    cgFormHead.setIsDbSynch("N");
                }
                table = table == null ? oldTable : table;
                try {
                    MyBeanUtils.copyBeanNotNull2Bean(cgFormHead, table);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.message = "\u4fee\u6539\u6210\u529f";
            }
        } else {
            this.message = table != null ? "\u8868\u5df2\u7ecf\u5b58\u5728" : "\u521b\u5efa\u6210\u529f";
        }
        return table;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(CgFormHeadEntity cgFormHead, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(cgFormHead.getId())) {
            cgFormHead = (CgFormHeadEntity)this.cgFormFieldService.getEntity(CgFormHeadEntity.class, (Serializable)((Object)cgFormHead.getId()));
            req.setAttribute("cgFormHeadPage", (Object)cgFormHead);
        }
        return new ModelAndView("jeecg/cgform/config/cgFormHead");
    }

    @RequestMapping(params={"getColumnList"})
    @ResponseBody
    public List<CgFormFieldEntity> getColumnList(CgFormHeadEntity cgFormHead, String type, HttpServletRequest req) {
        List<Object> columnList = new ArrayList();
        if (StringUtil.isNotEmpty(cgFormHead.getId())) {
            CriteriaQuery cq = new CriteriaQuery(CgFormFieldEntity.class);
            cq.eq("table.id", cgFormHead.getId());
            cq.add();
            columnList = this.cgFormFieldService.getListByCriteriaQuery(cq, false);
            Collections.sort(columnList, new FieldNumComparator());
        } else {
            columnList = this.getInitDataList();
        }
        return columnList;
    }

    private List<CgFormFieldEntity> getInitDataList() {
        ArrayList<CgFormFieldEntity> columnList = new ArrayList<CgFormFieldEntity>();
        columnList.add(this.initCgFormFieldEntityId());
        columnList.add(this.initCgFormFieldEntityCreateUser());
        columnList.add(this.initCgFormFieldEntityCreateTime());
        columnList.add(this.initCgFormFieldEntityUpdateUser());
        columnList.add(this.initCgFormFieldEntityUpdateTime());
        return columnList;
    }

    private CgFormFieldEntity initCgFormFieldEntityId() {
        CgFormFieldEntity field = new CgFormFieldEntity();
        field.setFieldName("id");
        field.setLength(36);
        field.setContent("\u4e3b\u952e");
        field.setIsKey("Y");
        field.setIsNull("N");
        field.setOrderNum(1);
        field.setType("string");
        field.setPointLength(0);
        field.setIsShow("N");
        field.setIsShowList("N");
        field.setFieldLength(120);
        return field;
    }

    private CgFormFieldEntity initCgFormFieldEntityCreateUser() {
        CgFormFieldEntity field = new CgFormFieldEntity();
        field.setFieldName("create_name");
        field.setLength(50);
        field.setContent("\u521b\u5efa\u4eba\u540d\u79f0");
        field.setIsKey("N");
        field.setIsNull("Y");
        field.setOrderNum(2);
        field.setType("string");
        field.setPointLength(0);
        field.setIsShow("N");
        field.setIsShowList("N");
        field.setFieldLength(120);
        return field;
    }

    private CgFormFieldEntity initCgFormFieldEntityCreateTime() {
        CgFormFieldEntity field = new CgFormFieldEntity();
        field.setFieldName("create_date");
        field.setLength(20);
        field.setContent("\u521b\u5efa\u65e5\u671f");
        field.setIsKey("N");
        field.setIsNull("Y");
        field.setOrderNum(3);
        field.setType("Date");
        field.setPointLength(0);
        field.setIsShow("N");
        field.setIsShowList("N");
        field.setFieldLength(120);
        return field;
    }

    private CgFormFieldEntity initCgFormFieldEntityUpdateUser() {
        CgFormFieldEntity field = new CgFormFieldEntity();
        field.setFieldName("update_name");
        field.setLength(50);
        field.setContent("\u4fee\u6539\u4eba\u540d\u79f0");
        field.setIsKey("N");
        field.setIsNull("Y");
        field.setOrderNum(4);
        field.setType("string");
        field.setPointLength(0);
        field.setIsShow("N");
        field.setIsShowList("N");
        field.setFieldLength(120);
        return field;
    }

    private CgFormFieldEntity initCgFormFieldEntityUpdateTime() {
        CgFormFieldEntity field = new CgFormFieldEntity();
        field.setFieldName("update_date");
        field.setLength(20);
        field.setContent("\u4fee\u6539\u65e5\u671f");
        field.setIsKey("N");
        field.setIsNull("Y");
        field.setOrderNum(5);
        field.setType("Date");
        field.setPointLength(0);
        field.setIsShow("N");
        field.setIsShowList("N");
        field.setFieldLength(120);
        return field;
    }

    @RequestMapping(params={"checkIsExit"})
    @ResponseBody
    public AjaxJson checkIsExit(String name, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        j.setSuccess(this.cgFormFieldService.judgeTableIsExit(name));
        return j;
    }

    @RequestMapping(params={"sqlPlugin"})
    public ModelAndView sqlPlugin(String id, HttpServletRequest request) {
        CgFormHeadEntity bean = (CgFormHeadEntity)this.cgFormFieldService.getEntity(CgFormHeadEntity.class, (Serializable)((Object)id));
        request.setAttribute("bean", (Object)bean);
        return new ModelAndView("jeecg/cgform/config/cgFormSqlPlugin");
    }

    @RequestMapping(params={"sqlPluginSave"})
    @ResponseBody
    public AjaxJson sqlPluginSave(String id, String sql_plug_in, HttpServletRequest request) {
        CgFormHeadEntity bean = (CgFormHeadEntity)this.cgFormFieldService.getEntity(CgFormHeadEntity.class, (Serializable)((Object)id));
        this.cgFormFieldService.updateTable(bean, null);
        this.message = "\u4fdd\u5b58\u6210\u529f";
        this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        AjaxJson j = new AjaxJson();
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"jsPlugin"})
    public ModelAndView jsPlugin(String id, HttpServletRequest request) {
        CgFormHeadEntity bean = (CgFormHeadEntity)this.cgFormFieldService.getEntity(CgFormHeadEntity.class, (Serializable)((Object)id));
        request.setAttribute("bean", (Object)bean);
        return new ModelAndView("jeecg/cgform/config/cgFormJsPlugin");
    }

    @RequestMapping(params={"jsPluginSave"})
    @ResponseBody
    public AjaxJson jsPluginSave(String id, String js_plug_in, HttpServletRequest request) {
        CgFormHeadEntity bean = (CgFormHeadEntity)this.cgFormFieldService.getEntity(CgFormHeadEntity.class, (Serializable)((Object)id));
        this.cgFormFieldService.updateTable(bean, null);
        this.message = "\u4fdd\u5b58\u6210\u529f";
        this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        AjaxJson j = new AjaxJson();
        j.setMsg(this.message);
        return j;
    }
}

