/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.controller.cgformftl;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.DataUtils;
import org.jeecgframework.core.util.FileUtils;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.cgform.common.OfficeHtmlUtil;
import org.jeecgframework.web.cgform.entity.cgformftl.CgformFtlEntity;
import org.jeecgframework.web.cgform.service.cgformftl.CgformFtlServiceI;
import org.jeecgframework.web.cgform.service.config.CgFormFieldServiceI;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/cgformFtlController"})
public class CgformFtlController
extends BaseController {
    private static final Logger logger = Logger.getLogger(CgformFtlController.class);
    @Autowired
    private CgformFtlServiceI cgformFtlService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private CgFormFieldServiceI cgFormFieldService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"formEkeditor"})
    public ModelAndView ckeditor(HttpServletRequest request, String id) {
        CgformFtlEntity t = this.systemService.get(CgformFtlEntity.class, (Serializable)((Object)id));
        request.setAttribute("cgformFtlEntity", (Object)t);
        if (t.getFtlContent() == null) {
            request.setAttribute("contents", (Object)"");
        } else {
            request.setAttribute("contents", (Object)new String(t.getFtlContent()));
        }
        return new ModelAndView("jeecg/cgform/cgformftl/ckeditor");
    }

    @RequestMapping(params={"saveFormEkeditor"})
    @ResponseBody
    public AjaxJson saveCkeditor(HttpServletRequest request, CgformFtlEntity cgformFtlEntity, String contents) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty(cgformFtlEntity.getId())) {
            CgformFtlEntity t = this.systemService.get(CgformFtlEntity.class, (Serializable)((Object)cgformFtlEntity.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean(cgformFtlEntity, t);
                t.setFtlContent(contents);
                this.systemService.saveOrUpdate(t);
                j.setSuccess(true);
                j.setMsg("\u66f4\u65b0\u6210\u529f");
            }
            catch (Exception e) {
                e.printStackTrace();
                j.setSuccess(false);
                j.setMsg("\u66f4\u65b0\u5931\u8d25");
            }
        }
        return j;
    }

    @RequestMapping(params={"cgformFtl"})
    public ModelAndView cgformFtl(HttpServletRequest request) {
        String formid = request.getParameter("formid");
        request.setAttribute("formid", (Object)formid);
        return new ModelAndView("jeecg/cgform/cgformftl/cgformFtlList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(CgformFtlEntity cgformFtl, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(CgformFtlEntity.class, dataGrid);
        HqlGenerateUtil.installHql(cq, cgformFtl, request.getParameterMap());
        this.cgformFtlService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(CgformFtlEntity cgformFtl, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        cgformFtl = (CgformFtlEntity)this.systemService.getEntity(CgformFtlEntity.class, (Serializable)((Object)cgformFtl.getId()));
        this.message = "\u5220\u9664\u6210\u529f";
        this.cgformFtlService.delete(cgformFtl);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"active"})
    @ResponseBody
    public AjaxJson active(CgformFtlEntity cgformFtl, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            cgformFtl = (CgformFtlEntity)this.systemService.getEntity(CgformFtlEntity.class, (Serializable)((Object)cgformFtl.getId()));
            if (!this.cgformFtlService.hasActive(cgformFtl.getCgformId())) {
                cgformFtl.setFtlStatus("1");
                this.cgformFtlService.saveOrUpdate(cgformFtl);
                this.message = "\u6fc0\u6d3b\u6210\u529f";
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
                j.setSuccess(true);
                j.setMsg(this.message);
            } else {
                this.message = "\u5df2\u6709\u6fc0\u6d3b\u6a21\u677f\uff0c\u8bf7\u53d6\u6d88\u540e\u518d\u8fdb\u884c\u6fc0\u6d3b";
                j.setSuccess(true);
                j.setMsg(this.message);
            }
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
            this.message = "\u6fc0\u6d3b\u5931\u8d25";
            j.setSuccess(false);
            j.setMsg(this.message);
        }
        return j;
    }

    @RequestMapping(params={"cancleActive"})
    @ResponseBody
    public AjaxJson cancleActive(CgformFtlEntity cgformFtl, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            cgformFtl = (CgformFtlEntity)this.systemService.getEntity(CgformFtlEntity.class, (Serializable)((Object)cgformFtl.getId()));
            cgformFtl.setFtlStatus("0");
            this.cgformFtlService.saveOrUpdate(cgformFtl);
            this.message = "\u53d6\u6d88\u6fc0\u6d3b\u6210\u529f";
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            j.setSuccess(true);
            j.setMsg(this.message);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
            this.message = "\u53d6\u6d88\u6fc0\u6d3b\u5931\u8d25";
            j.setSuccess(false);
            j.setMsg(this.message);
        }
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(CgformFtlEntity cgformFtl, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty(cgformFtl.getId())) {
            this.message = "\u66f4\u65b0\u6210\u529f";
            CgformFtlEntity t = this.cgformFtlService.get(CgformFtlEntity.class, (Serializable)((Object)cgformFtl.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean(cgformFtl, t);
                this.cgformFtlService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.message = "\u6dfb\u52a0\u6210\u529f";
            this.cgformFtlService.save(cgformFtl);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(CgformFtlEntity cgformFtl, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(cgformFtl.getId())) {
            cgformFtl = (CgformFtlEntity)this.cgformFtlService.getEntity(CgformFtlEntity.class, (Serializable)((Object)cgformFtl.getId()));
        }
        req.setAttribute("cgformFtlPage", (Object)cgformFtl);
        return new ModelAndView("jeecg/cgform/cgformftl/cgformFtl");
    }

    @RequestMapping(params={"saveWordFiles"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveWordFiles(HttpServletRequest request, HttpServletResponse response, CgformFtlEntity cgformFtl) {
        AjaxJson j = new AjaxJson();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        LogUtil.info("-------------------------step.1-------------------------------------");
        String fileKey = oConvertUtils.getString(request.getParameter("id"));
        String cgformId = oConvertUtils.getString(request.getParameter("cgformId"));
        String cgformName = oConvertUtils.getString(request.getParameter("cgformName"));
        String ftlStatus = oConvertUtils.getString(request.getParameter("ftlStatus"));
        if (oConvertUtils.isEmpty(ftlStatus)) {
            ftlStatus = "0";
        }
        if (StringUtil.isNotEmpty(fileKey)) {
            cgformFtl.setId(fileKey);
            cgformFtl = (CgformFtlEntity)this.systemService.getEntity(CgformFtlEntity.class, (Serializable)((Object)fileKey));
        } else {
            cgformFtl.setFtlVersion(this.cgformFtlService.getNextVarsion(cgformId));
        }
        LogUtil.info("-------------------------step.2-------------------------------------");
        cgformFtl.setCgformId(cgformId);
        cgformFtl.setCgformName(cgformName);
        cgformFtl.setFtlStatus(ftlStatus);
        UploadFile uploadFile = new UploadFile(request, cgformFtl);
        uploadFile.setCusPath("forms");
        this.message = null;
        try {
            uploadFile.getMultipartRequest().setCharacterEncoding("UTF-8");
            MultipartHttpServletRequest multipartRequest = uploadFile.getMultipartRequest();
            String uploadbasepath = uploadFile.getBasePath();
            if (uploadbasepath == null) {
                uploadbasepath = ResourceUtil.getConfigByName("uploadpath");
            }
            Map fileMap = multipartRequest.getFileMap();
            String path = String.valueOf(uploadbasepath) + "\\";
            String realPath = String.valueOf(uploadFile.getMultipartRequest().getSession().getServletContext().getRealPath("\\")) + path;
            File file = new File(realPath);
            if (!file.exists()) {
                file.mkdir();
            }
            if (uploadFile.getCusPath() != null) {
                realPath = String.valueOf(realPath) + uploadFile.getCusPath() + "\\";
                path = String.valueOf(path) + uploadFile.getCusPath() + "\\";
                file = new File(realPath);
                if (!file.exists()) {
                    file.mkdir();
                }
            } else {
                realPath = String.valueOf(realPath) + DataUtils.getDataString(DataUtils.yyyyMMdd) + "\\";
                path = String.valueOf(path) + DataUtils.getDataString(DataUtils.yyyyMMdd) + "\\";
                file = new File(realPath);
                if (!file.exists()) {
                    file.mkdir();
                }
            }
            LogUtil.info("-------------------------step.3-------------------------------------");
            String fileName = "";
            for (Map.Entry entity : fileMap.entrySet()) {
                MultipartFile mf = (MultipartFile)entity.getValue();
                fileName = mf.getOriginalFilename();
                String extend = FileUtils.getExtend(fileName);
                String myfilename = "";
                String myhtmlfilename = "";
                String noextfilename = "";
                if (uploadFile.isRename()) {
                    noextfilename = String.valueOf(DataUtils.getDataString(DataUtils.yyyymmddhhmmss)) + StringUtil.random(8);
                    myfilename = String.valueOf(noextfilename) + "." + extend;
                } else {
                    myfilename = fileName;
                }
                String savePath = String.valueOf(realPath) + myfilename;
                cgformFtl.setFtlWordUrl(fileName);
                File savefile = new File(savePath);
                FileCopyUtils.copy((byte[])mf.getBytes(), (File)savefile);
                myhtmlfilename = String.valueOf(realPath) + noextfilename + ".html";
                String myftlfilename = String.valueOf(realPath) + noextfilename + ".ftl";
                LogUtil.info("-------------------------step.4-------------------------------------");
                OfficeHtmlUtil officeHtml = new OfficeHtmlUtil();
                officeHtml.wordToHtml(savePath, myhtmlfilename);
                String htmlStr = officeHtml.getInfo(myhtmlfilename);
                htmlStr = officeHtml.doHtml(htmlStr);
                officeHtml.stringToFile(htmlStr, myftlfilename);
                StringBuilder script = new StringBuilder("");
                script.append("<script type=\"text/javascript\">");
                script.append("${js_plug_in?if_exists}");
                script.append("</script>");
                htmlStr = htmlStr.replace("</html>", String.valueOf(script.toString()) + "</html>");
                cgformFtl.setFtlContent(htmlStr);
                this.cgformFtlService.saveOrUpdate(cgformFtl);
                LogUtil.info("-------------------------step.5-------------------------------------");
            }
        }
        catch (Exception e1) {
            LogUtil.error(e1.toString());
            this.message = e1.toString();
        }
        attributes.put("id", cgformFtl.getId());
        if (StringUtil.isNotEmpty(this.message)) {
            j.setMsg("Word\u8f6cFtl\u5931\u8d25," + this.message);
        } else {
            j.setMsg("Word\u8f6cFtl\u6210\u529f");
        }
        j.setAttributes(attributes);
        return j;
    }

    @RequestMapping(params={"cgformFtl2"})
    public ModelAndView cgformFtl2(HttpServletRequest request) {
        String formid = request.getParameter("formid");
        request.setAttribute("formid", (Object)formid);
        return new ModelAndView("jeecg/cgform/cgformftl/cgformFtlList2");
    }

    @RequestMapping(params={"addorupdate2"})
    public ModelAndView addorupdate2(CgformFtlEntity cgformFtl, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(cgformFtl.getId())) {
            cgformFtl = (CgformFtlEntity)this.cgformFtlService.getEntity(CgformFtlEntity.class, (Serializable)((Object)cgformFtl.getId()));
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<html xmlns:m=\"http://schemas.microsoft.com/office/2004/12/omml\"><head><title></title>");
        sb.append("<link href=\"plug-in/easyui/themes/default/easyui.css\" id=\"easyuiTheme\" rel=\"stylesheet\" type=\"text/css\" />");
        sb.append("<link href=\"plug-in/easyui/themes/icon.css\" rel=\"stylesheet\" type=\"text/css\" />");
        sb.append("<link href=\"plug-in/accordion/css/accordion.css\" rel=\"stylesheet\" type=\"text/css\" />");
        sb.append("<link href=\"plug-in/Validform/css/style.css\" rel=\"stylesheet\" type=\"text/css\" />");
        sb.append("<link href=\"plug-in/Validform/css/tablefrom.css\" rel=\"stylesheet\" type=\"text/css\" />");
        sb.append("<style type=\"text/css\">body{font-size:12px;}table{border: 1px solid #000000;padding:0; ");
        sb.append("margin:0 auto;border-collapse: collapse;width:100%;align:right;}td {border: 1px solid ");
        sb.append("#000000;background: #fff;font-size:12px;padding: 3px 3px 3px 8px;color: #000000;word-break: keep-all;}");
        sb.append("</style></head><script type=\"text/javascript\" src=\"plug-in/jquery/jquery-1.8.3.js\">");
        sb.append("</script><script type=\"text/javascript\" src=\"plug-in/tools/dataformat.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/easyui/jquery.easyui.min.1.3.2.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/easyui/locale/easyui-lang-zh_CN.js\"></script>");
        sb.append("<script type=\"text/javascript\" src=\"plug-in/tools/syUtil.js\"></script><script ");
        sb.append("type=\"text/javascript\" src=\"plug-in/My97DatePicker/WdatePicker.js\"></script><script ");
        sb.append("type=\"text/javascript\" src=\"plug-in/lhgDialog/lhgdialog.min.js\"></script><script ");
        sb.append("type=\"text/javascript\" src=\"plug-in/tools/curdtools.js\"></script><script type=\"text/javascript\" ");
        sb.append("src=\"plug-in/tools/easyuiextend.js\"></script><script type=\"text/javascript\" ");
        sb.append("src=\"plug-in/Validform/js/Validform_v5.3.1_min.js\"></script><script type=\"text/javascript\" ");
        sb.append("src=\"plug-in/Validform/js/Validform_Datatype.js\"></script><script type=\"text/javascript\" ");
        sb.append("src=\"plug-in/Validform/js/datatype.js\"></script><script type=\"text/javascript\" ");
        sb.append("src=\"plug-in/Validform/plugin/passwordStrength/passwordStrength-min.js\"></script>");
        sb.append("<script type=\"text/javascript\">$(function(){$(\"#formobj\").Validform({tiptype:4,");
        sb.append("btnSubmit:\"#btn_sub\",btnReset:\"#btn_reset\",ajaxPost:true,usePlugin:{passwordstrength:");
        sb.append("{minLen:6,maxLen:18,trigger:function(obj,error){if(error){obj.parent().next().");
        sb.append("find(\".Validform_checktip\").show();obj.find(\".passwordStrength\").hide();}");
        sb.append("else{$(\".passwordStrength\").show();obj.parent().next().find(\".Validform_checktip\")");
        sb.append(".hide();}}}},callback:function(data){var win = frameElement.api.opener;if(data.success");
        sb.append("==true){frameElement.api.close();win.tip(data.msg);}else{if(data.responseText==''||");
        sb.append("data.responseText==undefined)$(\"#formobj\").html(data.msg);else $(\"#formobj\")");
        sb.append(".html(data.responseText); return false;}win.reloadTable();}});});</script><body>");
        sb.append("</body><script type=\"text/javascript\">${js_plug_in?if_exists}</script></html>");
        req.setAttribute("cgformStr", (Object)sb);
        req.setAttribute("cgformFtlPage", (Object)cgformFtl);
        return new ModelAndView("jeecg/cgform/cgformftl/cgformFtlEditor");
    }

    @RequestMapping(params={"saveEditor"})
    @ResponseBody
    public AjaxJson saveEditor(CgformFtlEntity cgformFtl, HttpServletRequest request) {
        String ls_form;
        AjaxJson j = new AjaxJson();
        String fileKey = oConvertUtils.getString(request.getParameter("id"));
        String cgformId = oConvertUtils.getString(request.getParameter("cgformId"));
        String cgformName = oConvertUtils.getString(request.getParameter("cgformName"));
        String ftlStatus = oConvertUtils.getString(request.getParameter("ftlStatus"));
        String ftlVersion = oConvertUtils.getString(request.getParameter("ftlVersion"));
        String ftlWordUrl = oConvertUtils.getString(request.getParameter("ftlWordUrl"));
        String createBy = oConvertUtils.getString(request.getParameter("createBy"));
        String createName = oConvertUtils.getString(request.getParameter("createName"));
        String createDate = oConvertUtils.getString(request.getParameter("createDate"));
        if (oConvertUtils.isEmpty(ftlStatus)) {
            ftlStatus = "0";
        }
        cgformFtl.setCgformId(cgformId);
        cgformFtl.setCgformName(cgformName);
        cgformFtl.setFtlStatus(ftlStatus);
        if (StringUtil.isNotEmpty(fileKey)) {
            cgformFtl.setId(fileKey);
            if (StringUtil.isNotEmpty(ftlVersion)) {
                cgformFtl.setFtlVersion(Integer.valueOf(ftlVersion));
            }
            if (StringUtil.isNotEmpty(ftlWordUrl)) {
                cgformFtl.setFtlWordUrl(ftlWordUrl);
            }
            if (StringUtil.isNotEmpty(createBy)) {
                cgformFtl.setCreateBy(createBy);
            }
            if (StringUtil.isNotEmpty(createName)) {
                cgformFtl.setCreateName(createName);
            }
            if (StringUtil.isNotEmpty(createDate)) {
                cgformFtl.setCreateDate(DataUtils.str2Date(createDate, DataUtils.date_sdf));
            }
            if (!"<form".equalsIgnoreCase(cgformFtl.getFtlContent())) {
                ls_form = "<form action=\"cgFormBuildController.do?saveOrUpdate\" id=\"formobj\" name=\"formobj\" method=\"post\"><input type=\"hidden\" name=\"tableName\" value=\"${tableName?if_exists?html}\" /><input type=\"hidden\" name=\"id\" value=\"${id?if_exists?html}\" /><input type=\"hidden\" id=\"btn_sub\" class=\"btn_sub\" />#{jform_hidden_field}<table";
                cgformFtl.setFtlContent(cgformFtl.getFtlContent().replace("<table", ls_form));
                cgformFtl.setFtlContent(cgformFtl.getFtlContent().replace("</table>", "</table></form>"));
            }
            this.cgformFtlService.saveOrUpdate(cgformFtl);
            j.setMsg("\u4fee\u6539\u6210\u529f");
        } else {
            cgformFtl.setFtlVersion(this.cgformFtlService.getNextVarsion(cgformId));
            ls_form = "<form action=\"cgFormBuildController.do?saveOrUpdate\" id=\"formobj\" name=\"formobj\" method=\"post\"><input type=\"hidden\" name=\"tableName\" value=\"${tableName?if_exists?html}\" /><input type=\"hidden\" name=\"id\" value=\"${id?if_exists?html}\" /><input type=\"hidden\" id=\"btn_sub\" class=\"btn_sub\" />#{jform_hidden_field}<table";
            cgformFtl.setFtlContent(cgformFtl.getFtlContent().replace("<table", ls_form));
            cgformFtl.setFtlContent(cgformFtl.getFtlContent().replace("</table>", "</table></form>"));
            this.cgformFtlService.save(cgformFtl);
            j.setMsg("\u4e0a\u4f20\u6210\u529f");
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("id", cgformFtl.getId());
        j.setAttributes(attributes);
        return j;
    }
}

