/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.controller.button;

import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.cgform.entity.button.CgformButtonEntity;
import org.jeecgframework.web.cgform.service.button.CgformButtonServiceI;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/cgformButtonController"})
public class CgformButtonController
extends BaseController {
    private static final Logger logger = Logger.getLogger(CgformButtonController.class);
    @Autowired
    private CgformButtonServiceI cgformButtonService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"cgformButton"})
    public ModelAndView cgformButton(HttpServletRequest request) {
        String formId = request.getParameter("formId");
        String tableName = request.getParameter("tableName");
        request.setAttribute("formId", (Object)formId);
        request.setAttribute("tableName", (Object)tableName);
        return new ModelAndView("jeecg/cgform/button/cgformButtonList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(CgformButtonEntity cgformButton, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(CgformButtonEntity.class, dataGrid);
        HqlGenerateUtil.installHql(cq, cgformButton, request.getParameterMap());
        this.cgformButtonService.getDataGridReturn(cq, true);
        TagUtil.datagrid(response, dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(CgformButtonEntity cgformButton, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        cgformButton = (CgformButtonEntity)this.systemService.getEntity(CgformButtonEntity.class, (Serializable)((Object)cgformButton.getId()));
        this.message = "\u5220\u9664\u6210\u529f";
        this.cgformButtonService.delete(cgformButton);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(CgformButtonEntity cgformButton, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if ("add".equalsIgnoreCase(cgformButton.getButtonCode()) || "update".equalsIgnoreCase(cgformButton.getButtonCode()) || "delete".equalsIgnoreCase(cgformButton.getButtonCode())) {
            this.message = "\u6309\u94ae\u7f16\u7801\u4e0d\u80fd\u662fadd/update/delete";
            j.setMsg(this.message);
            return j;
        }
        List<CgformButtonEntity> list = this.cgformButtonService.checkCgformButton(cgformButton);
        if (list != null && list.size() > 0) {
            this.message = "\u6309\u94ae\u7f16\u7801\u5df2\u7ecf\u5b58\u5728";
            j.setMsg(this.message);
            return j;
        }
        if (StringUtil.isNotEmpty(cgformButton.getId())) {
            this.message = "\u66f4\u65b0\u6210\u529f";
            CgformButtonEntity t = this.cgformButtonService.get(CgformButtonEntity.class, (Serializable)((Object)cgformButton.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean(cgformButton, t);
                this.cgformButtonService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.message = "\u6dfb\u52a0\u6210\u529f";
            this.cgformButtonService.save(cgformButton);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(CgformButtonEntity cgformButton, HttpServletRequest req) {
        if (StringUtil.isNotEmpty(cgformButton.getId())) {
            cgformButton = (CgformButtonEntity)this.cgformButtonService.getEntity(CgformButtonEntity.class, (Serializable)((Object)cgformButton.getId()));
        }
        req.setAttribute("cgformButtonPage", (Object)cgformButton);
        return new ModelAndView("jeecg/cgform/button/cgformButton");
    }
}

