/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.controller.build;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.web.cgform.common.CommUtils;
import org.jeecgframework.web.cgform.engine.TempletContext;
import org.jeecgframework.web.cgform.entity.config.CgFormHeadEntity;
import org.jeecgframework.web.cgform.entity.upload.CgUploadEntity;
import org.jeecgframework.web.cgform.exception.BusinessException;
import org.jeecgframework.web.cgform.service.build.DataBaseService;
import org.jeecgframework.web.cgform.service.config.CgFormFieldServiceI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/cgFormBuildController"})
public class CgFormBuildController
extends BaseController {
    private static final Logger logger = Logger.getLogger(CgFormBuildController.class);
    private String message;
    @Autowired
    private TempletContext templetContext;
    @Autowired
    private DataBaseService dataBaseService;
    @Autowired
    private CgFormFieldServiceI cgFormFieldService;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"ftlForm"})
    public void ftlForm(HttpServletRequest request, HttpServletResponse response) {
        try {
            String subTableStr;
            long start = System.currentTimeMillis();
            String tableName = request.getParameter("tableName");
            Template template = this.templetContext.getTemplate(tableName);
            StringWriter stringWriter = new StringWriter();
            BufferedWriter writer = new BufferedWriter(stringWriter);
            HashMap<Object, Object> data = new HashMap();
            String id = request.getParameter("id");
            String version = this.cgFormFieldService.getCgFormVersionByTableName(tableName);
            Map<String, Object> configData = this.cgFormFieldService.getFtlFormConfig(tableName, version);
            data = new HashMap<String, Object>(configData);
            CgFormHeadEntity head = (CgFormHeadEntity)data.get("head");
            Map<Object, Object> dataForm = new HashMap();
            if (StringUtils.isNotEmpty((String)id)) {
                dataForm = this.dataBaseService.findOneForJdbc(tableName, id);
            }
            for (Map.Entry entry : dataForm.entrySet()) {
                String ok = (String)entry.getKey();
                Object ov = entry.getValue();
                data.put(ok, ov);
            }
            HashMap<String, Cloneable> tableData = new HashMap<String, Cloneable>();
            tableData.put(tableName, (Cloneable)((Object)dataForm));
            if (StringUtils.isNotEmpty((String)id) && head.getJformType() == 2 && StringUtils.isNotEmpty((String)(subTableStr = head.getSubTableStr()))) {
                String[] subTables = subTableStr.split(",");
                List<Object> subTableData = new ArrayList();
                String[] stringArray = subTables;
                int n = subTables.length;
                int n2 = 0;
                while (n2 < n) {
                    String subTable = stringArray[n2];
                    subTableData = this.cgFormFieldService.getSubTableData(tableName, subTable, id);
                    tableData.put(subTable, (Cloneable)((Object)subTableData));
                    ++n2;
                }
            }
            data.put("data", tableData);
            data.put("id", id);
            this.pushFiles(data, id);
            template.setDateTimeFormat("yyyy-MM-dd HH:mm:ss");
            template.setDateFormat("yyyy-MM-dd");
            template.setTimeFormat("HH:mm:ss");
            template.process(data, (Writer)writer);
            String content = stringWriter.toString();
            response.setContentType("text/html;charset=utf-8");
            response.getWriter().print(content);
            long end = System.currentTimeMillis();
            logger.debug((Object)("\u81ea\u5b9a\u4e49\u8868\u5355\u751f\u6210\u8017\u65f6\uff1a" + (end - start) + " ms"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
    }

    private void pushFiles(Map<String, Object> data, String id) {
        List<CgUploadEntity> uploadBeans = this.cgFormFieldService.findByProperty(CgUploadEntity.class, "cgformId", id);
        ArrayList files = new ArrayList(0);
        for (CgUploadEntity b : uploadBeans) {
            String title = b.getAttachmenttitle();
            String fileKey = b.getId();
            String path = b.getRealpath();
            String field = b.getCgformField();
            HashMap<String, String> file = new HashMap<String, String>();
            file.put("title", title);
            file.put("fileKey", fileKey);
            file.put("path", path);
            file.put("field", field == null ? "" : field);
            files.add(file);
        }
        data.put("filesList", files);
    }

    @RequestMapping(params={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(HttpServletRequest request) throws Exception {
        Map data;
        AjaxJson j;
        block11: {
            j = new AjaxJson();
            data = request.getParameterMap();
            if (data != null) {
                String[] filterName;
                data = CommUtils.mapConvert(data);
                String tableName = (String)data.get("tableName");
                String id = (String)data.get("id");
                for (Map.Entry<String, Object> entry : data.entrySet()) {
                    String ok = entry.getKey();
                    Object ov = entry.getValue() == null ? "" : entry.getValue();
                    logger.debug((Object)("name:" + ok.toString() + ";value:" + ov.toString()));
                }
                if (StringUtils.isEmpty((String)id)) {
                    filterName = new String[]{"tableName", "saveOrUpdate"};
                    data = CommUtils.attributeMapFilter(data, filterName);
                    try {
                        Object pkValue = null;
                        pkValue = this.dataBaseService.getPkValue(tableName);
                        data.put("id", pkValue);
                        int num = this.dataBaseService.insertTable(tableName, data);
                        if (num > 0) {
                            j.setSuccess(true);
                            this.message = "\u6dfb\u52a0\u6210\u529f";
                            break block11;
                        }
                        j.setSuccess(false);
                        this.message = "\u6dfb\u52a0\u5931\u8d25";
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        j.setSuccess(false);
                        this.message = e.getMessage();
                    }
                } else {
                    filterName = new String[]{"tableName", "saveOrUpdate", "id"};
                    data = CommUtils.attributeMapFilter(data, filterName);
                    try {
                        int num = this.dataBaseService.updateTable(tableName, id, data);
                        if (num > 0) {
                            j.setSuccess(true);
                            this.message = "\u66f4\u65b0\u6210\u529f";
                        } else {
                            j.setSuccess(false);
                            this.message = "\u66f4\u65b0\u5931\u8d25";
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        j.setSuccess(false);
                        this.message = e.getMessage();
                    }
                }
            }
        }
        j.setMsg(this.message);
        j.setObj(data);
        return j;
    }

    @RequestMapping(params={"saveOrUpdateMore"})
    @ResponseBody
    public AjaxJson saveOrUpdateMore(HttpServletRequest request) throws Exception {
        AjaxJson j = new AjaxJson();
        Map<String, Object> data = request.getParameterMap();
        if (data != null) {
            data = CommUtils.mapConvert(data);
            String tableName = (String)data.get("tableName");
            String id = (String)data.get("id");
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                String ok = entry.getKey();
                Object ov = entry.getValue() == null ? "" : entry.getValue();
                logger.debug((Object)("name:" + ok.toString() + ";value:" + ov.toString()));
            }
            Map<String, List<Map<String, Object>>> mapMore = CommUtils.mapConvertMore(data, tableName);
            if (StringUtils.isEmpty((String)id)) {
                logger.info((Object)"\u4e00\u5bf9\u591a\u6dfb\u52a0!!!!!");
                try {
                    Map<String, Object> result = this.dataBaseService.insertTableMore(mapMore, tableName);
                    data.put("id", result.get("id"));
                    j.setSuccess(true);
                    this.message = "\u6dfb\u52a0\u6210\u529f";
                }
                catch (BusinessException e) {
                    e.printStackTrace();
                    j.setSuccess(false);
                    this.message = e.getMessage();
                }
            } else {
                logger.info((Object)"\u4e00\u5bf9\u591a\u4fee\u6539!!!!!");
                try {
                    this.dataBaseService.updateTableMore(mapMore, tableName);
                    j.setSuccess(true);
                    this.message = "\u66f4\u65b0\u6210\u529f";
                }
                catch (BusinessException e) {
                    e.printStackTrace();
                    j.setSuccess(false);
                    this.message = e.getMessage();
                }
            }
        }
        j.setMsg(this.message);
        j.setObj(data);
        return j;
    }

    @RequestMapping(params={"doButton"})
    @ResponseBody
    public AjaxJson doButton(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            String formId = request.getParameter("formId");
            String buttonCode = request.getParameter("buttonCode");
            String tableName = request.getParameter("tableName");
            String id = request.getParameter("id");
            Map<String, Object> data = this.dataBaseService.findOneForJdbc(tableName, id);
            if (data != null) {
                for (Map.Entry<String, Object> entry : data.entrySet()) {
                    String ok = entry.getKey();
                    Object ov = entry.getValue() == null ? "" : entry.getValue();
                    logger.debug((Object)("name:" + ok.toString() + ";value:" + ov.toString()));
                }
                data = CommUtils.mapConvert(data);
                this.dataBaseService.executeSqlExtend(formId, buttonCode, data);
            }
            j.setSuccess(true);
            this.message = "\u64cd\u4f5c\u6210\u529f";
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u64cd\u4f5c\u5931\u8d25";
        }
        j.setMsg(this.message);
        return j;
    }
}

