/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.web.cgform.common;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.web.system.pojo.base.TSUser;

public enum SysVar {
    userid,
    userkey,
    username,
    userrealname,
    department_id,
    department_name,
    sysdate,
    systime;


    public String getSysValue() {
        String sysValue = "";
        TSUser currentUser = null;
        try {
            currentUser = ResourceUtil.getSessionUserName();
        }
        catch (RuntimeException e1) {
            currentUser = new TSUser();
            e1.printStackTrace();
        }
        switch (this) {
            case userid: {
                sysValue = currentUser.getId();
                break;
            }
            case userkey: {
                sysValue = currentUser.getUserKey();
                break;
            }
            case username: {
                sysValue = currentUser.getUserName();
                break;
            }
            case userrealname: {
                sysValue = currentUser.getRealName();
                break;
            }
            case department_id: {
                sysValue = currentUser.getTSDepart().getId();
                break;
            }
            case department_name: {
                sysValue = currentUser.getTSDepart().getDepartname();
                break;
            }
            case sysdate: {
                sysValue = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
                break;
            }
            case systime: {
                sysValue = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                break;
            }
            default: {
                sysValue = "";
            }
        }
        if (StringUtil.isEmpty(sysValue)) {
            sysValue = "";
        }
        return sysValue;
    }

    public static SysVar createSysVar(String sysVarName) {
        sysVarName = sysVarName.replaceAll("\\{", "");
        sysVarName = sysVarName.replaceAll("\\}", "");
        sysVarName = sysVarName.replace("sys.", "");
        return SysVar.valueOf(sysVarName.toLowerCase());
    }

    public static boolean isSysVar(String sysVarName) {
        if (StringUtil.isEmpty(sysVarName)) {
            return false;
        }
        return sysVarName.contains("{") && sysVarName.contains("}");
    }

    public static String getSysVar(String sysVarName) {
        if (!SysVar.isSysVar(sysVarName)) {
            return sysVarName;
        }
        SysVar sysvar = SysVar.createSysVar(sysVarName);
        return sysvar.getSysValue();
    }
}

