/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.formula.functions.T;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jeecgframework.core.util.ContextHolderUtils;
import org.jeecgframework.poi.excel.ExcelPublicUtil;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecgframework.poi.excel.annotation.ExcelTarget;
import org.jeecgframework.poi.excel.entity.ExcelCollectionParams;
import org.jeecgframework.poi.excel.entity.ExcelImportEntity;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.springframework.util.FileCopyUtils;

public final class ExcelImportUtil {
    public static Collection<?> importExcel(File file, Class<?> pojoClass, ImportParams params) {
        FileInputStream in = null;
        Collection<?> result = null;
        try {
            try {
                in = new FileInputStream(file);
                result = ExcelImportUtil.importExcelByIs(in, pojoClass, params);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    in.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static Collection<?> importExcelByIs(InputStream inputstream, Class<?> pojoClass, ImportParams params) throws Exception {
        ArrayList<T> result = new ArrayList<T>();
        HSSFWorkbook book = null;
        boolean isXSSFWorkbook = true;
        if (!inputstream.markSupported()) {
            inputstream = new PushbackInputStream(inputstream, 8);
        }
        if (POIFSFileSystem.hasPOIFSHeader((InputStream)inputstream)) {
            book = new HSSFWorkbook(inputstream);
            isXSSFWorkbook = false;
        } else if (POIXMLDocument.hasOOXMLHeader((InputStream)inputstream)) {
            book = new XSSFWorkbook(OPCPackage.open((InputStream)inputstream));
        }
        int i = 0;
        while (i < params.getSheetNum()) {
            Map<String, PictureData> pictures = isXSSFWorkbook ? ExcelPublicUtil.getSheetPictrues07((XSSFSheet)book.getSheetAt(i), (XSSFWorkbook)book) : ExcelPublicUtil.getSheetPictrues03((HSSFSheet)book.getSheetAt(i), book);
            result.addAll(ExcelImportUtil.importExcel(result, book.getSheetAt(i), pojoClass, params, pictures));
            ++i;
        }
        if (params.isNeedSave()) {
            ExcelImportUtil.saveThisExcel(params, pojoClass, isXSSFWorkbook, (Workbook)book);
        }
        return result;
    }

    private static void saveThisExcel(ImportParams params, Class<?> pojoClass, boolean isXSSFWorkbook, Workbook book) throws Exception {
        String path = String.valueOf(ContextHolderUtils.getRequest().getSession().getServletContext().getRealPath("\\")) + ExcelImportUtil.getSaveExcelUrl(params, pojoClass);
        path = path.replace("WEB-INF/classes/", "");
        File savefile = new File(path = path.replace("file:/", ""));
        if (!savefile.exists()) {
            savefile.mkdirs();
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyMMddHHmmss");
        FileOutputStream fos = new FileOutputStream(String.valueOf(path) + "/" + format.format(new Date()) + "_" + Math.round(Math.random() * 100000.0) + (isXSSFWorkbook ? ".xlsx" : ".xls"));
        book.write((OutputStream)fos);
        fos.close();
    }

    private static String getSaveExcelUrl(ImportParams params, Class<?> pojoClass) throws Exception {
        String url = "";
        if (params.getSaveUrl().equals("upload/excelUpload")) {
            url = pojoClass.getName().split("\\.")[pojoClass.getName().split("\\.").length - 1];
            return String.valueOf(params.getSaveUrl()) + "/" + url.substring(0, url.lastIndexOf("Entity"));
        }
        return params.getSaveUrl();
    }

    private static Collection<? extends T> importExcel(Collection<T> result, Sheet sheet, Class<?> pojoClass, ImportParams params, Map<String, PictureData> pictures) throws Exception {
        ArrayList<Object> collection = new ArrayList<Object>();
        HashMap<String, ExcelImportEntity> excelParams = new HashMap<String, ExcelImportEntity>();
        ArrayList<ExcelCollectionParams> excelCollection = new ArrayList<ExcelCollectionParams>();
        Field[] fileds = ExcelPublicUtil.getClassFields(pojoClass);
        ExcelTarget etarget = pojoClass.getAnnotation(ExcelTarget.class);
        String targetId = null;
        if (etarget != null) {
            targetId = etarget.id();
        }
        ExcelImportUtil.getAllExcelField(targetId, fileds, excelParams, excelCollection, pojoClass, null);
        Iterator rows = sheet.rowIterator();
        int j = 0;
        while (j < params.getTitleRows()) {
            rows.next();
            ++j;
        }
        Row row = null;
        HashMap<Integer, String> titlemap = new HashMap<Integer, String>();
        int j2 = 0;
        while (j2 < params.getSecondTitleRows()) {
            row = (Row)rows.next();
            Iterator cellTitle = row.cellIterator();
            int i = row.getFirstCellNum();
            while (cellTitle.hasNext()) {
                Cell cell = (Cell)cellTitle.next();
                String value = cell.getStringCellValue();
                if (!StringUtils.isEmpty((String)value)) {
                    titlemap.put(i, value);
                }
                ++i;
            }
            ++j2;
        }
        Object object = null;
        while (rows.hasNext()) {
            row = (Row)rows.next();
            if ((row.getCell(params.getKeyIndex()) == null || StringUtils.isEmpty((String)ExcelImportUtil.getKeyValue(row.getCell(params.getKeyIndex())))) && object != null) {
                for (ExcelCollectionParams param : excelCollection) {
                    ExcelImportUtil.addListContinue(object, param, row, titlemap, targetId, pictures, params);
                }
                continue;
            }
            object = ExcelPublicUtil.createObject(pojoClass, targetId);
            int i = row.getFirstCellNum();
            while (i < row.getLastCellNum()) {
                Cell cell = row.getCell(i);
                String titleString = (String)titlemap.get(i);
                if (excelParams.containsKey(titleString)) {
                    if (((ExcelImportEntity)excelParams.get(titleString)).getType() == 2) {
                        String picId = String.valueOf(row.getRowNum()) + "_" + i;
                        ExcelImportUtil.saveImage(object, picId, excelParams, titleString, pictures, params);
                    } else {
                        ExcelImportUtil.judgeTypeAndSetValue(object, cell, excelParams, titleString);
                    }
                }
                ++i;
            }
            for (ExcelCollectionParams param : excelCollection) {
                ExcelImportUtil.addListContinue(object, param, row, titlemap, targetId, pictures, params);
            }
            collection.add(object);
        }
        return collection;
    }

    private static String getKeyValue(Cell cell) {
        Object obj = null;
        switch (cell.getCellType()) {
            case 1: {
                obj = cell.getStringCellValue();
                break;
            }
            case 4: {
                obj = cell.getBooleanCellValue();
                break;
            }
            case 0: {
                obj = cell.getNumericCellValue();
            }
        }
        return obj == null ? null : obj.toString();
    }

    private static void saveImage(Object object, String picId, Map<String, ExcelImportEntity> excelParams, String titleString, Map<String, PictureData> pictures, ImportParams params) throws Exception {
        if (pictures == null) {
            return;
        }
        PictureData image = pictures.get(picId);
        byte[] data = image.getData();
        String fileName = "pic" + Math.round(Math.random() * 1.0E11);
        fileName = String.valueOf(fileName) + "." + ExcelPublicUtil.getFileExtendName(data);
        if (excelParams.get(titleString).getSaveType() == 1) {
            String path = String.valueOf(ContextHolderUtils.getRequest().getSession().getServletContext().getRealPath("\\")) + ExcelImportUtil.getSaveUrl(excelParams.get(titleString), object);
            path = path.replace("WEB-INF/classes/", "");
            File savefile = new File(path = path.replace("file:/", ""));
            if (!savefile.exists()) {
                savefile.mkdirs();
            }
            savefile = new File(String.valueOf(path) + "/" + fileName);
            FileCopyUtils.copy((byte[])data, (File)savefile);
            ExcelImportUtil.setValues(excelParams.get(titleString), object, String.valueOf(ExcelImportUtil.getSaveUrl(excelParams.get(titleString), object)) + "/" + fileName);
        } else {
            ExcelImportUtil.setValues(excelParams.get(titleString), object, data);
        }
    }

    private static String getSaveUrl(ExcelImportEntity excelImportEntity, Object object) throws Exception {
        String url = "";
        if (excelImportEntity.getSaveUrl().equals("upload")) {
            if (excelImportEntity.getSetMethods() != null && excelImportEntity.getSetMethods().size() > 0) {
                object = ExcelImportUtil.getFieldBySomeMethod(excelImportEntity.getSetMethods(), object);
            }
            url = object.getClass().getName().split("\\.")[object.getClass().getName().split("\\.").length - 1];
            return String.valueOf(excelImportEntity.getSaveUrl()) + "/" + url.substring(0, url.lastIndexOf("Entity"));
        }
        return excelImportEntity.getSaveUrl();
    }

    private static void addListContinue(Object object, ExcelCollectionParams param, Row row, Map<Integer, String> titlemap, String targetId, Map<String, PictureData> pictures, ImportParams params) throws Exception {
        Collection collection = (Collection)ExcelPublicUtil.getMethod(param.getName(), object.getClass()).invoke(object, new Object[0]);
        Object entity = ExcelPublicUtil.createObject(param.getType(), targetId);
        boolean isUsed = false;
        int i = row.getFirstCellNum();
        while (i < row.getLastCellNum()) {
            Cell cell = row.getCell(i);
            String titleString = titlemap.get(i);
            if (param.getExcelParams().containsKey(titleString)) {
                if (param.getExcelParams().get(titleString).getType() == 2) {
                    String picId = String.valueOf(row.getRowNum()) + "_" + i;
                    ExcelImportUtil.saveImage(object, picId, param.getExcelParams(), titleString, pictures, params);
                } else {
                    ExcelImportUtil.judgeTypeAndSetValue(entity, cell, param.getExcelParams(), titleString);
                }
                isUsed = true;
            }
            ++i;
        }
        if (isUsed) {
            collection.add(entity);
        }
    }

    private static void judgeTypeAndSetValue(Object object, Cell cell, Map<String, ExcelImportEntity> excelParams, String titleString) throws Exception {
        ExcelImportEntity entity = excelParams.get(titleString);
        Method setMethod = entity.getSetMethods() != null && entity.getSetMethods().size() > 0 ? entity.getSetMethods().get(entity.getSetMethods().size() - 1) : entity.getSetMethod();
        Type[] ts = setMethod.getGenericParameterTypes();
        String xclass = ts[0].toString();
        if (xclass.equals("class java.lang.String")) {
            cell.setCellType(1);
            ExcelImportUtil.setValues(entity, object, cell.getStringCellValue());
        } else if (xclass.equals("class java.util.Date")) {
            Date cellDate = null;
            if (cell.getCellType() == 0) {
                cellDate = cell.getDateCellValue();
                ExcelImportUtil.setValues(entity, object, cellDate);
            } else {
                cell.setCellType(1);
                cellDate = ExcelImportUtil.getDateData(entity, cell.getStringCellValue());
                ExcelImportUtil.setValues(entity, object, cellDate);
            }
        } else if (xclass.equals("class java.lang.Boolean")) {
            boolean valBool = 4 == cell.getCellType() ? cell.getBooleanCellValue() : cell.getStringCellValue().equalsIgnoreCase("true") || !cell.getStringCellValue().equals("0");
            ExcelImportUtil.setValues(entity, object, valBool);
        } else if (xclass.equals("class java.lang.Integer")) {
            Integer valInt = cell.getCellType() == 0 ? Integer.valueOf(new Double(cell.getNumericCellValue()).intValue()) : new Integer(cell.getStringCellValue());
            ExcelImportUtil.setValues(entity, object, valInt);
        } else if (xclass.equals("class java.lang.Long")) {
            Long valLong = cell.getCellType() == 0 ? Long.valueOf(new Double(cell.getNumericCellValue()).longValue()) : new Long(cell.getStringCellValue());
            ExcelImportUtil.setValues(entity, object, valLong);
        } else if (xclass.equals("class java.math.BigDecimal")) {
            BigDecimal valDecimal = cell.getCellType() == 0 ? new BigDecimal(cell.getNumericCellValue()) : new BigDecimal(cell.getStringCellValue());
            ExcelImportUtil.setValues(entity, object, valDecimal);
        } else if (xclass.equals("class java.lang.Double")) {
            Double valDouble = cell.getCellType() == 0 ? new Double(cell.getNumericCellValue()) : new Double(cell.getStringCellValue());
            ExcelImportUtil.setValues(entity, object, valDouble);
        }
    }

    private static Date getDateData(ExcelImportEntity entity, String value) {
        if (StringUtils.isNotEmpty((String)entity.getImportFormat()) && StringUtils.isNotEmpty((String)value)) {
            SimpleDateFormat format = new SimpleDateFormat(entity.getImportFormat());
            try {
                return format.parse(value);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void setValues(ExcelImportEntity entity, Object object, Object value) throws Exception {
        if (entity.getSetMethods() != null) {
            ExcelImportUtil.setFieldBySomeMethod(entity.getSetMethods(), object, value);
        } else {
            entity.getSetMethod().invoke(object, value);
        }
    }

    private static void setFieldBySomeMethod(List<Method> setMethods, Object object, Object value) throws Exception {
        Object t = ExcelImportUtil.getFieldBySomeMethod(setMethods, object);
        setMethods.get(setMethods.size() - 1).invoke(t, value);
    }

    private static Object getFieldBySomeMethod(List<Method> list, Object t) throws Exception {
        int i = 0;
        while (i < list.size() - 1) {
            Method m = list.get(i);
            t = m.invoke(t, new Object[0]);
            ++i;
        }
        return t;
    }

    private static void getAllExcelField(String targetId, Field[] fields, Map<String, ExcelImportEntity> excelParams, List<ExcelCollectionParams> excelCollection, Class<?> pojoClass, List<Method> getMethods) throws Exception {
        ExcelImportEntity excelEntity = null;
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (!ExcelPublicUtil.isNotUserExcelUserThis(field, targetId)) {
                if (ExcelPublicUtil.isCollection(field.getType())) {
                    ExcelCollectionParams collection = new ExcelCollectionParams();
                    collection.setName(field.getName());
                    HashMap<String, ExcelImportEntity> temp = new HashMap<String, ExcelImportEntity>();
                    ParameterizedType pt = (ParameterizedType)field.getGenericType();
                    Class clz = (Class)pt.getActualTypeArguments()[0];
                    collection.setType(clz);
                    ExcelImportUtil.getExcelFieldList(targetId, ExcelPublicUtil.getClassFields(clz), clz, temp, null);
                    collection.setExcelParams(temp);
                    excelCollection.add(collection);
                } else if (ExcelPublicUtil.isJavaClass(field)) {
                    ExcelImportUtil.addEntityToMap(targetId, field, excelEntity, pojoClass, getMethods, excelParams);
                } else {
                    ArrayList<Method> newMethods = new ArrayList<Method>();
                    if (getMethods != null) {
                        newMethods.addAll(getMethods);
                    }
                    newMethods.add(ExcelPublicUtil.getMethod(field.getName(), pojoClass));
                    ExcelImportUtil.getAllExcelField(targetId, ExcelPublicUtil.getClassFields(field.getType()), excelParams, excelCollection, field.getType(), newMethods);
                }
            }
            ++i;
        }
    }

    private static void getExcelFieldList(String targetId, Field[] fields, Class<?> pojoClass, Map<String, ExcelImportEntity> temp, List<Method> getMethods) throws Exception {
        ExcelImportEntity excelEntity = null;
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (!ExcelPublicUtil.isNotUserExcelUserThis(field, targetId)) {
                if (ExcelPublicUtil.isJavaClass(field)) {
                    ExcelImportUtil.addEntityToMap(targetId, field, excelEntity, pojoClass, getMethods, temp);
                } else {
                    ArrayList<Method> newMethods = new ArrayList<Method>();
                    if (getMethods != null) {
                        newMethods.addAll(getMethods);
                    }
                    newMethods.add(ExcelPublicUtil.getMethod(field.getName(), pojoClass, field.getType()));
                    ExcelImportUtil.getExcelFieldList(targetId, ExcelPublicUtil.getClassFields(field.getType()), field.getType(), temp, newMethods);
                }
            }
            ++i;
        }
    }

    private static void addEntityToMap(String targetId, Field field, ExcelImportEntity excelEntity, Class<?> pojoClass, List<Method> getMethods, Map<String, ExcelImportEntity> temp) throws Exception {
        Excel excel = field.getAnnotation(Excel.class);
        excelEntity = new ExcelImportEntity();
        excelEntity.setType(excel.exportType());
        excelEntity.setSaveUrl(excel.savePath());
        excelEntity.setSaveType(excel.imageType());
        ExcelImportUtil.getExcelField(targetId, field, excelEntity, excel, pojoClass);
        if (getMethods != null) {
            ArrayList<Method> newMethods = new ArrayList<Method>();
            newMethods.addAll(getMethods);
            newMethods.add(excelEntity.getSetMethod());
            excelEntity.setSetMethods(newMethods);
        }
        temp.put(excelEntity.getName(), excelEntity);
    }

    private static void getExcelField(String targetId, Field field, ExcelImportEntity excelEntity, Excel excel, Class<?> pojoClass) throws Exception {
        excelEntity.setName(ExcelImportUtil.getExcelName(excel.exportName(), targetId));
        String fieldname = field.getName();
        if (excel.importConvertSign() == 1 || excel.imExConvert() == 1) {
            StringBuffer getConvertMethodName = new StringBuffer("convertSet");
            getConvertMethodName.append(fieldname.substring(0, 1).toUpperCase());
            getConvertMethodName.append(fieldname.substring(1));
            Method getConvertMethod = pojoClass.getMethod(getConvertMethodName.toString(), field.getType());
            excelEntity.setSetMethod(getConvertMethod);
        } else {
            excelEntity.setSetMethod(ExcelPublicUtil.getMethod(fieldname, pojoClass, field.getType()));
        }
        if (StringUtils.isEmpty((String)excel.importFormat())) {
            excelEntity.setImportFormat(excel.imExFormat());
        } else {
            excelEntity.setImportFormat(excel.importFormat());
        }
    }

    private static String getExcelName(String exportName, String targetId) {
        String[] arr;
        if (exportName.indexOf("_") < 0) {
            return exportName;
        }
        String[] stringArray = arr = exportName.split(",");
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.indexOf(targetId) != -1) {
                return str.split("_")[0];
            }
            ++n2;
        }
        return null;
    }
}

