/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.util.plugin;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.util.ContextHolderUtils;
import org.jeecgframework.core.util.plugin.SynchronizationHelper;
import org.springframework.beans.factory.InitializingBean;

public class ViewFreemarker
implements InitializingBean {
    static final Logger logger = Logger.getLogger(ViewFreemarker.class);
    private static Configuration _tplConfig = new Configuration();

    static {
        _tplConfig.setClassForTemplateLoading(ViewFreemarker.class, "/template/content");
    }

    public static String parseTemplate(String tplName, String encoding, Map<String, Object> paras) {
        try {
            StringWriter swriter = new StringWriter();
            Template mytpl = null;
            mytpl = _tplConfig.getTemplate(tplName, encoding);
            mytpl.process(paras, (Writer)swriter);
            return swriter.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.toString();
        }
    }

    public static void view(HttpServletResponse response, String template) throws Exception {
        ViewFreemarker.view(response, template, null);
    }

    public static void view(HttpServletResponse rep, String template, Map<String, Object> paras) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Freemarker loading\uff1a" + template));
        }
        HttpServletRequest request = ContextHolderUtils.getRequest();
        HttpServletResponse response = SynchronizationHelper.getCurrentResponse();
        if (paras == null) {
            paras = new HashMap<String, Object>();
        }
        paras.put("request", request);
        paras.put("response", response);
        String content = ViewFreemarker.parseTemplate(template, "UTF-8", paras);
        ViewFreemarker.outputToPage(request, response, content);
    }

    private static void outputToPage(HttpServletRequest request, HttpServletResponse response, String content) throws Exception {
        response.setContentType("text/html");
        response.setHeader("Cache-Control", "no-store");
        try {
            PrintWriter writer = response.getWriter();
            writer.println(content);
            writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void afterPropertiesSet() throws Exception {
    }
}

