/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.util;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.jeecgframework.core.util.LogUtil;

public class UploadUtils {
    public static final String FORM_FIELDS = "form_fields";
    public static final String FILE_FIELDS = "file_fields";
    private long maxSize = 1000000L;
    private Map<String, String> extMap = new HashMap<String, String>();
    private String basePath = "upload";
    private String dirName = "images";
    private static final String TEMP_PATH = "/temp";
    private String tempPath = String.valueOf(this.basePath) + "/temp";
    private String fileName;
    private String savePath;
    private String saveUrl;
    private String fileUrl;

    public UploadUtils() {
        this.extMap.put("images", "gif,jpg,jpeg,png,bmp");
        this.extMap.put("flashs", "swf,flv");
        this.extMap.put("medias", "swf,flv,mp3,wav,wma,wmv,mid,avi,mpg,asf,rm,rmvb");
        this.extMap.put("files", "doc,docx,xls,xlsx,ppt,htm,html,txt,zip,rar,gz,bz2");
    }

    public String[] uploadFile(HttpServletRequest request) {
        List fiList;
        String[] infos = new String[5];
        infos[0] = this.validateFields(request);
        Map<Object, Object> fieldsMap = new HashMap();
        if (infos[0].equals("true")) {
            fieldsMap = this.initFields(request);
        }
        if ((fiList = (List)fieldsMap.get(FILE_FIELDS)) != null) {
            for (FileItem item : fiList) {
                infos[1] = this.saveFile(item);
            }
            infos[2] = this.savePath;
            infos[3] = this.saveUrl;
            infos[4] = this.fileUrl;
        }
        return infos;
    }

    private String validateFields(HttpServletRequest request) {
        String errorInfo = "true";
        String contentType = request.getContentType();
        int contentLength = request.getContentLength();
        this.savePath = String.valueOf(request.getSession().getServletContext().getRealPath("/")) + this.basePath + "/";
        this.saveUrl = String.valueOf(request.getContextPath()) + "/" + this.basePath + "/";
        File uploadDir = new File(this.savePath);
        if (contentType == null || !contentType.startsWith("multipart")) {
            LogUtil.info("\u8bf7\u6c42\u4e0d\u5305\u542bmultipart/form-data\u6d41");
            errorInfo = "\u8bf7\u6c42\u4e0d\u5305\u542bmultipart/form-data\u6d41";
        } else if (this.maxSize < (long)contentLength) {
            LogUtil.info("\u4e0a\u4f20\u6587\u4ef6\u5927\u5c0f\u8d85\u51fa\u6587\u4ef6\u6700\u5927\u5927\u5c0f");
            errorInfo = "\u4e0a\u4f20\u6587\u4ef6\u5927\u5c0f\u8d85\u51fa\u6587\u4ef6\u6700\u5927\u5927\u5c0f[" + this.maxSize + "]";
        } else if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            errorInfo = "\u8bf7\u9009\u62e9\u6587\u4ef6";
        } else if (!uploadDir.isDirectory()) {
            errorInfo = "\u4e0a\u4f20\u76ee\u5f55[" + this.savePath + "]\u4e0d\u5b58\u5728";
        } else if (!uploadDir.canWrite()) {
            errorInfo = "\u4e0a\u4f20\u76ee\u5f55[" + this.savePath + "]\u6ca1\u6709\u5199\u6743\u9650";
        } else if (!this.extMap.containsKey(this.dirName)) {
            errorInfo = "\u76ee\u5f55\u540d\u4e0d\u6b63\u786e";
        } else {
            this.savePath = String.valueOf(this.savePath) + this.dirName + "/";
            this.saveUrl = String.valueOf(this.saveUrl) + this.dirName + "/";
            File saveDirFile = new File(this.savePath);
            if (!saveDirFile.exists()) {
                saveDirFile.mkdirs();
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            String ymd = sdf.format(new Date());
            this.savePath = String.valueOf(this.savePath) + ymd + "/";
            this.saveUrl = String.valueOf(this.saveUrl) + ymd + "/";
            File dirFile = new File(this.savePath);
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            this.tempPath = String.valueOf(request.getSession().getServletContext().getRealPath("/")) + this.tempPath + "/";
            File file = new File(this.tempPath);
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        return errorInfo;
    }

    private Map<String, Object> initFields(HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (isMultipart) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setSizeThreshold(0xA00000);
            factory.setRepository(new File(this.tempPath));
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setHeaderEncoding("UTF-8");
            upload.setSizeMax(this.maxSize);
            List items = null;
            try {
                items = upload.parseRequest(request);
            }
            catch (FileUploadException e) {
                e.printStackTrace();
            }
            if (items != null && items.size() > 0) {
                Iterator iter = items.iterator();
                ArrayList<FileItem> list = new ArrayList<FileItem>();
                HashMap<String, String> fields = new HashMap<String, String>();
                while (iter.hasNext()) {
                    FileItem item = (FileItem)iter.next();
                    if (item.isFormField()) {
                        String name = item.getFieldName();
                        String value = item.getString();
                        fields.put(name, value);
                        continue;
                    }
                    list.add(item);
                }
                map.put(FORM_FIELDS, fields);
                map.put(FILE_FIELDS, list);
            }
        }
        return map;
    }

    private String saveFile(FileItem item) {
        String error = "true";
        String fileName = item.getName();
        String fileExt = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        if (item.getSize() > this.maxSize) {
            error = "\u4e0a\u4f20\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u9650\u5236";
        } else if (!Arrays.asList(this.extMap.get(this.dirName).split(",")).contains(fileExt)) {
            error = "\u4e0a\u4f20\u6587\u4ef6\u6269\u5c55\u540d\u662f\u4e0d\u5141\u8bb8\u7684\u6269\u5c55\u540d\u3002\n\u53ea\u5141\u8bb8" + this.extMap.get(this.dirName) + "\u683c\u5f0f\u3002";
        } else {
            String newFileName;
            if ("".equals(fileName.trim())) {
                SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
                newFileName = String.valueOf(df.format(new Date())) + "_" + new Random().nextInt(1000) + "." + fileExt;
            } else {
                newFileName = String.valueOf(fileName) + "." + fileExt;
            }
            this.fileUrl = String.valueOf(this.saveUrl) + newFileName;
            try {
                File uploadedFile = new File(this.savePath, newFileName);
                item.write(uploadedFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                LogUtil.info("\u4e0a\u4f20\u5931\u8d25\u4e86\uff01\uff01\uff01");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return error;
    }

    public String getSavePath() {
        return this.savePath;
    }

    public String getSaveUrl() {
        return this.saveUrl;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public Map<String, String> getExtMap() {
        return this.extMap;
    }

    public void setExtMap(Map<String, String> extMap) {
        this.extMap = extMap;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
        this.tempPath = String.valueOf(basePath) + TEMP_PATH;
    }

    public String getDirName() {
        return this.dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public String getTempPath() {
        return this.tempPath;
    }

    public void setTempPath(String tempPath) {
        this.tempPath = tempPath;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

