/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public final class ToEntityUtil {
    public static <T> T toEntityList(List<?> datas, Class<?> clas, String ... labels) {
        ArrayList<T> entitys = new ArrayList<T>();
        int i = 0;
        while (i < datas.size()) {
            Object[] data = (Object[])datas.get(i);
            try {
                T entity = ToEntityUtil.toEntity(clas, data, labels);
                entitys.add(entity);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return (T)entitys;
    }

    public static <T> T toEntity(Class<?> clas, Object[] data, String ... labels) throws Exception {
        Object entity = clas.newInstance();
        int j = 0;
        while (j < labels.length) {
            if (data[j] != null && data[j].toString().trim().length() != 0) {
                String methodName = "set" + String.valueOf(labels[j].charAt(0)).toUpperCase() + labels[j].substring(1);
                Field field = entity.getClass().getDeclaredField(labels[j]);
                String parameterType = field.getType().getSimpleName();
                Method method = entity.getClass().getDeclaredMethod(methodName, field.getType());
                String val = data[j].toString();
                if (parameterType.equals("String")) {
                    method.invoke(entity, val);
                } else if (parameterType.equals("Character")) {
                    method.invoke(entity, Character.valueOf(val.charAt(0)));
                } else if (parameterType.equals("Boolean")) {
                    method.invoke(entity, val.equals("true") || val.equals("1"));
                } else if (parameterType.equals("Short")) {
                    method.invoke(entity, Short.parseShort(val));
                } else if (parameterType.equals("Integer")) {
                    method.invoke(entity, Integer.parseInt(val));
                } else if (parameterType.equals("Float")) {
                    method.invoke(entity, Float.valueOf(Float.parseFloat(val)));
                } else if (parameterType.equals("Long")) {
                    method.invoke(entity, Long.parseLong(val));
                } else if (parameterType.equals("Double")) {
                    method.invoke(entity, Double.parseDouble(val));
                }
            }
            ++j;
        }
        return (T)entity;
    }
}

