/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.util;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jeecgframework.core.annotation.Ehcache;
import org.jeecgframework.core.util.ApplicationContextUtil;
import org.jeecgframework.core.util.ContextHolderUtils;
import org.jeecgframework.core.util.DBTypeUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.system.manager.ClientManager;
import org.jeecgframework.web.system.pojo.base.TSRoleFunction;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.springframework.context.i18n.LocaleContextHolder;
import weixin.cms.entity.WeixinCmsSiteEntity;
import weixin.cms.service.WeixinCmsSiteServiceI;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.service.WeixinAccountServiceI;

public class ResourceUtil {
    public static final String WARN_ACCOUNT_ID_IS_NULL = "NULL-NULL-NULL-NULL-NULL-NULL-NULL-NULL-NULL";
    public static final String DEFAULT_CMS_ACCOUNT_ID = "402881e8461795c201461795c2e90000";
    private static final ResourceBundle bundle = ResourceBundle.getBundle("sysConfig");
    private static String FTL_DOMAIN;

    public static final String getSessionattachmenttitle(String sessionName) {
        return bundle.getString(sessionName);
    }

    public static final TSUser getSessionUserName() {
        HttpSession session = ContextHolderUtils.getSession();
        if (ClientManager.getInstance().getClient(session.getId()) != null) {
            return ClientManager.getInstance().getClient(session.getId()).getUser();
        }
        return null;
    }

    public static final TSUser setSessionUserName(TSUser user) {
        HttpSession session = ContextHolderUtils.getSession();
        if (ClientManager.getInstance().getClient(session.getId()) != null) {
            ClientManager.getInstance().getClient(session.getId()).setUser(user);
            return ClientManager.getInstance().getClient(session.getId()).getUser();
        }
        return null;
    }

    public static final WeixinAccountEntity getShangJiaAccount() {
        HttpSession session = ContextHolderUtils.getSession();
        if (session.getAttribute("WEIXIN_ACCOUNT") != null) {
            WeixinAccountEntity WeixinAccountEntity2 = (WeixinAccountEntity)session.getAttribute("WEIXIN_ACCOUNT");
            WeixinAccountServiceI weixinAccountService = (WeixinAccountServiceI)ApplicationContextUtil.getContext().getBean("weixinAccountService");
            WeixinAccountEntity dbWeixinAccountEntity = (WeixinAccountEntity)weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)WeixinAccountEntity2.getId()));
            if (!dbWeixinAccountEntity.getPostCode().equals(WeixinAccountEntity2.getPostCode())) {
                session.setAttribute("WEIXIN_ACCOUNT", (Object)dbWeixinAccountEntity);
                return dbWeixinAccountEntity;
            }
            return WeixinAccountEntity2;
        }
        WeixinAccountEntity po = new WeixinAccountEntity();
        po.setId(WARN_ACCOUNT_ID_IS_NULL);
        return po;
    }

    public static final void setShangJiaAccount(WeixinAccountEntity weixinAccountEntity) {
        HttpSession session = ContextHolderUtils.getSession();
        session.setAttribute("WEIXIN_ACCOUNT", (Object)weixinAccountEntity);
    }

    public static final WeixinAccountEntity getShangJiaAccount(String accountid) {
        WeixinAccountServiceI weixinAccountService = (WeixinAccountServiceI)ApplicationContextUtil.getContext().getBean("weixinAccountService");
        WeixinAccountEntity WeixinAccountEntity2 = (WeixinAccountEntity)weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)accountid));
        return WeixinAccountEntity2;
    }

    public static final String getShangJiaAccountId() {
        HttpSession session = ContextHolderUtils.getSession();
        if (session.getAttribute("WEIXIN_ACCOUNT") != null) {
            WeixinAccountEntity weixinAccountEntity = (WeixinAccountEntity)session.getAttribute("WEIXIN_ACCOUNT");
            return weixinAccountEntity.getId();
        }
        return WARN_ACCOUNT_ID_IS_NULL;
    }

    public static final boolean onlineShangJiaAccountIdIsNull() {
        return WARN_ACCOUNT_ID_IS_NULL.equals(ResourceUtil.getShangJiaAccountId());
    }

    public static final String getShangJiaAccountId(HttpServletRequest request) {
        String accountid = request.getParameter("accountid");
        if (accountid != null) {
            return accountid;
        }
        return null;
    }

    public static final String getOpenid(HttpServletRequest request) {
        String openid = request.getParameter("openid");
        if (openid != null) {
            return openid;
        }
        return null;
    }

    public static final String getUserOpenId() {
        HttpSession session = ContextHolderUtils.getSession();
        Object userOpenId = session.getAttribute("USER_OPENID");
        if (userOpenId != null) {
            return userOpenId.toString();
        }
        return "";
    }

    public static final String getQianTaiAccountId() {
        HttpSession session = ContextHolderUtils.getSession();
        Object accountid = session.getAttribute("WEIXIN_QIANTAI_ACCOUNTID");
        if (accountid != null) {
            return accountid.toString();
        }
        return null;
    }

    public static void initQianTaiRequestAccountId(HttpServletRequest request) {
        String accountid = request.getParameter("accountid");
        if (accountid != null) {
            HttpSession session = ContextHolderUtils.getSession();
            session.setAttribute("WEIXIN_QIANTAI_ACCOUNTID", (Object)accountid);
        }
    }

    @Deprecated
    public static final List<TSRoleFunction> getSessionTSRoleFunction(String roleId) {
        HttpSession session = ContextHolderUtils.getSession();
        if (session.getAttributeNames().hasMoreElements()) {
            List TSRoleFunctionList = (List)session.getAttribute(roleId);
            if (TSRoleFunctionList != null) {
                return TSRoleFunctionList;
            }
            return null;
        }
        return null;
    }

    public static String getRequestPath(HttpServletRequest request) {
        String requestPath = String.valueOf(request.getRequestURI()) + "?" + request.getQueryString();
        if (requestPath.indexOf("&") > -1) {
            requestPath = requestPath.substring(0, requestPath.indexOf("&"));
        }
        requestPath = requestPath.substring(request.getContextPath().length() + 1);
        return requestPath;
    }

    public static String getRedirUrl(HttpServletRequest request) {
        String requestPath = String.valueOf(request.getRequestURI()) + "?" + request.getQueryString();
        requestPath = requestPath.substring(request.getContextPath().length() + 1);
        return requestPath;
    }

    @Ehcache
    public static final String getConfigByName(String name) {
        return bundle.getString(name);
    }

    public static final Map<Object, Object> getConfigMap(String path) {
        ResourceBundle bundle = ResourceBundle.getBundle(path);
        Set<Object> set = bundle.keySet();
        return oConvertUtils.SetToMap(set);
    }

    public static String getSysPath() {
        String path = Thread.currentThread().getContextClassLoader().getResource("").toString();
        String temp = path.replaceFirst("file:/", "").replaceFirst("WEB-INF/classes/", "");
        String separator = System.getProperty("file.separator");
        String resultPath = temp.replaceAll("/", String.valueOf(separator) + separator).replaceAll("%20", " ");
        return resultPath;
    }

    public static String getPorjectPath() {
        String nowpath = System.getProperty("user.dir");
        String tempdir = nowpath.replace("bin", "webapps");
        tempdir = String.valueOf(tempdir) + "\\";
        return tempdir;
    }

    public static String getWebProjectPath() {
        String classPath = ResourceUtil.getClassPath();
        String url = null;
        if (classPath.indexOf("WEB-INF") != -1) {
            url = "/".equals(ResourceUtil.getSeparator()) ? String.valueOf(ResourceUtil.getSeparator()) + classPath.substring(0, classPath.indexOf("WEB-INF")) : classPath.substring(0, classPath.indexOf("WEB-INF"));
        }
        if (classPath.indexOf("target") != -1) {
            url = ResourceUtil.getPorjectPath();
        }
        return url;
    }

    public static String getClassPath() {
        String path = Thread.currentThread().getContextClassLoader().getResource("").toString();
        String temp = path.replaceFirst("file:/", "");
        String separator = System.getProperty("file.separator");
        String resultPath = temp.replaceAll("/", String.valueOf(separator) + separator);
        return resultPath;
    }

    public static String getSystempPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getSeparator() {
        return System.getProperty("file.separator");
    }

    public static String getParameter(String field) {
        HttpServletRequest request = ContextHolderUtils.getRequest();
        return request.getParameter(field);
    }

    public static final String getJdbcUrl() {
        return DBTypeUtil.getDBType().toLowerCase();
    }

    public static String getRandCodeLength() {
        return bundle.getString("randCodeLength");
    }

    public static String getRandCodeType() {
        return bundle.getString("randCodeType");
    }

    public static final String getDomainByConfig() {
        if (oConvertUtils.isNotEmpty(FTL_DOMAIN)) {
            return FTL_DOMAIN;
        }
        if (ResourceUtil.getConfigByName("domain").endsWith("/")) {
            FTL_DOMAIN = ResourceUtil.getConfigByName("domain");
            return FTL_DOMAIN;
        }
        FTL_DOMAIN = String.valueOf(ResourceUtil.getConfigByName("domain")) + "/";
        return FTL_DOMAIN;
    }

    public static String getDomanAccountId() {
        String accountid = DEFAULT_CMS_ACCOUNT_ID;
        HttpServletRequest request = ContextHolderUtils.getRequest();
        String hostName = request.getServerName();
        WeixinCmsSiteEntity weixinCmsSiteEntity = null;
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.getLanguage();
        WeixinCmsSiteServiceI weixinCmsSiteService = (WeixinCmsSiteServiceI)ApplicationContextUtil.getContext().getBean("weixinCmsSiteService");
        List list = weixinCmsSiteService.queryCmsSiteByLangAndDomain(lang, hostName);
        if (list != null && list.size() > 0) {
            weixinCmsSiteEntity = (WeixinCmsSiteEntity)list.get(0);
        }
        if (weixinCmsSiteEntity != null) {
            accountid = weixinCmsSiteEntity.getAccountid();
        }
        HttpSession session = ContextHolderUtils.getSession();
        session.setAttribute("WEIXIN_QIANTAI_ACCOUNTID", (Object)accountid);
        return accountid;
    }

    public static void main(String[] args) {
    }
}

