/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.util;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PinyinUtil {
    public static String[] stringToPinyin(String src) {
        return PinyinUtil.stringToPinyin(src, false, null);
    }

    public static String[] stringToPinyin(String src, String separator) {
        return PinyinUtil.stringToPinyin(src, true, separator);
    }

    public static String[] stringToPinyin(String src, boolean isPolyphone, String separator) {
        if ("".equals(src) || src == null) {
            return null;
        }
        char[] srcChar = src.toCharArray();
        int srcCount = srcChar.length;
        String[] srcStr = new String[srcCount];
        int i = 0;
        while (i < srcCount) {
            srcStr[i] = PinyinUtil.charToPinyin(srcChar[i], isPolyphone, separator);
            ++i;
        }
        return srcStr;
    }

    public static String charToPinyin(char src, boolean isPolyphone, String separator) {
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        StringBuffer tempPinying = new StringBuffer();
        if (src > '\u0080') {
            try {
                String[] strs = PinyinHelper.toHanyuPinyinStringArray((char)src, (HanyuPinyinOutputFormat)defaultFormat);
                if (isPolyphone && separator != null) {
                    int i = 0;
                    while (i < strs.length) {
                        tempPinying.append(strs[i]);
                        if (strs.length != i + 1) {
                            tempPinying.append(separator);
                        }
                        ++i;
                    }
                } else {
                    tempPinying.append(strs[0]);
                }
            }
            catch (BadHanyuPinyinOutputFormatCombination e) {
                e.printStackTrace();
            }
        } else {
            tempPinying.append(src);
        }
        return tempPinying.toString();
    }

    public static String hanziToPinyin(String hanzi) {
        return PinyinUtil.hanziToPinyin(hanzi, " ");
    }

    public static String hanziToPinyin(String hanzi, String separator) {
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        String pinyingStr = "";
        try {
            pinyingStr = PinyinHelper.toHanyuPinyinString((String)hanzi, (HanyuPinyinOutputFormat)defaultFormat, (String)separator);
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
        }
        return pinyingStr;
    }

    public static String stringArrayToString(String[] str, String separator) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < str.length) {
            sb.append(str[i]);
            if (str.length != i + 1) {
                sb.append(separator);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String stringArrayToString(String[] str) {
        return PinyinUtil.stringArrayToString(str, "");
    }

    public static String charArrayToString(char[] ch, String separator) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < ch.length) {
            sb.append(ch[i]);
            if (ch.length != i + 1) {
                sb.append(separator);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String charArrayToString(char[] ch) {
        return PinyinUtil.charArrayToString(ch, " ");
    }

    public static char[] getHeadByChar(char src, boolean isCapital) {
        if (src <= '\u0080') {
            return new char[]{src};
        }
        String[] pinyingStr = PinyinHelper.toHanyuPinyinStringArray((char)src);
        int polyphoneSize = pinyingStr.length;
        char[] headChars = new char[polyphoneSize];
        int i = 0;
        String[] stringArray = pinyingStr;
        int n = pinyingStr.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            char headChar = s.charAt(0);
            headChars[i] = isCapital ? Character.toUpperCase(headChar) : headChar;
            ++i;
            ++n2;
        }
        return headChars;
    }

    public static char[] getHeadByChar(char src) {
        return PinyinUtil.getHeadByChar(src, true);
    }

    public static String[] getHeadByString(String src) {
        return PinyinUtil.getHeadByString(src, true);
    }

    public static String[] getHeadByString(String src, boolean isCapital) {
        return PinyinUtil.getHeadByString(src, isCapital, null);
    }

    public static String[] getHeadByString(String src, boolean isCapital, String separator) {
        char[] chars = src.toCharArray();
        String[] headString = new String[chars.length];
        int i = 0;
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            char[] chs = PinyinUtil.getHeadByChar(ch, isCapital);
            StringBuffer sb = new StringBuffer();
            if (separator != null) {
                int j = 1;
                char[] cArray2 = chs;
                int n3 = chs.length;
                int n4 = 0;
                while (n4 < n3) {
                    char ch1 = cArray2[n4];
                    sb.append(ch1);
                    if (j != chs.length) {
                        sb.append(separator);
                    }
                    ++j;
                    ++n4;
                }
            } else {
                sb.append(chs[0]);
            }
            headString[i] = sb.toString();
            ++i;
            ++n2;
        }
        return headString;
    }

    public static String getPinYin(String src) {
        char[] t1 = null;
        t1 = src.toCharArray();
        String[] t2 = new String[t1.length];
        HanyuPinyinOutputFormat t3 = new HanyuPinyinOutputFormat();
        t3.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        t3.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        t3.setVCharType(HanyuPinyinVCharType.WITH_V);
        String t4 = "";
        int t0 = t1.length;
        try {
            int i = 0;
            while (i < t0) {
                if (Character.toString(t1[i]).matches("[\\u4E00-\\u9FA5]+")) {
                    t2 = PinyinHelper.toHanyuPinyinStringArray((char)t1[i], (HanyuPinyinOutputFormat)t3);
                    t4 = String.valueOf(t4) + t2[0];
                } else {
                    t4 = String.valueOf(t4) + Character.toString(t1[i]);
                }
                ++i;
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
        }
        return t4;
    }

    public static String getPinYinHeadChar(String str) {
        String convert = "";
        int j = 0;
        while (j < str.length()) {
            char word = str.charAt(j);
            String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)word);
            convert = pinyinArray != null ? String.valueOf(convert) + pinyinArray[0].charAt(0) : String.valueOf(convert) + word;
            ++j;
        }
        return convert;
    }

    public static String getCnASCII(String cnStr) {
        StringBuffer strBuf = new StringBuffer();
        byte[] bGBK = cnStr.getBytes();
        int i = 0;
        while (i < bGBK.length) {
            strBuf.append(Integer.toHexString(bGBK[i] & 0xFF));
            ++i;
        }
        return strBuf.toString();
    }

    public static String converterToFirstSpell(String chines) {
        String pinyinName = "";
        char[] nameChar = chines.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        int i = 0;
        while (i < nameChar.length) {
            if (nameChar[i] > '\u0080') {
                try {
                    pinyinName = String.valueOf(pinyinName) + PinyinHelper.toHanyuPinyinStringArray((char)nameChar[i], (HanyuPinyinOutputFormat)defaultFormat)[0].charAt(0);
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
            } else {
                pinyinName = String.valueOf(pinyinName) + nameChar[i];
            }
            ++i;
        }
        return pinyinName;
    }

    public static String converterToSpell(String chines) {
        String pinyinName = "";
        char[] nameChar = chines.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        int i = 0;
        while (i < nameChar.length) {
            if (nameChar[i] > '\u0080') {
                try {
                    pinyinName = String.valueOf(pinyinName) + PinyinHelper.toHanyuPinyinStringArray((char)nameChar[i], (HanyuPinyinOutputFormat)defaultFormat)[0];
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
            } else {
                pinyinName = String.valueOf(pinyinName) + nameChar[i];
            }
            ++i;
        }
        return pinyinName;
    }

    public static String makeStringByStringSet(Set<String> stringSet) {
        StringBuilder str = new StringBuilder();
        int i = 0;
        for (String s : stringSet) {
            if (i == stringSet.size() - 1) {
                str.append(s);
            } else {
                str.append(String.valueOf(s) + ",");
            }
            ++i;
        }
        return str.toString().toLowerCase();
    }

    public static Set<String> getPinyin(String src) {
        if (src != null && !src.trim().equalsIgnoreCase("")) {
            char[] srcChar = src.toCharArray();
            HanyuPinyinOutputFormat hanYuPinOutputFormat = new HanyuPinyinOutputFormat();
            hanYuPinOutputFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
            hanYuPinOutputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
            hanYuPinOutputFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
            String[][] temp = new String[src.length()][];
            int i = 0;
            while (i < srcChar.length) {
                char c = srcChar[i];
                if (String.valueOf(c).matches("[\\u4E00-\\u9FA5]+")) {
                    try {
                        temp[i] = PinyinHelper.toHanyuPinyinStringArray((char)srcChar[i], (HanyuPinyinOutputFormat)hanYuPinOutputFormat);
                    }
                    catch (BadHanyuPinyinOutputFormatCombination e) {
                        e.printStackTrace();
                    }
                } else {
                    temp[i] = c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' ? new String[]{String.valueOf(srcChar[i])} : new String[]{""};
                }
                ++i;
            }
            String[] pingyinArray = PinyinUtil.Exchange(temp);
            HashSet<String> pinyinSet = new HashSet<String>();
            int i2 = 0;
            while (i2 < pingyinArray.length) {
                pinyinSet.add(pingyinArray[i2]);
                ++i2;
            }
            return pinyinSet;
        }
        return null;
    }

    public static String[] Exchange(String[][] strJaggedArray) {
        String[][] temp = PinyinUtil.DoExchange(strJaggedArray);
        return temp[0];
    }

    private static String[][] DoExchange(String[][] strJaggedArray) {
        int len = strJaggedArray.length;
        if (len >= 2) {
            int len1 = strJaggedArray[0].length;
            int len2 = strJaggedArray[1].length;
            int newlen = len1 * len2;
            String[] temp = new String[newlen];
            int Index = 0;
            int i = 0;
            while (i < len1) {
                int j = 0;
                while (j < len2) {
                    temp[Index] = String.valueOf(strJaggedArray[0][i]) + strJaggedArray[1][j];
                    ++Index;
                    ++j;
                }
                ++i;
            }
            String[][] newArray = new String[len - 1][];
            int i2 = 2;
            while (i2 < len) {
                newArray[i2 - 1] = strJaggedArray[i2];
                ++i2;
            }
            newArray[0] = temp;
            return PinyinUtil.DoExchange(newArray);
        }
        return strJaggedArray;
    }
}

