/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jeecgframework.core.util.ApplicationContextUtil;
import org.jeecgframework.core.util.ListUtils;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ReflectHelper;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.web.system.pojo.base.MutiLangEntity;
import org.jeecgframework.web.system.service.MutiLangServiceI;
import weixin.cms.common.LocaleUtil;
import weixin.cms.entity.WeiXinMutiLangEntity;
import weixin.cms.service.WeiXinMutiLangServiceI;

public class MutiLangUtil {
    private static Log logger = LogFactory.getLog(StringUtil.class);
    public static final Map<String, String> WEIXIN_MUTI_TXT_MAP = new HashMap<String, String>();
    private static MutiLangServiceI mutiLangService;

    public static String paramDelSuccess(String param_lang_key) {
        String message = MutiLangUtil.getMutiLangInstance().getLang("common.delete.success.param", param_lang_key);
        return message;
    }

    public static String paramDelFail(String param_lang_key) {
        String message = MutiLangUtil.getMutiLangInstance().getLang("common.delete.fail.param", param_lang_key);
        return message;
    }

    public static String paramUpdSuccess(String param_lang_key) {
        String message = MutiLangUtil.getMutiLangInstance().getLang("common.edit.success.param", param_lang_key);
        return message;
    }

    public static String paramUpdFail(String param_lang_key) {
        String message = MutiLangUtil.getMutiLangInstance().getLang("common.edit.fail.param", param_lang_key);
        return message;
    }

    public static String paramAddSuccess(String param_lang_key) {
        String message = MutiLangUtil.getMutiLangInstance().getLang("common.add.success.param", param_lang_key);
        return message;
    }

    public static void setMutiTree(List<?> treeList) {
        if (ListUtils.isNullOrEmpty(treeList)) {
            return;
        }
        for (Object treeItem : treeList) {
            ReflectHelper reflectHelper = new ReflectHelper(treeItem);
            String lang_key = (String)reflectHelper.getMethodValue("text");
            String lang_context = MutiLangUtil.getMutiLangInstance().getLang(lang_key);
            reflectHelper.setMethodValue("text", lang_context);
        }
    }

    public static boolean existLangKey(String lang_key) {
        List<MutiLangEntity> langKeyList = MutiLangUtil.getMutiLangInstance().findByProperty(MutiLangEntity.class, "langKey", lang_key);
        return !langKeyList.isEmpty();
    }

    public static boolean existLangContext(String lang_context) {
        List<MutiLangEntity> langContextList = MutiLangUtil.getMutiLangInstance().findByProperty(MutiLangEntity.class, "langContext", lang_context);
        return !langContextList.isEmpty();
    }

    public static MutiLangServiceI getMutiLangInstance() {
        if (mutiLangService == null) {
            mutiLangService = (MutiLangServiceI)ApplicationContextUtil.getContext().getBean(MutiLangServiceI.class);
        }
        return mutiLangService;
    }

    public static String doMutiLang(String lang_key, String langArg) {
        String context = MutiLangUtil.getMutiLangInstance().getLang(lang_key, langArg);
        return context;
    }

    public static String getMutiKeyValue(String langKey, String langArg) {
        String langCode = LocaleUtil.getLocaleLang();
        String key_new = String.valueOf(langKey) + "-" + langCode + "-" + langArg;
        if (WEIXIN_MUTI_TXT_MAP.containsKey(key_new)) {
            return WEIXIN_MUTI_TXT_MAP.get(key_new);
        }
        WeiXinMutiLangServiceI weiXinMutiLangService = (WeiXinMutiLangServiceI)ApplicationContextUtil.getContext().getBean("weiXinMutiLangService");
        WeiXinMutiLangEntity entity = weiXinMutiLangService.queryMutiByKeyAndLang(langKey, langCode);
        String context = "";
        if (entity != null) {
            context = entity.getLangContext();
            Object[] argArray = new String[]{};
            if (langArg != null) {
                argArray = langArg.split(",");
            }
            context = MessageFormat.format(context, argArray);
            WEIXIN_MUTI_TXT_MAP.put(key_new, context);
        }
        return context;
    }

    public static String getMutiKeyValue(String langKey) {
        String langCode = LocaleUtil.getLocaleLang();
        String key_new = String.valueOf(langKey) + "=" + langCode;
        if (WEIXIN_MUTI_TXT_MAP.containsKey(key_new)) {
            return WEIXIN_MUTI_TXT_MAP.get(key_new);
        }
        WeiXinMutiLangServiceI weiXinMutiLangService = (WeiXinMutiLangServiceI)ApplicationContextUtil.getContext().getBean("weiXinMutiLangService");
        WeiXinMutiLangEntity entity = weiXinMutiLangService.queryMutiByKeyAndLang(langKey, langCode);
        String context = "";
        if (entity != null) {
            context = entity.getLangContext();
            Object[] argArray = new String[]{};
            context = MessageFormat.format(context, argArray);
            WEIXIN_MUTI_TXT_MAP.put(key_new, context);
        }
        return context;
    }

    public static void putWeixinMutiTxtMap(String key, String Language, String context) {
        String key_new = String.valueOf(key) + "=" + Language;
        WEIXIN_MUTI_TXT_MAP.put(key_new, context);
    }

    public static String getMutiKeyValueByZH(String langKey, String langArg) {
        String langCode = "ZH";
        String key_new = String.valueOf(langKey) + "-" + langCode + "-" + langArg;
        if (WEIXIN_MUTI_TXT_MAP.containsKey(key_new)) {
            return WEIXIN_MUTI_TXT_MAP.get(key_new);
        }
        WeiXinMutiLangServiceI weiXinMutiLangService = (WeiXinMutiLangServiceI)ApplicationContextUtil.getContext().getBean("weiXinMutiLangService");
        WeiXinMutiLangEntity entity = weiXinMutiLangService.queryMutiByKeyAndLang(langKey, langCode);
        String context = "";
        if (entity != null) {
            context = entity.getLangContext();
            Object[] argArray = new String[]{};
            if (langArg != null) {
                argArray = langArg.split(",");
            }
            context = MessageFormat.format(context, argArray);
            WEIXIN_MUTI_TXT_MAP.put(key_new, context);
        }
        return context;
    }

    public static String getMutiKeyValueByZH(String langKey) {
        String langCode = "ZH";
        String key_new = String.valueOf(langKey) + "=" + langCode;
        if (WEIXIN_MUTI_TXT_MAP.containsKey(key_new)) {
            return WEIXIN_MUTI_TXT_MAP.get(key_new);
        }
        WeiXinMutiLangServiceI weiXinMutiLangService = (WeiXinMutiLangServiceI)ApplicationContextUtil.getContext().getBean("weiXinMutiLangService");
        WeiXinMutiLangEntity entity = weiXinMutiLangService.queryMutiByKeyAndLang(langKey, langCode);
        String context = "";
        if (entity != null) {
            context = entity.getLangContext();
            Object[] argArray = new String[]{};
            context = MessageFormat.format(context, argArray);
            WEIXIN_MUTI_TXT_MAP.put(key_new, context);
        }
        return context;
    }

    public static void setMutiLangValueForList(List<Object> list, String ... attributes) {
        if (ListUtils.isNullOrEmpty(list)) {
            return;
        }
        if (attributes == null && attributes.length == 0) {
            return;
        }
        ArrayList<Object> newList = new ArrayList<Object>();
        for (Object obj : list) {
            Object cloneObj = null;
            try {
                cloneObj = Class.forName(obj.getClass().getName()).newInstance();
                MyBeanUtils.copyBean2Bean(cloneObj, obj);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            ReflectHelper reflectHelper = new ReflectHelper(cloneObj);
            String[] stringArray = attributes;
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                String attribute = stringArray[n2];
                String lang_key = (String)reflectHelper.getMethodValue(attribute);
                String lang_context = MutiLangUtil.getMutiLangInstance().getLang(lang_key);
                reflectHelper.setMethodValue(attribute, lang_context);
                ++n2;
            }
            newList.add(cloneObj);
        }
        list.clear();
        list.addAll(newList);
    }
}

