/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.util;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LogUtil {
    private static final String LOGCONFIG = "log4j.properties";
    private static Logger objLog;

    private static Logger getLogger() {
        if (objLog == null) {
            objLog = LogManager.getLogger(LogUtil.class);
        }
        return objLog;
    }

    private static String getConfigFile() {
        String s = LogUtil.class.getClassLoader().getResource("").toString();
        String filePath = String.valueOf(s) + LOGCONFIG;
        return filePath;
    }

    public static void info(String message, Exception exception) {
        try {
            LogUtil.log("INFO", message, exception);
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    public static void info(Object message) {
        LogUtil.log("INFO", message);
    }

    public static void trace(String message) {
        try {
            LogUtil.log("TRACE", message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void trace(String message, Exception exception) {
        try {
            LogUtil.log("TRACE", message, exception);
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    public static void error(String message, Exception exception) {
        try {
            LogUtil.log("ERROR", message, exception);
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    public static void error(String message) {
        try {
            LogUtil.log("ERROR", message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void warning(String message, Exception exception) {
        try {
            LogUtil.log("WARN", message, exception);
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    public static void warning(String message) {
        try {
            LogUtil.log("WARN", message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void fatal(String message, Exception exception) {
        try {
            LogUtil.log("FATAL", message, exception);
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    public static void fatal(String message) {
        try {
            LogUtil.log("FATAL", message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void debug(String message, Exception exception) {
        try {
            LogUtil.log("DEBUG", message, exception);
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    public static void debug(String message) {
        try {
            LogUtil.log("DEBUG", message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void log(String level, Object msg) {
        LogUtil.log(level, msg, null);
    }

    public static void log(String level, Throwable e) {
        LogUtil.log(level, null, e);
    }

    public static void log(String level, Object msg, Throwable e) {
        try {
            StringBuilder sb = new StringBuilder();
            Throwable t = new Throwable();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            String input = sw.getBuffer().toString();
            StringReader sr = new StringReader(input);
            BufferedReader br = new BufferedReader(sr);
            int i = 0;
            while (i < 4) {
                br.readLine();
                ++i;
            }
            String line = br.readLine();
            int paren = line.indexOf("at ");
            line = line.substring(paren + 3);
            paren = line.indexOf(40);
            String invokeInfo = line.substring(0, paren);
            int period = invokeInfo.lastIndexOf(46);
            sb.append('[');
            sb.append(invokeInfo.substring(0, period));
            sb.append(':');
            sb.append(invokeInfo.substring(period + 1));
            sb.append("():");
            paren = line.indexOf(58);
            period = line.lastIndexOf(41);
            sb.append(line.substring(paren + 1, period));
            sb.append(']');
            sb.append(" - ");
            sb.append(msg);
            LogUtil.getLogger().log((Priority)Level.toLevel((String)level), (Object)sb.toString(), e);
        }
        catch (Exception ex) {
            LogUtil.info(ex.getLocalizedMessage());
        }
    }
}

