/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.util;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jeecgframework.web.system.pojo.base.TSFunction;

public class ListtoMenu {
    static int count = 0;

    public static String getMenu(List<TSFunction> set, List<TSFunction> set1) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{\"menus\":[");
        for (TSFunction node : set) {
            String iconClas = "default";
            if (node.getTSIcon() != null) {
                iconClas = node.getTSIcon().getIconClas();
            }
            buffer.append("{\"menuid\":\"" + node.getId() + "\",\"icon\":\"" + iconClas + "\"," + "\"menuname\":\"" + node.getFunctionName() + "\",\"menus\":[");
            ListtoMenu.iterGet(set1, node.getId(), buffer);
            buffer.append("]},");
        }
        buffer.append("]}");
        String tmp = buffer.toString();
        tmp = tmp.replaceAll(",\n]", "\n]");
        tmp = tmp.replaceAll(",]}", "]}");
        return tmp;
    }

    static void iterGet(List<TSFunction> set1, String pid, StringBuffer buffer) {
        for (TSFunction node : set1) {
            ++count;
            if (!node.getTSFunction().getId().equals(pid)) continue;
            buffer.append("{\"menuid\":\"" + node.getId() + " \",\"icon\":\"" + node.getTSIcon().getIconClas() + "\"," + "\"menuname\":\"" + node.getFunctionName() + "\",\"url\":\"" + node.getFunctionUrl() + "\"");
            if (count == set1.size()) {
                buffer.append("}\n");
            }
            buffer.append("},\n");
        }
    }

    public static String getBootMenu(List<TSFunction> pFunctions, List<TSFunction> functions) {
        StringBuffer menuString = new StringBuffer();
        menuString.append("<ul>");
        for (TSFunction pFunction : pFunctions) {
            menuString.append("<li><a href=\"#\"><span class=\"icon16 icomoon-icon-stats-up\"></span><b>" + pFunction.getFunctionName() + "</b></a>");
            int submenusize = pFunction.getSubFunctionSize();
            if (submenusize == 0) {
                menuString.append("</li>");
            }
            if (submenusize > 0) {
                menuString.append("<ul class=\"sub\">");
            }
            for (TSFunction function : functions) {
                if (!function.getTSFunction().getId().equals(pFunction.getId())) continue;
                menuString.append("<li><a href=\"" + function.getFunctionUrl() + "\" target=\"contentiframe\"><span class=\"icon16 icomoon-icon-file\"></span>" + function.getFunctionName() + "</a></li>");
            }
            if (submenusize <= 0) continue;
            menuString.append("</ul></li>");
        }
        menuString.append("</ul>");
        return menuString.toString();
    }

    public static String getEasyuiMenu(List<TSFunction> pFunctions, List<TSFunction> functions) {
        StringBuffer menuString = new StringBuffer();
        for (TSFunction pFunction : pFunctions) {
            menuString.append("<div  title=\"" + pFunction.getFunctionName() + "\" iconCls=\"" + pFunction.getTSIcon().getIconClas() + "\">");
            int submenusize = pFunction.getSubFunctionSize();
            if (submenusize == 0) {
                menuString.append("</div>");
            }
            if (submenusize > 0) {
                menuString.append("<ul>");
            }
            for (TSFunction function : functions) {
                if (!function.getTSFunction().getId().equals(pFunction.getId())) continue;
                String icon = "folder";
                if (function.getTSIcon() != null) {
                    icon = function.getTSIcon().getIconClas();
                }
                menuString.append("<li><div onclick=\"addTab('" + function.getFunctionName() + "','" + function.getFunctionUrl() + "&clickFunctionId=" + function.getId() + "','" + icon + "')\"  title=\"" + function.getFunctionName() + "\" url=\"" + function.getFunctionUrl() + "\" iconCls=\"" + icon + "\"> <a class=\"" + function.getFunctionName() + "\" href=\"#\" > <span class=\"icon " + icon + "\" >&nbsp;</span> <span class=\"nav\" >" + function.getFunctionName() + "</span></a></div></li>");
            }
            if (submenusize <= 0) continue;
            menuString.append("</ul></div>");
        }
        return menuString.toString();
    }

    public static String getEasyuiMultistageMenu(Map<Integer, List<TSFunction>> map) {
        StringBuffer menuString = new StringBuffer();
        List<TSFunction> list = map.get(0);
        for (TSFunction function : list) {
            menuString.append("<div   title=\"" + function.getFunctionName() + "\" iconCls=\"" + function.getTSIcon().getIconClas() + "\">");
            int submenusize = function.getSubFunctionSize();
            if (submenusize == 0) {
                menuString.append("</div>");
            }
            if (submenusize > 0) {
                menuString.append("<ul>");
            }
            menuString.append(ListtoMenu.getChild(function, 1, map));
            if (submenusize <= 0) continue;
            menuString.append("</ul></div>");
        }
        return menuString.toString();
    }

    public static String getEasyuiMultistageTree(Map<Integer, List<TSFunction>> map, String style) {
        StringBuffer menuString;
        block11: {
            List<TSFunction> list;
            block10: {
                if (map == null || map.size() == 0 || !map.containsKey(0)) {
                    return "\u4e0d\u5177\u6709\u4efb\u4f55\u6743\u9650,\n\u8bf7\u627e\u7ba1\u7406\u5458\u5206\u914d\u6743\u9650";
                }
                menuString = new StringBuffer();
                list = map.get(0);
                int curIndex = 0;
                if (!"easyui".equals(style)) break block10;
                for (TSFunction function : list) {
                    if (curIndex == 0) {
                        menuString.append("<li>");
                    } else {
                        menuString.append("<li state='closed'>");
                    }
                    menuString.append("<span>").append(function.getFunctionName()).append("</span>");
                    int submenusize = function.getSubFunctionSize();
                    if (submenusize == 0) {
                        menuString.append("</li>");
                    }
                    if (submenusize > 0) {
                        menuString.append("<ul>");
                    }
                    menuString.append(ListtoMenu.getChildOfTree(function, 1, map));
                    if (submenusize > 0) {
                        menuString.append("</ul></li>");
                    }
                    ++curIndex;
                }
                break block11;
            }
            if (!"shortcut".equals(style)) break block11;
            for (TSFunction function : list) {
                menuString.append("<div   title=\"" + function.getFunctionName() + "\" iconCls=\"" + function.getTSIcon().getIconClas() + "\">");
                int submenusize = function.getSubFunctionSize();
                if (submenusize == 0) {
                    menuString.append("</div>");
                }
                if (submenusize > 0) {
                    menuString.append("<ul class=\"easyui-tree tree-lines\"  fit=\"false\" border=\"false\">");
                }
                menuString.append(ListtoMenu.getChildOfTree(function, 1, map));
                if (submenusize <= 0) continue;
                menuString.append("</ul></div>");
            }
        }
        return menuString.toString();
    }

    private static String getChild(TSFunction parent, int level, Map<Integer, List<TSFunction>> map) {
        StringBuffer menuString = new StringBuffer();
        List<TSFunction> list = map.get(level);
        for (TSFunction function : list) {
            if (!function.getTSFunction().getId().equals(parent.getId())) continue;
            if (function.getSubFunctionSize() == 0 || !map.containsKey(level + 1)) {
                menuString.append(ListtoMenu.getLeaf(function));
                continue;
            }
            if (!map.containsKey(level + 1)) continue;
            menuString.append("<div  class=\"easyui-accordion\"  fit=\"false\" border=\"false\">");
            menuString.append("<div></div>");
            menuString.append("<div title=\"" + function.getFunctionName() + "\" iconCls=\"" + function.getTSIcon().getIconClas() + "\"><ul>");
            menuString.append(ListtoMenu.getChild(function, level + 1, map));
            menuString.append("</ul></div>");
            menuString.append("</div>");
        }
        return menuString.toString();
    }

    private static String getChildOfTree(TSFunction parent, int level, Map<Integer, List<TSFunction>> map) {
        StringBuffer menuString = new StringBuffer();
        List<TSFunction> list = map.get(level);
        for (TSFunction function : list) {
            if (!function.getTSFunction().getId().equals(parent.getId())) continue;
            if (function.getSubFunctionSize() == 0 || !map.containsKey(level + 1)) {
                menuString.append(ListtoMenu.getLeafOfTree(function));
                continue;
            }
            if (!map.containsKey(level + 1)) continue;
            menuString.append("<li state=\"closed\" iconCls=\"" + function.getTSIcon().getIconClas() + "\" ><span>" + function.getFunctionName() + "</span>");
            menuString.append("<ul >");
            menuString.append(ListtoMenu.getChildOfTree(function, level + 1, map));
            menuString.append("</ul></li>");
        }
        return menuString.toString();
    }

    private static String getLeaf(TSFunction function) {
        StringBuffer menuString = new StringBuffer();
        String icon = "folder";
        if (function.getTSIcon() != null) {
            icon = function.getTSIcon().getIconClas();
        }
        menuString.append("<li><div onclick=\"addTab('");
        menuString.append(function.getFunctionName());
        menuString.append("','");
        menuString.append(function.getFunctionUrl());
        menuString.append("&clickFunctionId=");
        menuString.append(function.getId());
        menuString.append("','");
        menuString.append(icon);
        menuString.append("')\"  title=\"");
        menuString.append(function.getFunctionName());
        menuString.append("\" url=\"");
        menuString.append(function.getFunctionUrl());
        menuString.append("\" iconCls=\"");
        menuString.append(icon);
        menuString.append("\"> <a class=\"");
        menuString.append(function.getFunctionName());
        menuString.append("\" href=\"#\" > <span class=\"icon ");
        menuString.append(icon);
        menuString.append("\" >&nbsp;</span> <span class=\"nav\" >");
        menuString.append(function.getFunctionName());
        menuString.append("</span></a></div></li>");
        return menuString.toString();
    }

    private static String getLeafOfTree(TSFunction function) {
        StringBuffer menuString = new StringBuffer();
        String icon = "folder";
        if (function.getTSIcon() != null) {
            icon = function.getTSIcon().getIconClas();
        }
        menuString.append("<li iconCls=\"");
        menuString.append(icon);
        menuString.append("\"> <a onclick=\"addTab('");
        menuString.append(function.getFunctionName());
        menuString.append("','");
        menuString.append(function.getFunctionUrl());
        if (function.getFunctionUrl().indexOf("http:") == -1) {
            menuString.append("&clickFunctionId=");
            menuString.append(function.getId());
        }
        menuString.append("','");
        menuString.append(icon);
        menuString.append("')\"  title=\"");
        menuString.append(function.getFunctionName());
        menuString.append("\" url=\"");
        menuString.append(function.getFunctionUrl());
        menuString.append("\" href=\"#\" ><span class=\"nav\" >");
        menuString.append(function.getFunctionName());
        menuString.append("</span></a></li>");
        return menuString.toString();
    }

    public static String getBootstrapMenu(Map<Integer, List<TSFunction>> map) {
        StringBuffer menuString = new StringBuffer();
        menuString.append("<ul class=\"nav\">");
        List<TSFunction> pFunctions = map.get(0);
        if (pFunctions == null || pFunctions.size() == 0) {
            return "";
        }
        for (TSFunction pFunction : pFunctions) {
            boolean hasSub = pFunction.getSubFunctionSize() != 0;
            menuString.append("\t<li class=\"dropdown\"> ");
            menuString.append("\t\t<a href=\"javascript:;\" class=\"dropdown-toggle\" data-toggle=\"dropdown\"> ");
            menuString.append("\t\t\t<span class=\"bootstrap-icon\" style=\"background-image: url('" + pFunction.getTSIcon().getIconPath() + "')\"></span> " + pFunction.getFunctionName() + " ");
            if (hasSub) {
                menuString.append("\t\t\t<b class=\"caret\"></b> ");
            }
            menuString.append("\t\t</a> ");
            if (hasSub) {
                menuString.append(ListtoMenu.getBootStrapChild(pFunction, 1, map));
            }
            menuString.append("\t</li> ");
        }
        menuString.append("</ul>");
        return menuString.toString();
    }

    private static String getBootStrapChild(TSFunction parent, int level, Map<Integer, List<TSFunction>> map) {
        StringBuffer menuString = new StringBuffer();
        List<TSFunction> list = map.get(level);
        if (list == null || list.size() == 0) {
            return "";
        }
        menuString.append("\t\t<ul class=\"dropdown-menu\"> ");
        for (TSFunction function : list) {
            if (!function.getTSFunction().getId().equals(parent.getId())) continue;
            boolean hasSub = function.getSubFunctionSize() != 0 && map.containsKey(level + 1);
            String menu_url = function.getFunctionUrl();
            if (StringUtils.isNotEmpty((String)menu_url)) {
                menu_url = String.valueOf(menu_url) + "&clickFunctionId=" + function.getId();
            }
            menuString.append("\t\t<li onclick=\"showContent('" + function.getFunctionName() + "','" + menu_url + "')\"  title=\"" + function.getFunctionName() + "\" url=\"" + function.getFunctionUrl() + "\" ");
            if (hasSub) {
                menuString.append(" class=\"dropdown-submenu\"");
            }
            menuString.append(" > ");
            menuString.append("\t\t\t<a href=\"javascript:;\"> ");
            menuString.append("\t\t\t\t<span class=\"bootstrap-icon\" style=\"background-image: url('" + function.getTSIcon().getIconPath() + "')\"></span>\t\t ");
            menuString.append(function.getFunctionName());
            menuString.append("\t\t\t</a> ");
            if (hasSub) {
                menuString.append(ListtoMenu.getBootStrapChild(function, level + 1, map));
            }
            menuString.append("\t\t</li> ");
        }
        menuString.append("\t\t</ul> ");
        return menuString.toString();
    }

    public static String getWebosMenu(Map<Integer, List<TSFunction>> map) {
        StringBuffer menuString = new StringBuffer();
        StringBuffer DeskpanelString = new StringBuffer();
        StringBuffer dataString = new StringBuffer();
        String menu = "";
        String desk = "";
        String data = "";
        menuString.append("{");
        dataString.append("{app:{");
        DeskpanelString.append("{");
        List<TSFunction> pFunctions = map.get(0);
        if (pFunctions == null || pFunctions.size() == 0) {
            return "";
        }
        int n = 1;
        for (TSFunction pFunction : pFunctions) {
            boolean hasSub = pFunction.getSubFunctionSize() != 0;
            menuString.append("\"" + pFunction.getId() + "\":");
            menuString.append("{\"id\":\"" + pFunction.getId() + "\",\"name\":\"" + pFunction.getFunctionName() + "\",\"path\":\"" + pFunction.getTSIcon().getIconPath() + "\",\"level\":\"" + pFunction.getFunctionLevel() + "\",");
            menuString.append("\"child\":{");
            DeskpanelString.append("Icon" + n + ":[");
            if (hasSub) {
                DeskpanelString.append(ListtoMenu.getWebosDeskpanelChild(pFunction, 1, map));
                dataString.append(ListtoMenu.getWebosDataChild(pFunction, 1, map));
            }
            DeskpanelString.append("],");
            menuString.append("}},");
            ++n;
        }
        menu = menuString.substring(0, menuString.toString().length() - 1);
        menu = String.valueOf(menu) + "}";
        data = dataString.substring(0, dataString.toString().length() - 1);
        data = String.valueOf(data) + "}}";
        desk = DeskpanelString.substring(0, DeskpanelString.toString().length() - 1);
        desk = String.valueOf(desk) + "}";
        return String.valueOf(menu) + "$$" + desk + "$$" + data + "$$" + --n;
    }

    private static String getWebosChild(TSFunction parent, int level, Map<Integer, List<TSFunction>> map) {
        StringBuffer menuString = new StringBuffer();
        String menu = "";
        List<TSFunction> list = map.get(level);
        if (list == null || list.size() == 0) {
            return "";
        }
        for (TSFunction function : list) {
            if (!function.getTSFunction().getId().equals(parent.getId())) continue;
            boolean hasSub = function.getSubFunctionSize() != 0 && map.containsKey(level + 1);
            menuString.append("\"" + function.getId() + "\":");
            menuString.append("{\"id\":\"" + function.getId() + "\",\"name\":\"" + function.getFunctionName() + "\",\"path\":\"" + function.getTSIcon().getIconPath() + "\",\"url\":\"" + function.getFunctionUrl() + "\",\"level\":\"" + function.getFunctionLevel() + "\"}");
            if (hasSub) {
                menuString.append("\"child\":{");
                menuString.append(ListtoMenu.getWebosChild(function, level + 1, map));
                menuString.append("\t} ");
            }
            menuString.append(",");
        }
        menu = menuString.substring(0, menuString.toString().length() - 1);
        return menu;
    }

    private static String getWebosDeskpanelChild(TSFunction parent, int level, Map<Integer, List<TSFunction>> map) {
        StringBuffer DeskpanelString = new StringBuffer();
        String desk = "";
        List<TSFunction> list = map.get(level);
        if (list == null || list.size() == 0) {
            return "";
        }
        for (TSFunction function : list) {
            if (!function.getTSFunction().getId().equals(parent.getId())) continue;
            DeskpanelString.append("'" + function.getId() + "',");
        }
        desk = DeskpanelString.substring(0, DeskpanelString.toString().length() - 1);
        return desk;
    }

    private static String getWebosDataChild(TSFunction parent, int level, Map<Integer, List<TSFunction>> map) {
        StringBuffer dataString = new StringBuffer();
        String data = "";
        List<TSFunction> list = map.get(level);
        if (list == null || list.size() == 0) {
            return "";
        }
        for (TSFunction function : list) {
            if (!function.getTSFunction().getId().equals(parent.getId())) continue;
            dataString.append("'" + function.getId() + "':{ ");
            dataString.append("appid:'" + function.getId() + "',");
            dataString.append("url:'" + function.getFunctionUrl() + "',");
            dataString.append(ListtoMenu.getIconAndNameForDesk(function));
            dataString.append("asc :" + function.getFunctionOrder());
            dataString.append(" },");
        }
        data = dataString.toString();
        return data;
    }

    private static String getIconAndNameForDesk(TSFunction function) {
        StringBuffer dataString = new StringBuffer();
        String colName = function.getTSIconDesk() == null ? null : function.getTSIconDesk().getIconPath();
        colName = colName == null || colName.equals("") ? "plug-in/sliding/icon/default.png" : colName;
        String functionName = function.getFunctionName();
        dataString.append("icon:'" + colName + "',");
        dataString.append("name:'" + functionName + "',");
        return dataString.toString();
    }

    @Deprecated
    private static String getIconandName(String functionName) {
        StringBuffer dataString = new StringBuffer();
        if ("online\u5f00\u53d1".equals(functionName)) {
            dataString.append("icon:'Customize.png',");
        } else if ("\u8868\u5355\u914d\u7f6e".equals(functionName)) {
            dataString.append("icon:'Applications Folder.png',");
        } else if ("\u52a8\u6001\u8868\u5355\u914d\u7f6e".equals(functionName)) {
            dataString.append("icon:'Documents Folder.png',");
        } else if ("\u7528\u6237\u5206\u6790".equals(functionName)) {
            dataString.append("icon:'User.png',");
        } else if ("\u62a5\u8868\u5206\u6790".equals(functionName)) {
            dataString.append("icon:'Burn.png',");
        } else if ("\u7528\u6237\u7ba1\u7406".equals(functionName)) {
            dataString.append("icon:'Finder.png',");
        } else if ("\u6570\u636e\u5b57\u5178".equals(functionName)) {
            dataString.append("icon:'friendnear.png',");
        } else if ("\u89d2\u8272\u7ba1\u7406".equals(functionName)) {
            dataString.append("icon:'friendgroup.png',");
        } else if ("\u83dc\u5355\u7ba1\u7406".equals(functionName)) {
            dataString.append("icon:'kaikai.png',");
        } else if ("\u56fe\u6807\u7ba1\u7406".equals(functionName)) {
            dataString.append("icon:'kxjy.png',");
        } else if ("\u8868\u5355\u9a8c\u8bc1".equals(functionName)) {
            dataString.append("icon:'qidianzhongwen.png',");
        } else if ("\u4e00\u5bf9\u591a\u6a21\u578b".equals(functionName)) {
            dataString.append("icon:'qqread.png',");
        } else if ("\u7279\u6b8a\u5e03\u5c40".equals(functionName)) {
            dataString.append("icon:'xiami.png',");
        } else if ("\u5728\u7ebfword".equals(functionName)) {
            dataString.append("icon:'musicbox.png',");
        } else if ("\u591a\u9644\u4ef6\u7ba1\u7406".equals(functionName)) {
            dataString.append("icon:'vadio.png',");
        } else if ("\u6570\u636e\u76d1\u63a7".equals(functionName)) {
            dataString.append("icon:'Super Disk.png',");
        } else if ("\u5b9a\u65f6\u4efb\u52a1".equals(functionName)) {
            dataString.append("icon:'Utilities.png',");
        } else if ("\u7cfb\u7edf\u65e5\u5fd7".equals(functionName)) {
            dataString.append("icon:'fastsearch.png',");
        } else if ("\u5728\u7ebf\u7ef4\u62a4".equals(functionName)) {
            dataString.append("icon:'Utilities Folder.png',");
        } else {
            dataString.append("icon:'folder_o.png',");
        }
        dataString.append("name:'" + functionName + "',");
        return dataString.toString();
    }
}

