/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ResourceBundle;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.jeecgframework.core.util.LogUtil;

public class JeecgSqlUtil {
    private static final String KEY_01 = "service";
    private static final String KEY_02 = "impl";
    private static final String KEY_03 = "Impl.";
    private static final String PACKAGE_SQL = "sql";
    private static final String SUFFIX_SQL = ".sql";
    private static final String SUFFIX_D = ".";
    private static final String SUFFIX_X = "/";
    private static final ResourceBundle bundle = ResourceBundle.getBundle("sysConfig");
    private static Cache dictCache;

    static {
        if (dictCache == null) {
            dictCache = CacheManager.getInstance().getCache("dictCache");
        }
    }

    private static String loadStringFromFile(File file) throws IOException {
        return JeecgSqlUtil.loadStringFromFile(file, "UTF-8");
    }

    private static String loadStringFromFile(File file, String encoding) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
            StringBuilder builder = new StringBuilder();
            char[] chars = new char[4096];
            int length = 0;
            while ((length = reader.read(chars)) > 0) {
                builder.append(chars, 0, length);
            }
            String string = builder.toString();
            return string;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static String getFlieTxt(String fileUrl) {
        LogUtil.info("---------------------------------------sql \u8def\u5f84 :" + fileUrl);
        String sql = null;
        try {
            sql = JeecgSqlUtil.loadStringFromFile(new File(fileUrl));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sql;
    }

    public static String getMethodSql(String methodUrl) {
        if ("DEV".equals(bundle.getObject("sqlReadMode"))) {
            return JeecgSqlUtil.getMethodSqlLogicJar(methodUrl);
        }
        if ("PUB".equals(bundle.getObject("sqlReadMode"))) {
            Element element = dictCache.get((Serializable)((Object)methodUrl));
            if (element == null) {
                element = new Element((Serializable)((Object)methodUrl), (Serializable)((Object)JeecgSqlUtil.getMethodSqlLogicJar(methodUrl)));
                dictCache.put(element);
            }
            return element.getValue().toString();
        }
        return "";
    }

    public static String getMethodSqlLogic(String methodUrl) {
        String head = methodUrl.substring(0, methodUrl.indexOf(KEY_01));
        String end = methodUrl.substring(methodUrl.indexOf(KEY_02) + KEY_02.length()).replace(KEY_03, "_");
        String sqlurl = String.valueOf(head) + PACKAGE_SQL + end;
        sqlurl = sqlurl.replace(SUFFIX_D, SUFFIX_X);
        sqlurl = String.valueOf(sqlurl) + SUFFIX_SQL;
        String projectPath = JeecgSqlUtil.getAppPath(JeecgSqlUtil.class);
        sqlurl = String.valueOf(projectPath) + SUFFIX_X + sqlurl;
        LogUtil.info(sqlurl);
        return JeecgSqlUtil.getFlieTxt(sqlurl);
    }

    public static String getMethodSqlLogicJar(String methodUrl) {
        StringBuffer sb = new StringBuffer();
        String head = methodUrl.substring(0, methodUrl.indexOf(KEY_01));
        String end = methodUrl.substring(methodUrl.indexOf(KEY_02) + KEY_02.length()).replace(KEY_03, "_");
        String sqlurl = String.valueOf(head) + PACKAGE_SQL + end;
        sqlurl = sqlurl.replace(SUFFIX_D, SUFFIX_X);
        sqlurl = SUFFIX_X + sqlurl + SUFFIX_SQL;
        InputStream is = JeecgSqlUtil.class.getResourceAsStream(sqlurl);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String s = "";
        try {
            while ((s = br.readLine()) != null) {
                sb.append(String.valueOf(s) + " ");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    @Deprecated
    public static String getMethodSqlLogicOld(String methodUrl) {
        methodUrl = methodUrl.substring(17).replace("Impl", "").replace(SUFFIX_D, SUFFIX_X);
        String[] str = methodUrl.split(SUFFIX_X);
        StringBuffer sb = new StringBuffer();
        int num = 2;
        int length = str.length;
        String[] stringArray = str;
        int n = str.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (num < length) {
                sb.append(s);
                sb.append(SUFFIX_X);
            } else if (num == length) {
                sb.append(s);
                sb.append("_");
            } else {
                sb.append(s);
            }
            ++num;
            ++n2;
        }
        String projectPath = JeecgSqlUtil.getAppPath(JeecgSqlUtil.class);
        String fileUrl = String.valueOf(projectPath) + "/sun/sql/" + sb.toString() + SUFFIX_SQL;
        return JeecgSqlUtil.getFlieTxt(fileUrl);
    }

    public static String getAppPath(Class cls) {
        URL url;
        String realPath;
        int pos;
        if (cls == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ClassLoader loader = cls.getClassLoader();
        String clsName = String.valueOf(cls.getName()) + ".class";
        Package pack = cls.getPackage();
        String path = "";
        if (pack != null) {
            String packName = pack.getName();
            if (packName.startsWith("java.") || packName.startsWith("javax.")) {
                throw new IllegalArgumentException("\u4e0d\u8981\u4f20\u9001\u7cfb\u7edf\u7c7b\uff01");
            }
            clsName = clsName.substring(packName.length() + 1);
            if (packName.indexOf(SUFFIX_D) < 0) {
                path = String.valueOf(packName) + SUFFIX_X;
            } else {
                int start = 0;
                int end = 0;
                end = packName.indexOf(SUFFIX_D);
                while (end != -1) {
                    path = String.valueOf(path) + packName.substring(start, end) + SUFFIX_X;
                    start = end + 1;
                    end = packName.indexOf(SUFFIX_D, start);
                }
                path = String.valueOf(path) + packName.substring(start) + SUFFIX_X;
            }
        }
        if ((pos = (realPath = (url = loader.getResource(String.valueOf(path) + clsName)).getPath()).indexOf("file:")) > -1) {
            realPath = realPath.substring(pos + 5);
        }
        if ((realPath = realPath.substring(0, (pos = realPath.indexOf(String.valueOf(path) + clsName)) - 1)).endsWith("!")) {
            realPath = realPath.substring(0, realPath.lastIndexOf(SUFFIX_X));
        }
        try {
            realPath = URLDecoder.decode(realPath, "utf-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LogUtil.info("realPath----->" + realPath);
        return realPath;
    }

    public static String getMethodUrl() {
        StringBuffer sb = new StringBuffer();
        StackTraceElement[] stacks = new Throwable().getStackTrace();
        sb.append(stacks[1].getClassName()).append(SUFFIX_D).append(stacks[1].getMethodName());
        return sb.toString();
    }

    public static void main(String[] args) {
        LogUtil.info(JeecgSqlUtil.getCountSqlBySql("SELECT * \tfrom JEECG_DICT_PARAM WHERE 1=1"));
    }

    public static String getCountSqlBySql(String sql) {
        String countSql = "SELECT COUNT(*)  ";
        String upperSql = sql.toUpperCase();
        int fromIndex = upperSql.indexOf("FROM");
        int whereIndex = upperSql.indexOf("WHERE");
        countSql = whereIndex > -1 ? String.valueOf(countSql) + sql.substring(fromIndex, whereIndex) : String.valueOf(countSql) + sql.substring(fromIndex);
        return countSql;
    }
}

