/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.oConvertUtils;

public class FileUtils {
    private static final Logger logger = Logger.getLogger(FileUtils.class);

    public static String getExtend(String filename) {
        return FileUtils.getExtend(filename, "");
    }

    public static String getExtend(String filename, String defExt) {
        int i;
        if (filename != null && filename.length() > 0 && (i = filename.lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return defExt.toLowerCase();
    }

    public static String getFilePrefix(String fileName) {
        int splitIndex = fileName.lastIndexOf(".");
        return fileName.substring(0, splitIndex).replaceAll("\\s*", "");
    }

    public static String getFilePrefix2(String fileName) {
        int splitIndex = fileName.lastIndexOf(".");
        return fileName.substring(0, splitIndex);
    }

    public static void copyFile(String inputFile, String outputFile) throws FileNotFoundException {
        File sFile = new File(inputFile);
        File tFile = new File(outputFile);
        FileInputStream fis = new FileInputStream(sFile);
        FileOutputStream fos = new FileOutputStream(tFile);
        int temp = 0;
        byte[] buf = new byte[10240];
        try {
            try {
                while ((temp = fis.read(buf)) != -1) {
                    fos.write(buf, 0, temp);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    fis.close();
                    fos.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                fis.close();
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isPicture(String filename) {
        if (oConvertUtils.isEmpty(filename)) {
            return false;
        }
        String tmpName = filename;
        String[][] imgeArray = new String[][]{{"bmp", "0"}, {"dib", "1"}, {"gif", "2"}, {"jfif", "3"}, {"jpe", "4"}, {"jpeg", "5"}, {"jpg", "6"}, {"png", "7"}, {"tif", "8"}, {"tiff", "9"}, {"ico", "10"}};
        int i = 0;
        while (i < imgeArray.length) {
            if (imgeArray[i][0].equals(tmpName.toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isDwg(String filename) {
        if (oConvertUtils.isEmpty(filename)) {
            return false;
        }
        String tmpName = FileUtils.getExtend(filename);
        return tmpName.equals("dwg");
    }

    public static boolean delete(String strFileName) {
        File fileDelete = new File(strFileName);
        if (!fileDelete.exists() || !fileDelete.isFile()) {
            LogUtil.info("\u9519\u8bef: " + strFileName + "\u4e0d\u5b58\u5728!");
            return false;
        }
        LogUtil.info("--------\u6210\u529f\u5220\u9664\u6587\u4ef6---------" + strFileName);
        return fileDelete.delete();
    }
}

