/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.util;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

public class EhcacheUtil {
    public static String cacheName_dictCache = "dictCache";
    public static String cacheName_eternalCache = "eternalCache";
    public static CacheManager manager = CacheManager.create();

    public static Object getDictCache(Object key) {
        Element element;
        Cache cache = manager.getCache(cacheName_dictCache);
        if (cache != null && (element = cache.get(key)) != null) {
            return element.getObjectValue();
        }
        return null;
    }

    public static void putDictCache(Object key, Object value) {
        Cache cache = manager.getCache(cacheName_dictCache);
        if (cache != null) {
            cache.put(new Element(key, value));
        }
    }

    public static boolean removeDictCache(Object key) {
        Cache cache = manager.getCache(cacheName_dictCache);
        if (cache != null) {
            return cache.remove(key);
        }
        return false;
    }

    public static Object get(String cacheName, Object key) {
        Element element;
        Cache cache = manager.getCache(cacheName);
        if (cache != null && (element = cache.get(key)) != null) {
            return element.getObjectValue();
        }
        return null;
    }

    public static void put(String cacheName, Object key, Object value) {
        Cache cache = manager.getCache(cacheName);
        if (cache != null) {
            cache.put(new Element(key, value));
        }
    }

    public static boolean remove(String cacheName, Object key) {
        Cache cache = manager.getCache(cacheName);
        if (cache != null) {
            return cache.remove(key);
        }
        return false;
    }

    public static Object getEternalCache(Object key) {
        Element element;
        Cache cache = manager.getCache(cacheName_eternalCache);
        if (cache != null && (element = cache.get(key)) != null) {
            return element.getObjectValue();
        }
        return null;
    }

    public static void putEternalCache(Object key, Object value) {
        Cache cache = manager.getCache(cacheName_eternalCache);
        if (cache != null) {
            cache.put(new Element(key, value));
        }
    }

    public static void main(String[] args) {
        String key = "key";
        String value = "hello";
        EhcacheUtil.put("mytest", key, value);
        System.out.println(EhcacheUtil.get("mytest", key));
    }
}

