/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.util;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.jeecgframework.core.util.ListUtils;
import org.jeecgframework.web.system.pojo.base.DynamicDataSourceEntity;
import org.springframework.jdbc.core.JdbcTemplate;

public class DynamicDBUtil {
    private static final Logger logger = Logger.getLogger(DynamicDBUtil.class);

    private static BasicDataSource getDataSource(DynamicDataSourceEntity dynamicSourceEntity) {
        BasicDataSource dataSource = new BasicDataSource();
        String driverClassName = dynamicSourceEntity.getDriverClass();
        String url = dynamicSourceEntity.getUrl();
        String dbUser = dynamicSourceEntity.getDbUser();
        String dbPassword = dynamicSourceEntity.getDbPassword();
        dataSource.setDriverClassName(driverClassName);
        dataSource.setUrl(url);
        dataSource.setUsername(dbUser);
        dataSource.setPassword(dbPassword);
        return dataSource;
    }

    private static JdbcTemplate getJdbcTemplate(String dbKey) {
        DynamicDataSourceEntity dynamicSourceEntity = DynamicDataSourceEntity.DynamicDataSourceMap.get(dbKey);
        BasicDataSource dataSource = DynamicDBUtil.getDataSource(dynamicSourceEntity);
        JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
        return jdbcTemplate;
    }

    private static JdbcTemplate getJdbcTemplate(DynamicDataSourceEntity dynamicSourceEntity) {
        BasicDataSource dataSource = DynamicDBUtil.getDataSource(dynamicSourceEntity);
        JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
        return jdbcTemplate;
    }

    public static int update(String dbKey, String sql, Object ... param) {
        int effectCount = 0;
        JdbcTemplate jdbcTemplate = DynamicDBUtil.getJdbcTemplate(dbKey);
        effectCount = ArrayUtils.isEmpty((Object[])param) ? jdbcTemplate.update(sql) : jdbcTemplate.update(sql, param);
        return effectCount;
    }

    public static Object findOne(String dbKey, String sql, Object ... param) {
        JdbcTemplate jdbcTemplate = DynamicDBUtil.getJdbcTemplate(dbKey);
        List list = ArrayUtils.isEmpty((Object[])param) ? jdbcTemplate.queryForList(sql) : jdbcTemplate.queryForList(sql, param);
        if (ListUtils.isNullOrEmpty(list)) {
            logger.error((Object)"Except one, but not find actually");
        }
        if (list.size() > 1) {
            logger.error((Object)"Except one, but more than one actually");
        }
        return list.get(0);
    }

    public static List<Map<String, Object>> findList(String dbKey, String sql, Object ... param) {
        JdbcTemplate jdbcTemplate = DynamicDBUtil.getJdbcTemplate(dbKey);
        List list = ArrayUtils.isEmpty((Object[])param) ? jdbcTemplate.queryForList(sql) : jdbcTemplate.queryForList(sql, param);
        return list;
    }

    public static void main(String[] args) {
        DynamicDataSourceEntity dynamicSourceEntity = new DynamicDataSourceEntity();
        String dbKey = "SAP_DB";
        String driverClassName = "oracle.jdbc.driver.OracleDriver";
        String url = "jdbc:oracle:thin:@10.10.0.59:1521:mid";
        String dbUser = "CRM";
        String dbPassword = "CRM2013";
        dynamicSourceEntity.setDbKey(dbKey);
        dynamicSourceEntity.setDriverClass(driverClassName);
        dynamicSourceEntity.setUrl(url);
        dynamicSourceEntity.setDbUser(dbUser);
        dynamicSourceEntity.setDbPassword(dbPassword);
        JdbcTemplate jdbcTemplate = DynamicDBUtil.getJdbcTemplate(dynamicSourceEntity);
        String sql = "select ak.VKBUR, ak.KUNNR, ak.BSTNK, ak.VBELN, ak.MAHDT, ak.BSTDK from VBAK ak where ak.VKORG = '6002'";
    }
}

