/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.timer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.text.ParseException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.quartz.CronTrigger;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.springframework.stereotype.Service;

@Service(value="dynamicTask")
public class DynamicTask {
    private static Logger logger = Logger.getLogger(DynamicTask.class);
    @Resource
    private Scheduler schedulerFactory;

    public boolean startOrStop(String triggerName, boolean start) {
        try {
            CronTrigger trigger = (CronTrigger)this.getTrigger(triggerName, "DEFAULT");
            if (start) {
                this.schedulerFactory.resumeTrigger(trigger.getName(), trigger.getGroup());
                logger.info((Object)"trigger the start successfully!!");
            } else {
                this.schedulerFactory.pauseTrigger(trigger.getName(), trigger.getGroup());
                logger.info((Object)"trigger the pause successfully!!");
            }
            return true;
        }
        catch (SchedulerException e) {
            logger.error((Object)("Fail to reschedule. " + (Object)((Object)e)));
            return false;
        }
    }

    public boolean updateCronExpression(String triggerName, String cronExpression) {
        CronTrigger trigger;
        block6: {
            block5: {
                trigger = (CronTrigger)this.getTrigger(triggerName, "DEFAULT");
                if (trigger != null) break block5;
                return false;
            }
            if (!StringUtils.equals((String)trigger.getCronExpression(), (String)cronExpression)) break block6;
            logger.info((Object)"cronExpression is same with the running Schedule , no need to update.");
            return true;
        }
        try {
            trigger.setCronExpression(cronExpression);
            this.schedulerFactory.rescheduleJob(trigger.getName(), trigger.getGroup(), (Trigger)trigger);
            DynamicTask.updateSpringMvcTaskXML(trigger, cronExpression);
            logger.info((Object)"Update the cronExpression successfully!!");
            return true;
        }
        catch (ParseException e) {
            logger.error((Object)("The new cronExpression - " + cronExpression + " not conform to the standard. " + e));
            return false;
        }
        catch (SchedulerException e) {
            logger.error((Object)("Fail to reschedule. " + (Object)((Object)e)));
            return false;
        }
    }

    private Trigger getTrigger(String triggerName, String groupName) {
        Trigger trigger = null;
        if (StringUtils.isBlank((String)groupName)) {
            logger.warn((Object)"Schedule Job Group is empty!");
            return null;
        }
        if (StringUtils.isBlank((String)triggerName)) {
            logger.warn((Object)"Schedule trigger Name is empty!");
            return null;
        }
        try {
            trigger = this.schedulerFactory.getTrigger(triggerName, groupName);
        }
        catch (SchedulerException e) {
            logger.warn((Object)("Fail to get the trigger (triggerName: " + triggerName + ", groupName : " + groupName + ")"));
            return null;
        }
        if (trigger == null) {
            logger.warn((Object)("Can not found the trigger of triggerName: " + triggerName + ", groupName : " + groupName));
        }
        return trigger;
    }

    public static synchronized void updateSpringMvcTaskXML(CronTrigger trigger, String cronExpression) {
        Document document = null;
        File file = null;
        SAXReader saxReader = new SAXReader();
        try {
            URI url = DynamicTask.class.getClassLoader().getResource("spring-mvc-timeTask.xml").toURI();
            file = new File(url.getPath());
            document = saxReader.read((InputStream)new FileInputStream(file));
        }
        catch (Exception e) {
            logger.error((Object)"\u8bfb\u53d6\u7cfb\u7edf\u4e2d\u7528\u5230\u7684SQL \u8bed\u53e5XML\u51fa\u9519");
            throw new RuntimeException("---------\u8bfb\u53d6spring-mvc-timeTask.xml\u6587\u4ef6\u51fa\u9519:" + e.getMessage());
        }
        Element root = document.getRootElement();
        List beans = root.elements();
        block13: for (Element bean : beans) {
            if (bean.attribute("id") == null || !bean.attribute("id").getValue().equals(trigger.getName())) continue;
            beans = bean.elements();
            for (Element temp : beans) {
                if (temp.attribute("name") == null || !temp.attribute("name").getValue().equals("cronExpression")) continue;
                temp.attribute("value").setValue(cronExpression);
                break block13;
            }
        }
        XMLWriter fileWriter = null;
        try {
            try {
                OutputFormat xmlFormat = OutputFormat.createPrettyPrint();
                xmlFormat.setEncoding("utf-8");
                fileWriter = new XMLWriter((OutputStream)new FileOutputStream(file), xmlFormat);
                fileWriter.write(document);
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    fileWriter.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                fileWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

