/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.interceptors;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.core.wxRule.impl.RemoteWeixinMethod;

public class WeixinAuthor2Interceptor
implements HandlerInterceptor {
    private List<String> includeUrls;
    @Autowired
    private RemoteWeixinMethod remoteWeixinMethod;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object object) throws Exception {
        String requestPath = ResourceUtil.getRequestPath(request);
        if (this.includeUrls.contains(requestPath)) {
            String openid = oConvertUtils.isEmpty(request.getParameter("openid")) ? ResourceUtil.getUserOpenId() : request.getParameter("openid");
            String backUrl = WeixinUtil.getRequestUrlWithParams((HttpServletRequest)request);
            String accountid = request.getParameter("accountid");
            String outer_link_deal = null;
            if (oConvertUtils.isEmpty(openid)) {
                outer_link_deal = this.remoteWeixinMethod.callWeixinAuthor2ReturnUrl(request, accountid, backUrl);
                if (oConvertUtils.isNotEmpty(outer_link_deal)) {
                    response.sendRedirect(outer_link_deal);
                    return false;
                }
                request.setAttribute("openid", (Object)ResourceUtil.getUserOpenId());
            }
            return true;
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object object, Exception exception) throws Exception {
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object object, ModelAndView modelAndView) throws Exception {
    }

    public List<String> getIncludeUrls() {
        return this.includeUrls;
    }

    public void setIncludeUrls(List<String> includeUrls) {
        this.includeUrls = includeUrls;
    }
}

