/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.interceptors;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.jeecgframework.core.common.model.json.LogAnnotation;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class LogInterceptor {
    private SystemService systemService;

    public SystemService getSystemService() {
        return this.systemService;
    }

    @Autowired
    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    @Before(value="execution(* weixin.guanjia.account.service.*.*(..))")
    public void beforeMethod(JoinPoint joinPoint) throws Exception {
        String temp = joinPoint.getStaticPart().toShortString();
        String longTemp = joinPoint.getStaticPart().toLongString();
        joinPoint.getStaticPart().toString();
        String classType = joinPoint.getTarget().getClass().getName();
        String methodName = temp.substring(10, temp.length() - 1);
        Class<?> className = Class.forName(classType);
        Class[] args = new Class[joinPoint.getArgs().length];
        String[] sArgs = longTemp.substring(longTemp.lastIndexOf("(") + 1, longTemp.length() - 2).split(",");
        int i = 0;
        while (i < args.length) {
            if (sArgs[i].endsWith("String[]")) {
                args[i] = Array.newInstance(Class.forName("java.lang.String"), 1).getClass();
            } else if (sArgs[i].endsWith("Long[]")) {
                args[i] = Array.newInstance(Class.forName("java.lang.Long"), 1).getClass();
            } else if (sArgs[i].indexOf(".") == -1) {
                if (sArgs[i].equals("int")) {
                    args[i] = Integer.TYPE;
                } else if (sArgs[i].equals("char")) {
                    args[i] = Character.TYPE;
                } else if (sArgs[i].equals("float")) {
                    args[i] = Float.TYPE;
                } else if (sArgs[i].equals("long")) {
                    args[i] = Long.TYPE;
                }
            } else {
                args[i] = Class.forName(sArgs[i]);
            }
            ++i;
        }
        Method method = className.getMethod(methodName.substring(methodName.indexOf(".") + 1, methodName.indexOf("(")), args);
        if (method.isAnnotationPresent(LogAnnotation.class)) {
            LogAnnotation logAnnotation = method.getAnnotation(LogAnnotation.class);
            String operateModelNm = logAnnotation.operateModelNm();
            String operateDescribe = logAnnotation.operateDescribe();
            String operateFuncNm = logAnnotation.operateFuncNm();
            LogUtil.info(String.valueOf(operateModelNm) + "--" + operateDescribe + "--" + operateFuncNm);
        }
    }
}

