/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jeecgframework.core.groovy.GroovyBinding;
import org.jeecgframework.core.groovy.IScript;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class GroovyScriptEngine
implements BeanPostProcessor {
    private Log logger = LogFactory.getLog(GroovyScriptEngine.class);
    public GroovyBinding binding = new GroovyBinding();

    public void execute(String script, Map<String, Object> vars) {
        this.executeObject(script, vars);
    }

    private void setParameters(GroovyShell shell, Map<String, Object> vars) {
        if (vars == null) {
            return;
        }
        Set<Map.Entry<String, Object>> set = vars.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            shell.setVariable(entry.getKey(), entry.getValue());
        }
    }

    public boolean executeBoolean(String script, Map<String, Object> vars) {
        Boolean rtn = (Boolean)this.executeObject(script, vars);
        return rtn;
    }

    public String executeString(String script, Map<String, Object> vars) {
        String str = (String)this.executeObject(script, vars);
        return str;
    }

    public int executeInt(String script, Map<String, Object> vars) {
        Integer rtn = (Integer)this.executeObject(script, vars);
        return rtn;
    }

    public float executeFloat(String script, Map<String, Object> vars) {
        Float rtn = (Float)this.executeObject(script, vars);
        return rtn.floatValue();
    }

    public Object executeObject(String script, Map<String, Object> vars) {
        this.logger.debug((Object)("\u6267\u884c:" + script));
        this.binding.clearVariables();
        GroovyShell shell = new GroovyShell((Binding)this.binding);
        this.setParameters(shell, vars);
        script = script.replace("&apos;", "'").replace("&quot;", "\"").replace("&gt;", ">").replace("&lt;", "<").replace("&nuot;", "\n").replace("&amp;", "&");
        Object rtn = shell.evaluate(script);
        return rtn;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        boolean isImplScript = bean.getClass().isInstance(IScript.class);
        if (isImplScript) {
            this.binding.setProperty(beanName, bean);
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

