/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.extend.template;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Stack;
import java.util.Vector;
import org.jeecgframework.core.util.LogUtil;

public class Caculator {
    public static NumberFormat nfd = NumberFormat.getNumberInstance();
    public static NumberFormat nfi = NumberFormat.getNumberInstance();
    public static DecimalFormat dfd = (DecimalFormat)nfd;
    public static DecimalFormat dfi = (DecimalFormat)nfi;
    Stack<Item> opStack = new Stack();
    Vector<Item> calcStack = new Vector();

    static {
        dfd.applyPattern("######.00");
        dfi.applyPattern("######");
    }

    public String calc() {
        Stack<Item> tmp = new Stack<Item>();
        while (!this.calcStack.isEmpty()) {
            Item it = this.calcStack.remove(0);
            if (!it.ops) {
                tmp.push(it);
                continue;
            }
            double op2 = ((Item)tmp.pop()).value;
            double op1 = 0.0;
            if (!tmp.isEmpty()) {
                op1 = ((Item)tmp.pop()).value;
            }
            Item newItem = new Item();
            newItem.ops = true;
            switch (it.opVal.charValue()) {
                case '+': {
                    newItem.value = op1 + op2;
                    break;
                }
                case '-': {
                    newItem.value = op1 - op2;
                    break;
                }
                case '*': {
                    newItem.value = op1 * op2;
                    break;
                }
                case '/': {
                    newItem.value = op1 / op2;
                    if (newItem.value != Double.NEGATIVE_INFINITY && newItem.value != Double.POSITIVE_INFINITY && !new Double(newItem.value).toString().equals("NaN")) break;
                    newItem.value = 0.0;
                }
            }
            tmp.push(newItem);
        }
        Double result = ((Item)tmp.pop()).value;
        return Caculator.getDtoI(result);
    }

    public static String getDtoI(Double d) {
        double c = 0.0;
        long b = Math.round(d * 100.0);
        if (b % 100L != 0L) {
            c = (double)b / 100.0;
            return dfd.format(c);
        }
        c = (double)b / 100.0;
        return dfi.format(c);
    }

    public String transInfixToPosfix(String in) {
        char[] cin = in.toCharArray();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < cin.length) {
            Item newItem = new Item();
            newItem.opPriority = 1;
            newItem.ops = false;
            switch (cin[i]) {
                case '+': {
                    newItem.opPriority = 1;
                    newItem.ops = true;
                    newItem.opVal = Character.valueOf('+');
                    this.doOps(buffer, newItem);
                    break;
                }
                case '-': {
                    newItem.opPriority = 1;
                    newItem.ops = true;
                    newItem.opVal = Character.valueOf('-');
                    this.doOps(buffer, newItem);
                    break;
                }
                case '*': {
                    newItem.opPriority = 2;
                    newItem.ops = true;
                    newItem.opVal = Character.valueOf('*');
                    this.doOps(buffer, newItem);
                    break;
                }
                case '/': {
                    newItem.opPriority = 2;
                    newItem.ops = true;
                    newItem.opVal = Character.valueOf('/');
                    this.doOps(buffer, newItem);
                    break;
                }
                case '(': {
                    newItem.ops = true;
                    newItem.opVal = Character.valueOf('(');
                    this.opStack.push(newItem);
                    break;
                }
                case ')': {
                    boolean meetClose = false;
                    while (!this.opStack.isEmpty()) {
                        Item item = this.opStack.peek();
                        if (item.ops && item.opVal.charValue() != '(') {
                            this.calcStack.add(item);
                            this.opStack.pop();
                            buffer.append(item.opVal);
                            continue;
                        }
                        if (!item.ops) continue;
                        this.opStack.pop();
                        meetClose = true;
                        break;
                    }
                    if (meetClose) break;
                    LogUtil.info(in);
                    throw new RuntimeException();
                }
                default: {
                    int j = i;
                    while (j < cin.length && (cin[j] >= '0' && cin[j] <= '9' || cin[j] == '.' || cin[j] == 'E')) {
                        ++j;
                    }
                    if (j == i) {
                        throw new RuntimeException("wrong input.");
                    }
                    newItem.ops = false;
                    try {
                        newItem.value = Double.parseDouble(new String(cin, i, j - i));
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        LogUtil.info("cal\u6570\u5b57\u751f\u6210\u9519\u8bef\uff01\uff01");
                    }
                    buffer.append(newItem.value);
                    this.calcStack.add(newItem);
                    i = j - 1;
                }
            }
            ++i;
        }
        while (!this.opStack.isEmpty()) {
            Item item = this.opStack.pop();
            this.calcStack.add(item);
            buffer.append(item.opVal);
        }
        return buffer.toString();
    }

    private void doOps(StringBuffer buffer, Item newItem) {
        while (!this.opStack.isEmpty()) {
            Item item = this.opStack.peek();
            if (item.opVal.charValue() == '(' || item.opPriority < newItem.opPriority) break;
            this.calcStack.add(item);
            this.opStack.pop();
            buffer.append(item.opVal);
        }
        this.opStack.push(newItem);
    }

    public static void main(String[] args) {
        Caculator calc = new Caculator();
        LogUtil.info(calc.transInfixToPosfix("1.3E7+0.5"));
        LogUtil.info("value is:" + calc.calc());
        Double dd = Double.parseDouble("1.35378957E7");
        LogUtil.info(Caculator.getDtoI(dd));
        LogUtil.info(dd);
    }

    class Item {
        boolean ops;
        double value;
        Character opVal;
        int opPriority;

        Item() {
        }
    }
}

