/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.extend.swftools;

import java.io.File;
import java.io.FileNotFoundException;
import org.artofsolving.jodconverter.OfficeDocumentConverter;
import org.artofsolving.jodconverter.office.DefaultOfficeManagerConfiguration;
import org.artofsolving.jodconverter.office.OfficeManager;
import org.jeecgframework.core.extend.swftools.ConStant;
import org.jeecgframework.core.extend.swftools.PDFConverter;
import org.jeecgframework.core.util.FileUtils;
import org.jeecgframework.core.util.LogUtil;

public class OpenOfficePDFConverter
implements PDFConverter {
    private static OfficeManager officeManager;
    private static String OFFICE_HOME;
    private static int[] port;

    static {
        OFFICE_HOME = ConStant.OFFICE_HOME;
        port = new int[]{8100};
    }

    @Override
    public void convert2PDF(String inputFile, String pdfFile, String extend) {
        if (extend.equals("txt")) {
            String odtFile = String.valueOf(FileUtils.getFilePrefix(inputFile)) + ".odt";
            if (new File(odtFile).exists()) {
                LogUtil.info("odt\u6587\u4ef6\u5df2\u5b58\u5728\uff01");
                inputFile = odtFile;
            } else {
                try {
                    FileUtils.copyFile(inputFile, odtFile);
                    inputFile = odtFile;
                }
                catch (FileNotFoundException e) {
                    LogUtil.info("Odt\u6587\u6863\u4e0d\u5b58\u5728\uff01");
                    e.printStackTrace();
                }
            }
        }
        OpenOfficePDFConverter.startService();
        LogUtil.info("\u8fdb\u884c\u6587\u6863\u8f6c\u6362\u8f6c\u6362:" + inputFile + " --> " + pdfFile);
        OfficeDocumentConverter converter = new OfficeDocumentConverter(officeManager);
        try {
            converter.convert(new File(inputFile), new File(pdfFile));
        }
        catch (Exception e) {
            LogUtil.info(e.getMessage());
        }
        OpenOfficePDFConverter.stopService();
        LogUtil.info("\u8fdb\u884c\u6587\u6863\u8f6c\u6362\u8f6c\u6362---- \u7ed3\u675f----");
    }

    @Override
    public void convert2PDF(String inputFile, String extend) {
        String pdfFile = String.valueOf(FileUtils.getFilePrefix2(inputFile)) + ".pdf";
        this.convert2PDF(inputFile, pdfFile, extend);
    }

    public static void startService() {
        DefaultOfficeManagerConfiguration configuration = new DefaultOfficeManagerConfiguration();
        try {
            configuration.setOfficeHome(OFFICE_HOME);
            configuration.setPortNumbers(port);
            configuration.setTaskExecutionTimeout(300000L);
            configuration.setTaskQueueTimeout(86400000L);
            officeManager = configuration.buildOfficeManager();
            officeManager.start();
            LogUtil.info("office\u8f6c\u6362\u670d\u52a1\u542f\u52a8\u6210\u529f!");
        }
        catch (Exception ce) {
            LogUtil.info("office\u8f6c\u6362\u670d\u52a1\u542f\u52a8\u5931\u8d25!\u8be6\u7ec6\u4fe1\u606f:" + ce);
        }
    }

    public static void stopService() {
        LogUtil.info("\u5173\u95edoffice\u8f6c\u6362\u670d\u52a1....");
        if (officeManager != null) {
            officeManager.stop();
        }
        LogUtil.info("\u5173\u95edoffice\u8f6c\u6362\u6210\u529f!");
    }
}

