/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.extend.hqlsearch.parse.impl;

import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.extend.hqlsearch.parse.IHqlParse;

public class StringParseImpl
implements IHqlParse {
    private static final String SUFFIX_COMMA = ",";
    private static final String SUFFIX_KG = " ";
    private static final String SUFFIX_ASTERISK = "*";
    private static final String SUFFIX_ASTERISK_VAGUE = "%";
    private static final String SUFFIX_NOT_EQUAL = "!";
    private static final String SUFFIX_NOT_EQUAL_NULL = "!NULL";

    @Override
    public void addCriteria(CriteriaQuery cq, String name, Object value) {
        String searchValue = null;
        if (value != null && (searchValue = value.toString().trim()) != "") {
            if (searchValue.indexOf(SUFFIX_COMMA) >= 0) {
                if (searchValue.indexOf(SUFFIX_KG) >= 0) {
                    String val = searchValue.substring(searchValue.indexOf(SUFFIX_KG));
                    cq.eq(name, val);
                } else {
                    Object[] vs = searchValue.split(SUFFIX_COMMA);
                    cq.in(name, vs);
                }
            } else if (searchValue.indexOf(SUFFIX_ASTERISK) >= 0) {
                cq.like(name, searchValue.replace(SUFFIX_ASTERISK, SUFFIX_ASTERISK_VAGUE));
            } else if (searchValue.equals(SUFFIX_NOT_EQUAL)) {
                cq.isNotNull(name);
            } else if (searchValue.toUpperCase().equals(SUFFIX_NOT_EQUAL_NULL)) {
                cq.isNotNull(name);
            } else if (searchValue.indexOf(SUFFIX_NOT_EQUAL) >= 0) {
                cq.notEq(name, searchValue.replace(SUFFIX_NOT_EQUAL, ""));
            } else {
                cq.like(name, SUFFIX_ASTERISK_VAGUE + searchValue + SUFFIX_ASTERISK_VAGUE);
            }
        }
    }

    @Override
    public void addCriteria(CriteriaQuery cq, String name, Object value, String beginValue, String endValue) {
        this.addCriteria(cq, name, value);
    }
}

