/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.extend.hqlsearch;

import java.beans.PropertyDescriptor;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.jeecgframework.core.annotation.query.QueryTimeFormat;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.extend.hqlsearch.parse.IHqlParse;
import org.jeecgframework.core.extend.hqlsearch.parse.impl.BigDecimalParseImpl;
import org.jeecgframework.core.extend.hqlsearch.parse.impl.DoubleParseImpl;
import org.jeecgframework.core.extend.hqlsearch.parse.impl.FloatParseImpl;
import org.jeecgframework.core.extend.hqlsearch.parse.impl.IntegerParseImpl;
import org.jeecgframework.core.extend.hqlsearch.parse.impl.LongParseImpl;
import org.jeecgframework.core.extend.hqlsearch.parse.impl.ShortParseImpl;
import org.jeecgframework.core.extend.hqlsearch.parse.impl.StringParseImpl;
import org.jeecgframework.core.util.StringUtil;

public class HqlGenerateUtil {
    private static final String END = "_end";
    private static final String BEGIN = "_begin";
    private static Map<String, IHqlParse> map = new HashMap<String, IHqlParse>();
    private static final SimpleDateFormat time = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private static final SimpleDateFormat day = new SimpleDateFormat("yyyy-MM-dd");

    static {
        map.put("class java.lang.Integer", new IntegerParseImpl());
        map.put("class java.lang.Short", new ShortParseImpl());
        map.put("class java.lang.String", new StringParseImpl());
        map.put("class java.lang.Long", new LongParseImpl());
        map.put("class java.lang.Double", new DoubleParseImpl());
        map.put("class java.lang.Float", new FloatParseImpl());
        map.put("class java.math.BigDecimal", new BigDecimalParseImpl());
    }

    public static void installHql(CriteriaQuery cq, Object searchObj) {
        HqlGenerateUtil.installHqlJoinAlias(cq, searchObj, null, "");
        cq.add();
    }

    public static void installHql(CriteriaQuery cq, Object searchObj, Map<String, String[]> parameterMap) {
        HqlGenerateUtil.installHqlJoinAlias(cq, searchObj, parameterMap, "");
        cq.add();
    }

    private static void installHqlJoinAlias(CriteriaQuery cq, Object searchObj, Map<String, String[]> parameterMap, String alias) {
        PropertyDescriptor[] origDescriptors = PropertyUtils.getPropertyDescriptors((Object)searchObj);
        int i = 0;
        while (i < origDescriptors.length) {
            String aliasName = String.valueOf(alias.equals("") ? "" : String.valueOf(alias) + ".") + origDescriptors[i].getName();
            String name = origDescriptors[i].getName();
            String type = origDescriptors[i].getPropertyType().toString();
            try {
                if (!HqlGenerateUtil.judgedIsUselessField(name) && PropertyUtils.isReadable((Object)searchObj, (String)name)) {
                    Object param;
                    String beginValue = null;
                    String endValue = null;
                    if (parameterMap != null && parameterMap.containsKey(String.valueOf(name) + BEGIN)) {
                        beginValue = parameterMap.get(String.valueOf(name) + BEGIN)[0].trim();
                    }
                    if (parameterMap != null && parameterMap.containsKey(String.valueOf(name) + END)) {
                        endValue = parameterMap.get(String.valueOf(name) + END)[0].trim();
                    }
                    Object value = PropertyUtils.getSimpleProperty((Object)searchObj, (String)name);
                    if (type.contains("class java.lang") || type.contains("class java.math")) {
                        if (parameterMap == null) {
                            map.get(type).addCriteria(cq, aliasName, value);
                        } else {
                            map.get(type).addCriteria(cq, aliasName, value, beginValue, endValue);
                        }
                    } else if ("class java.util.Date".equals(type)) {
                        QueryTimeFormat format = origDescriptors[i].getReadMethod().getAnnotation(QueryTimeFormat.class);
                        SimpleDateFormat userDefined = null;
                        if (format != null) {
                            userDefined = new SimpleDateFormat(format.format());
                        }
                        if (StringUtils.isNotBlank((String)beginValue)) {
                            if (userDefined != null) {
                                cq.ge(aliasName, time.parse(beginValue));
                            } else if (beginValue.length() == 19) {
                                cq.ge(aliasName, time.parse(beginValue));
                            } else if (beginValue.length() == 10) {
                                cq.ge(aliasName, day.parse(beginValue));
                            }
                        }
                        if (StringUtils.isNotBlank((String)endValue)) {
                            if (userDefined != null) {
                                cq.ge(aliasName, time.parse(beginValue));
                            } else if (endValue.length() == 19) {
                                cq.le(aliasName, time.parse(endValue));
                            } else if (endValue.length() == 10) {
                                cq.le(aliasName, time.parse(String.valueOf(endValue) + " 23:23:59"));
                            }
                        }
                        if (HqlGenerateUtil.isNotEmpty(value)) {
                            cq.eq(aliasName, value);
                        }
                    } else if (!StringUtil.isJavaClass(origDescriptors[i].getPropertyType()) && HqlGenerateUtil.isNotEmpty(param = PropertyUtils.getSimpleProperty((Object)searchObj, (String)name)) && HqlGenerateUtil.itIsNotAllEmpty(param)) {
                        cq.createAlias(aliasName, aliasName.replaceAll("\\.", "_"));
                        HqlGenerateUtil.installHqlJoinAlias(cq, param, parameterMap, aliasName);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private static boolean judgedIsUselessField(String name) {
        return "class".equals(name) || "ids".equals(name) || "page".equals(name) || "rows".equals(name) || "sort".equals(name) || "order".equals(name);
    }

    public static boolean isNotEmpty(Object value) {
        return value != null && !"".equals(value);
    }

    private static boolean itIsNotAllEmpty(Object param) {
        boolean isNotEmpty = false;
        try {
            PropertyDescriptor[] origDescriptors = PropertyUtils.getPropertyDescriptors((Object)param);
            int i = 0;
            while (i < origDescriptors.length) {
                String name = origDescriptors[i].getName();
                if (!"class".equals(name) && PropertyUtils.isReadable((Object)param, (String)name)) {
                    if (Map.class.isAssignableFrom(origDescriptors[i].getPropertyType())) {
                        Map map = (Map)PropertyUtils.getSimpleProperty((Object)param, (String)name);
                        if (map != null && map.size() > 0) {
                            isNotEmpty = true;
                            break;
                        }
                    } else if (Collection.class.isAssignableFrom(origDescriptors[i].getPropertyType())) {
                        Collection c = (Collection)PropertyUtils.getSimpleProperty((Object)param, (String)name);
                        if (c != null && c.size() > 0) {
                            isNotEmpty = true;
                            break;
                        }
                    } else if (StringUtil.isNotEmpty(PropertyUtils.getSimpleProperty((Object)param, (String)name))) {
                        isNotEmpty = true;
                        break;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isNotEmpty;
    }
}

