/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.common.hibernate.qbc;

import java.util.Map;

public class Pager {
    private int curPageNO = 1;
    private int pageSize;
    private int rowsCount;
    private int pageCount;
    private Map<String, Object> map;

    public Pager(int allCount, int curPagerNo, int pageSize, Map<String, Object> map) {
        this.curPageNO = curPagerNo;
        this.pageSize = pageSize;
        this.rowsCount = allCount;
        this.map = map;
        this.pageCount = (int)Math.ceil((double)allCount / (double)pageSize);
    }

    public Pager() {
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getRowsCount() {
        return this.rowsCount;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int first() {
        return 1;
    }

    public int last() {
        return this.pageCount;
    }

    public int previous() {
        return this.curPageNO - 1 < 1 ? 1 : this.curPageNO - 1;
    }

    public int next() {
        return this.curPageNO + 1 > this.pageCount ? this.pageCount : this.curPageNO + 1;
    }

    public boolean isFirst() {
        return this.curPageNO == 1;
    }

    public boolean isLast() {
        return this.curPageNO == this.pageCount;
    }

    public String toString() {
        return "Pager\u7684\u503c\u4e3a  curPageNO = " + this.curPageNO + " limit = " + this.pageSize + " rowsCount = " + this.rowsCount + " pageCount = " + this.pageCount;
    }

    public String getToolBar(String url) {
        String temp = "";
        String conditions = "";
        if (this.map.size() > 0) {
            for (Map.Entry<String, Object> entry : this.map.entrySet()) {
                conditions = String.valueOf(conditions) + "&" + entry.getKey() + "=" + entry.getValue();
            }
        }
        temp = url.indexOf("?") == -1 ? "?" : "&";
        String str = "";
        str = String.valueOf(str);
        if (this.isFirst()) {
            str = String.valueOf(str) + "\u7b2c" + this.curPageNO + "\u9875&nbsp;\u5171" + this.pageCount + "\u9875&nbsp;\u9996\u9875 \u4e0a\u4e00\u9875&nbsp;";
        } else {
            str = String.valueOf(str) + "\u7b2c" + this.curPageNO + "\u9875&nbsp;\u5171" + this.pageCount + "\u9875&nbsp;<a href='" + url + temp + "curPageNO=1" + conditions + "'>\u9996\u9875</a>&nbsp;";
            str = String.valueOf(str) + "<a href='" + url + temp + "curPageNO=" + this.previous() + conditions + "' onMouseMove=\"style.cursor='hand'\" alt=\"\u4e0a\u4e00\u9875\">\u4e0a\u4e00\u9875</a>&nbsp;";
        }
        if (this.isLast() || this.rowsCount == 0) {
            str = String.valueOf(str) + "\u4e0b\u4e00\u9875 \u5c3e\u9875&nbsp;";
        } else {
            str = String.valueOf(str) + "<a href='" + url + temp + "curPageNO=" + this.next() + conditions + "' onMouseMove=\"style.cursor='hand'\" >\u4e0b\u4e00\u9875</a>&nbsp;";
            str = String.valueOf(str) + "<a href='" + url + temp + "curPageNO=" + this.pageCount + conditions + "'>\u5c3e\u9875</a>&nbsp;";
        }
        str = String.valueOf(str) + "&nbsp;\u5171" + this.rowsCount + "\u6761\u8bb0\u5f55&nbsp;";
        str = String.valueOf(str) + "&nbsp;\u8f6c\u5230<select name='page' onChange=\"location='" + url + temp + "curPageNO='+this.options[this.selectedIndex].value\">";
        int begin = this.curPageNO > 10 ? this.curPageNO - 10 : 1;
        int end = this.pageCount - this.curPageNO > 10 ? this.curPageNO + 10 : this.pageCount;
        int i = begin;
        while (i <= end) {
            str = i == this.curPageNO ? String.valueOf(str) + "<option value='" + i + "' selected>\u7b2c" + i + "\u9875</option>" : String.valueOf(str) + "<option value='" + i + "'>\u7b2c" + i + "\u9875</option>";
            ++i;
        }
        str = String.valueOf(str) + "</select>";
        return str;
    }

    public String getToolBar(String myaction, String myform) {
        String str = "";
        str = String.valueOf(str) + "<script language='javascript'>\n";
        str = String.valueOf(str) + "function commonSubmit(val){\n";
        str = String.valueOf(str) + "var patrn=/^[0-9]{1,20}$/;\n";
        str = String.valueOf(str) + "if (!patrn.exec(val)){\n";
        str = String.valueOf(str) + " alert(\"\u8bf7\u8f93\u5165\u6709\u6548\u9875\u53f7\uff01\");\n";
        str = String.valueOf(str) + " return false ;\n";
        str = String.valueOf(str) + " }else{\n";
        str = String.valueOf(str) + "    document." + myform + ".action='" + myaction + "&curPageNO='+val;" + "\n";
        str = String.valueOf(str) + "    document." + myform + ".submit();" + "\n";
        str = String.valueOf(str) + "    return true ;\n";
        str = String.valueOf(str) + "} \n";
        str = String.valueOf(str) + " }\n";
        str = String.valueOf(str) + "</script>\n";
        str = String.valueOf(str) + "&nbsp;<DIV class=pageArea id=pageArea>\u5171<b>" + this.rowsCount + "</b>\u6761&nbsp;\u5f53\u524d\u7b2c" + this.curPageNO + "/" + this.pageCount + "\u9875&nbsp;&nbsp;&nbsp;";
        if (this.curPageNO == 1 || this.curPageNO == 0) {
            str = String.valueOf(str) + "<a class=pageFirstDisable title=\u9996\u9875 onMouseMove=\"style.cursor='hand'\">&nbsp;<a class=pagePreviousDisable title=\u4e0a\u4e00\u9875 onMouseMove=\"style.cursor='hand'\"></a>";
        } else {
            str = String.valueOf(str) + "<a class=pageFirst title=\u9996\u9875 onMouseMove=\"style.cursor='hand'\" onclick=\"commonSubmit(1)\"></a>";
            str = String.valueOf(str) + "<a class=pagePrevious title=\u4e0a\u4e00\u9875 onMouseMove=\"style.cursor='hand'\" onclick=\"commonSubmit(" + (this.curPageNO - 1) + ")\"></a>";
        }
        if (this.curPageNO - this.pageCount == 0 || this.pageCount == 0 || this.pageCount == 1) {
            str = String.valueOf(str) + "<a class=pageNextDisable  title=\u4e0b\u4e00\u9875 onMouseMove=\"style.cursor='hand'\">&nbsp;<a class=pageLastDisable title=\u5c3e\u9875 onMouseMove=\"style.cursor='hand'\"></a>&nbsp;";
        } else {
            str = String.valueOf(str) + "<a class=pageNext title=\u4e0b\u4e00\u9875 onMouseMove=\"style.cursor='hand'\" onclick=\"commonSubmit(" + (this.curPageNO + 1) + ")\"></a>";
            str = String.valueOf(str) + "<a class=pageLast title=\u5c3e\u9875 onMouseMove=\"style.cursor='hand'\" onclick=\"commonSubmit(" + this.pageCount + ")\"></a>";
        }
        if (this.pageCount == 1 || this.pageCount == 0) {
            str = String.valueOf(str) + " &nbsp;\u8f6c\u5230:<input class=SmallInput type=text style=TEXT-ALIGN: center maxLength=5 name=\"pageroffsetll\" size=3 onKeyPress=\"if (event.keyCode == 13) return commonSubmit(document.all.pageroffsetll.value)\" > \u9875&nbsp;";
            str = String.valueOf(str) + "<A class=pageGoto id=pageGoto title=\u8f6c\u5230 onclick='return commonSubmit()'></A></DIV>";
        } else {
            str = String.valueOf(str) + " &nbsp;\u8f6c\u5230:<input class=SmallInput type=text style=TEXT-ALIGN: center maxLength=5 name=\"pageroffsetll\" size=3 onKeyPress=\"if (event.keyCode == 13) return commonSubmit(document.all.pageroffsetll.value)\" > \u9875&nbsp;";
            str = String.valueOf(str) + "<A class=pageGoto id=pageGoto title=\u8f6c\u5230 onclick='commonSubmit(document.all.pageroffsetll.value)'></A></DIV>";
        }
        return str;
    }
}

