/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.common.hibernate.qbc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.FetchMode;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.jeecgframework.core.common.hibernate.qbc.AliasToBean;
import org.jeecgframework.core.util.ContextHolderUtils;
import org.jeecgframework.core.util.StringUtil;

public class DetachedCriteriaUtil {
    public static final String MIDDLE_SEPRATOR_CHAR = "x";
    public static final String SEPARATOR_TWO_SPACE = "  ";
    public static ProjectionList projectionList;
    private static final String ALIAS_KEY_IN_REQUEST = "ALIAS_KEY_IN_REQUEST";
    private static final String HAS_JOIN_TABLE_KEY_IN_REQUEST = "HAS_JOIN_TABLE_KEY_IN_REQUEST";
    private static final String POINT = ".";

    public static ProjectionList getProjectionList() {
        return projectionList;
    }

    private DetachedCriteriaUtil() {
    }

    public static DetachedCriteria createDetachedCriteria(Class<?> pojoClazz, String startChar, String alias) {
        return DetachedCriteriaUtil.createDetachedCriteria(pojoClazz, startChar, alias, null);
    }

    public static DetachedCriteria createDetachedCriteria(Class<?> pojoClazz, String startChar, String alias, String[] columnNames) {
        return DetachedCriteriaUtil.createDetachedCriteria(pojoClazz, startChar, alias, columnNames, null);
    }

    public static DetachedCriteria createDetachedCriteria(Class<?> pojoClazz, String startChar, String alias, String[] columnNames, String[] excludeParameters) {
        DetachedCriteria criteria = DetachedCriteria.forClass(pojoClazz, (String)alias);
        if (columnNames != null) {
            int cfr_ignored_0 = columnNames.length;
        }
        return criteria;
    }

    private static void setAliasToRequest(HttpServletRequest request, Set<String> aliases) {
        request.setAttribute(ALIAS_KEY_IN_REQUEST, aliases);
    }

    private static Set<String> getAliasesFromRequest() {
        HashSet<String> aliases = (HashSet<String>)ContextHolderUtils.getRequest().getAttribute(ALIAS_KEY_IN_REQUEST);
        if (aliases == null) {
            aliases = new HashSet<String>(5);
            DetachedCriteriaUtil.setAliasToRequest(ContextHolderUtils.getRequest(), aliases);
        }
        return aliases;
    }

    private static boolean getHasJoinTatleFromRequest() {
        Boolean hasJoin = (Boolean)ContextHolderUtils.getRequest().getAttribute(HAS_JOIN_TABLE_KEY_IN_REQUEST);
        return hasJoin == null ? false : hasJoin;
    }

    public static void selectColumn(DetachedCriteria criteria, String[] columnNames, Class<?> pojoClass, boolean forJoinTable) {
        if (columnNames == null) {
            return;
        }
        ArrayList<Projection> tempProjectionList = new ArrayList<Projection>();
        Set<String> aliases = DetachedCriteriaUtil.getAliasesFromRequest();
        boolean hasJoniTable = false;
        String rootAlias = criteria.getAlias();
        String[] stringArray = columnNames;
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            if (property.contains("_")) {
                String[] propertyChain = property.split("_");
                DetachedCriteriaUtil.createAlias(criteria, rootAlias, aliases, propertyChain, 0);
                tempProjectionList.add(Projections.property((String)StringUtil.getProperty(property)).as(StringUtil.getProperty(property)));
                hasJoniTable = true;
            } else {
                tempProjectionList.add(Projections.property((String)(String.valueOf(rootAlias) + POINT + property)).as(property));
            }
            ++n2;
        }
        projectionList = Projections.projectionList();
        if (hasJoniTable || forJoinTable || DetachedCriteriaUtil.getHasJoinTatleFromRequest()) {
            projectionList.add(Projections.distinct((Projection)Projections.id()));
        }
        for (Projection proj : tempProjectionList) {
            projectionList.add(proj);
        }
        criteria.setProjection((Projection)projectionList);
        if (!hasJoniTable) {
            criteria.setResultTransformer(Transformers.aliasToBean(pojoClass));
        } else {
            criteria.setResultTransformer((ResultTransformer)new AliasToBean(pojoClass));
        }
    }

    private static void createAlias(DetachedCriteria criteria, String rootAlais, Set<String> aliases, String[] columns, int currentStep) {
        if (currentStep < columns.length - 1) {
            if (!aliases.contains(DetachedCriteriaUtil.converArrayToAlias(columns, currentStep))) {
                if (currentStep > 0) {
                    criteria.createAlias(String.valueOf(DetachedCriteriaUtil.converArrayToAlias(columns, currentStep - 1)) + POINT + columns[currentStep], DetachedCriteriaUtil.converArrayToAlias(columns, currentStep)).setFetchMode(columns[currentStep], FetchMode.JOIN);
                } else {
                    criteria.createAlias(String.valueOf(rootAlais) + POINT + columns[currentStep], DetachedCriteriaUtil.converArrayToAlias(columns, currentStep)).setFetchMode(columns[currentStep], FetchMode.JOIN);
                }
                aliases.add(DetachedCriteriaUtil.converArrayToAlias(columns, currentStep));
            }
            DetachedCriteriaUtil.createAlias(criteria, rootAlais, aliases, columns, ++currentStep);
        }
    }

    public static String getAliasFromPropertyChainString(String property) {
        if (property.contains(POINT)) {
            return String.valueOf(property.substring(0, property.lastIndexOf(POINT)).replaceAll("\\.", "_")) + property.substring(property.lastIndexOf(POINT));
        }
        return property;
    }

    private static String converArrayToAlias(String[] columns, int currentStep) {
        StringBuilder alias = new StringBuilder();
        int i = 0;
        while (i <= currentStep) {
            if (alias.length() > 0) {
                alias.append("_");
            }
            alias.append(columns[i]);
            ++i;
        }
        return alias.toString();
    }
}

